"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const kinesis = require("@aws-cdk/aws-kinesis");
const kinesis_streams_defaults_1 = require("./kinesis-streams-defaults");
const utils_1 = require("./utils");
function buildKinesisStream(scope, props) {
    // If props is undefined, define it
    props = (props === undefined) ? {} : props;
    // Setup the stream properties
    let kinesisStreamProps;
    if (props.hasOwnProperty('kinesisStreamProps')) {
        // If property overrides have been provided, incorporate them and deploy
        kinesisStreamProps = utils_1.overrideProps(kinesis_streams_defaults_1.DefaultStreamProps, props.kinesisStreamProps);
    }
    else {
        // If no property overrides, deploy using the default configuration
        kinesisStreamProps = kinesis_streams_defaults_1.DefaultStreamProps;
    }
    // Set conditional stream encryption properties
    if (!kinesisStreamProps.hasOwnProperty('encryptionKey') && props.hasOwnProperty('kinesisStreamProps')) {
        kinesisStreamProps.encryptionKey = props.encryptionKey;
    }
    // Create the stream and return
    return new kinesis.Stream(scope, 'KinesisStream', kinesisStreamProps);
}
exports.buildKinesisStream = buildKinesisStream;
//# sourceMappingURL=data:application/json;base64,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