"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
function DefaultCfnDeliveryStreamProps(_bucketArn, _roleArn, _logGroupName, _logStreamName) {
    return {
        extendedS3DestinationConfiguration: {
            bucketArn: _bucketArn,
            bufferingHints: {
                intervalInSeconds: 300,
                sizeInMBs: 5
            },
            compressionFormat: 'GZIP',
            roleArn: _roleArn,
            cloudWatchLoggingOptions: {
                enabled: true,
                logGroupName: _logGroupName,
                logStreamName: _logStreamName
            }
        }
    };
}
exports.DefaultCfnDeliveryStreamProps = DefaultCfnDeliveryStreamProps;
//# sourceMappingURL=data:application/json;base64,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