"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const kinesisAnalytics = require("@aws-cdk/aws-kinesisanalytics");
const iam = require("@aws-cdk/aws-iam");
const defaults = require("./kinesis-analytics-defaults");
const utils_1 = require("./utils");
function buildKinesisAnalyticsApp(scope, props) {
    // Setup the IAM role for Kinesis Analytics
    const analyticsRole = new iam.Role(scope, 'KinesisAnalyticsRole', {
        assumedBy: new iam.ServicePrincipal('kinesisanalytics.amazonaws.com'),
    });
    // Setup the IAM policy for Kinesis Analytics
    const analyticsPolicy = new iam.Policy(scope, 'KinesisAnalyticsPolicy', {
        statements: [
            new iam.PolicyStatement({
                actions: [
                    'firehose:DescribeDeliveryStream',
                    'firehose:Get*'
                ],
                resources: [props.kinesisFirehose.attrArn]
            })
        ]
    });
    // Attach policy to role
    analyticsPolicy.attachToRole(analyticsRole);
    // Setup the Kinesis application properties
    const kinesisAnalyticsProps = utils_1.overrideProps(defaults.DefaultCfnApplicationProps, props.kinesisAnalyticsProps);
    kinesisAnalyticsProps.inputs[0].kinesisFirehoseInput = {
        resourceArn: props.kinesisFirehose.attrArn,
        roleArn: analyticsRole.roleArn
    };
    // Setup the Kinesis application and add dependencies
    const kinesisAnalyticsApp = new kinesisAnalytics.CfnApplication(scope, 'KinesisAnalytics', kinesisAnalyticsProps);
    kinesisAnalyticsApp.addDependsOn(analyticsPolicy.node.findChild('Resource'));
    // Create the application and return
    return kinesisAnalyticsApp;
}
exports.buildKinesisAnalyticsApp = buildKinesisAnalyticsApp;
//# sourceMappingURL=data:application/json;base64,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