"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
function DefaultCfnDomainProps(domainName, cognitoKibanaConfigureRole, options) {
    const roleARNs = [];
    roleARNs.push(new iam.ArnPrincipal(options.cognitoAuthorizedRoleARN));
    if (options.serviceRoleARN) {
        roleARNs.push(new iam.ArnPrincipal(options.serviceRoleARN));
    }
    return {
        domainName,
        elasticsearchVersion: '6.3',
        encryptionAtRestOptions: {
            enabled: true
        },
        nodeToNodeEncryptionOptions: {
            enabled: true
        },
        elasticsearchClusterConfig: {
            dedicatedMasterEnabled: true,
            dedicatedMasterCount: 3,
            instanceCount: 3,
            zoneAwarenessEnabled: true,
            zoneAwarenessConfig: {
                availabilityZoneCount: 3
            }
        },
        snapshotOptions: {
            automatedSnapshotStartHour: 1
        },
        ebsOptions: {
            ebsEnabled: true,
            volumeSize: 10
        },
        cognitoOptions: {
            enabled: true,
            identityPoolId: options.identitypool.ref,
            userPoolId: options.userpool.userPoolId,
            roleArn: cognitoKibanaConfigureRole.roleArn
        },
        accessPolicies: new iam.PolicyDocument({
            statements: [
                new iam.PolicyStatement({
                    principals: roleARNs,
                    actions: [
                        'es:ESHttp*'
                    ],
                    resources: [
                        `arn:aws:es:${cdk.Aws.REGION}:${cdk.Aws.ACCOUNT_ID}:domain/${domainName}/*`
                    ]
                })
            ]
        })
    };
}
exports.DefaultCfnDomainProps = DefaultCfnDomainProps;
//# sourceMappingURL=data:application/json;base64,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