"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const DefaultUserPoolProps = {};
exports.DefaultUserPoolProps = DefaultUserPoolProps;
function DefaultIdentityPoolProps(userPoolClientId, userPoolProviderName) {
    return {
        allowUnauthenticatedIdentities: false,
        cognitoIdentityProviders: [{
                clientId: userPoolClientId,
                providerName: userPoolProviderName,
                serverSideTokenCheck: true
            }]
    };
}
exports.DefaultIdentityPoolProps = DefaultIdentityPoolProps;
function DefaultUserPoolClientProps(userpool) {
    return {
        userPool: userpool
    };
}
exports.DefaultUserPoolClientProps = DefaultUserPoolClientProps;
//# sourceMappingURL=data:application/json;base64,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