"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/core");
function DefaultCloudFrontWebDistributionForApiGatewayProps(apiEndPoint, loggingBucket) {
    const apiEndPointUrlWithoutProtocol = cdk.Fn.select(1, cdk.Fn.split("://", apiEndPoint.url));
    const apiEndPointDomainName = cdk.Fn.select(0, cdk.Fn.split("/", apiEndPointUrlWithoutProtocol));
    if (loggingBucket) {
        return {
            originConfigs: [{
                    customOriginSource: {
                        domainName: apiEndPointDomainName
                    },
                    behaviors: [{
                            isDefaultBehavior: true,
                        }]
                }],
            loggingConfig: {
                bucket: loggingBucket
            }
        };
    }
    else {
        return {
            originConfigs: [{
                    customOriginSource: {
                        domainName: apiEndPointDomainName
                    },
                    behaviors: [{
                            isDefaultBehavior: true,
                        }]
                }]
        };
    }
}
exports.DefaultCloudFrontWebDistributionForApiGatewayProps = DefaultCloudFrontWebDistributionForApiGatewayProps;
function DefaultCloudFrontWebDistributionForS3Props(sourceBucket, loggingBucket, _originAccessIdentity) {
    const cfDistributionProps = {
        originConfigs: [{
                s3OriginSource: {
                    s3BucketSource: sourceBucket,
                    originAccessIdentity: _originAccessIdentity
                },
                behaviors: [{
                        isDefaultBehavior: true,
                    }]
            }],
        loggingConfig: {
            bucket: loggingBucket
        }
    };
    return cfDistributionProps;
}
exports.DefaultCloudFrontWebDistributionForS3Props = DefaultCloudFrontWebDistributionForS3Props;
//# sourceMappingURL=data:application/json;base64,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