"use strict";
/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
const api = require("@aws-cdk/aws-apigateway");
function DefaultGlobalLambdaRestApiProps(_existingLambdaObj) {
    const defaultGatewayProps = {
        handler: _existingLambdaObj,
        options: {
            endpointTypes: [api.EndpointType.EDGE],
            cloudWatchRole: false,
            // Configure API Gateway Execution logging
            deployOptions: {
                loggingLevel: api.MethodLoggingLevel.INFO,
                dataTraceEnabled: true
            },
            defaultMethodOptions: {
                authorizationType: api.AuthorizationType.IAM
            }
        }
    };
    return defaultGatewayProps;
}
exports.DefaultGlobalLambdaRestApiProps = DefaultGlobalLambdaRestApiProps;
function DefaultRegionalLambdaRestApiProps(_existingLambdaObj) {
    const defaultGatewayProps = {
        handler: _existingLambdaObj,
        options: {
            endpointTypes: [api.EndpointType.REGIONAL],
            cloudWatchRole: false,
            // Configure API Gateway Execution logging
            deployOptions: {
                loggingLevel: api.MethodLoggingLevel.INFO,
                dataTraceEnabled: true
            },
            defaultMethodOptions: {
                authorizationType: api.AuthorizationType.IAM
            }
        }
    };
    return defaultGatewayProps;
}
exports.DefaultRegionalLambdaRestApiProps = DefaultRegionalLambdaRestApiProps;
function DefaultGlobalApiProps() {
    const defaultGatewayProps = {
        endpointTypes: [api.EndpointType.EDGE],
        cloudWatchRole: false,
        // Configure API Gateway Execution logging
        deployOptions: {
            loggingLevel: api.MethodLoggingLevel.INFO,
            dataTraceEnabled: true
        },
        defaultMethodOptions: {
            authorizationType: api.AuthorizationType.IAM
        }
    };
    return defaultGatewayProps;
}
exports.DefaultGlobalApiProps = DefaultGlobalApiProps;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpZ2F0ZXdheS1kZWZhdWx0cy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFwaWdhdGV3YXktZGVmYXVsdHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7Ozs7OztHQVdHOztBQUVILCtDQUErQztBQUcvQyxTQUFnQiwrQkFBK0IsQ0FBQyxrQkFBbUM7SUFDL0UsTUFBTSxtQkFBbUIsR0FBMkI7UUFDaEQsT0FBTyxFQUFFLGtCQUFrQjtRQUMzQixPQUFPLEVBQUU7WUFDTCxhQUFhLEVBQUUsQ0FBQyxHQUFHLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQztZQUN0QyxjQUFjLEVBQUUsS0FBSztZQUNyQiwwQ0FBMEM7WUFDMUMsYUFBYSxFQUFFO2dCQUNYLFlBQVksRUFBRSxHQUFHLENBQUMsa0JBQWtCLENBQUMsSUFBSTtnQkFDekMsZ0JBQWdCLEVBQUUsSUFBSTthQUN6QjtZQUNELG9CQUFvQixFQUFFO2dCQUNsQixpQkFBaUIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsR0FBRzthQUMvQztTQUNKO0tBQ0osQ0FBQztJQUNGLE9BQU8sbUJBQW1CLENBQUM7QUFDL0IsQ0FBQztBQWpCRCwwRUFpQkM7QUFFRCxTQUFnQixpQ0FBaUMsQ0FBQyxrQkFBbUM7SUFDakYsTUFBTSxtQkFBbUIsR0FBMkI7UUFDaEQsT0FBTyxFQUFFLGtCQUFrQjtRQUMzQixPQUFPLEVBQUU7WUFDTCxhQUFhLEVBQUUsQ0FBQyxHQUFHLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQztZQUMxQyxjQUFjLEVBQUUsS0FBSztZQUNyQiwwQ0FBMEM7WUFDMUMsYUFBYSxFQUFFO2dCQUNYLFlBQVksRUFBRSxHQUFHLENBQUMsa0JBQWtCLENBQUMsSUFBSTtnQkFDekMsZ0JBQWdCLEVBQUUsSUFBSTthQUN6QjtZQUNELG9CQUFvQixFQUFFO2dCQUNsQixpQkFBaUIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsR0FBRzthQUMvQztTQUNKO0tBQ0osQ0FBQztJQUNGLE9BQU8sbUJBQW1CLENBQUM7QUFDL0IsQ0FBQztBQWpCRCw4RUFpQkM7QUFFRCxTQUFnQixxQkFBcUI7SUFDakMsTUFBTSxtQkFBbUIsR0FBcUI7UUFDMUMsYUFBYSxFQUFFLENBQUMsR0FBRyxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUM7UUFDdEMsY0FBYyxFQUFFLEtBQUs7UUFDckIsMENBQTBDO1FBQzFDLGFBQWEsRUFBRTtZQUNYLFlBQVksRUFBRSxHQUFHLENBQUMsa0JBQWtCLENBQUMsSUFBSTtZQUN6QyxnQkFBZ0IsRUFBRSxJQUFJO1NBQ3pCO1FBQ0Qsb0JBQW9CLEVBQUU7WUFDbEIsaUJBQWlCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEdBQUc7U0FDL0M7S0FDSixDQUFDO0lBQ0YsT0FBTyxtQkFBbUIsQ0FBQztBQUMvQixDQUFDO0FBZEQsc0RBY0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqICBDb3B5cmlnaHQgMjAxOSBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbmltcG9ydCAqIGFzIGFwaSBmcm9tICdAYXdzLWNkay9hd3MtYXBpZ2F0ZXdheSc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5cbmV4cG9ydCBmdW5jdGlvbiBEZWZhdWx0R2xvYmFsTGFtYmRhUmVzdEFwaVByb3BzKF9leGlzdGluZ0xhbWJkYU9iajogbGFtYmRhLkZ1bmN0aW9uKSB7XG4gICAgY29uc3QgZGVmYXVsdEdhdGV3YXlQcm9wczogYXBpLkxhbWJkYVJlc3RBcGlQcm9wcyA9IHtcbiAgICAgICAgaGFuZGxlcjogX2V4aXN0aW5nTGFtYmRhT2JqLFxuICAgICAgICBvcHRpb25zOiB7XG4gICAgICAgICAgICBlbmRwb2ludFR5cGVzOiBbYXBpLkVuZHBvaW50VHlwZS5FREdFXSxcbiAgICAgICAgICAgIGNsb3VkV2F0Y2hSb2xlOiBmYWxzZSxcbiAgICAgICAgICAgIC8vIENvbmZpZ3VyZSBBUEkgR2F0ZXdheSBFeGVjdXRpb24gbG9nZ2luZ1xuICAgICAgICAgICAgZGVwbG95T3B0aW9uczoge1xuICAgICAgICAgICAgICAgIGxvZ2dpbmdMZXZlbDogYXBpLk1ldGhvZExvZ2dpbmdMZXZlbC5JTkZPLFxuICAgICAgICAgICAgICAgIGRhdGFUcmFjZUVuYWJsZWQ6IHRydWVcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBkZWZhdWx0TWV0aG9kT3B0aW9uczoge1xuICAgICAgICAgICAgICAgIGF1dGhvcml6YXRpb25UeXBlOiBhcGkuQXV0aG9yaXphdGlvblR5cGUuSUFNXG4gICAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICB9O1xuICAgIHJldHVybiBkZWZhdWx0R2F0ZXdheVByb3BzO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gRGVmYXVsdFJlZ2lvbmFsTGFtYmRhUmVzdEFwaVByb3BzKF9leGlzdGluZ0xhbWJkYU9iajogbGFtYmRhLkZ1bmN0aW9uKSB7XG4gICAgY29uc3QgZGVmYXVsdEdhdGV3YXlQcm9wczogYXBpLkxhbWJkYVJlc3RBcGlQcm9wcyA9IHtcbiAgICAgICAgaGFuZGxlcjogX2V4aXN0aW5nTGFtYmRhT2JqLFxuICAgICAgICBvcHRpb25zOiB7XG4gICAgICAgICAgICBlbmRwb2ludFR5cGVzOiBbYXBpLkVuZHBvaW50VHlwZS5SRUdJT05BTF0sXG4gICAgICAgICAgICBjbG91ZFdhdGNoUm9sZTogZmFsc2UsXG4gICAgICAgICAgICAvLyBDb25maWd1cmUgQVBJIEdhdGV3YXkgRXhlY3V0aW9uIGxvZ2dpbmdcbiAgICAgICAgICAgIGRlcGxveU9wdGlvbnM6IHtcbiAgICAgICAgICAgICAgICBsb2dnaW5nTGV2ZWw6IGFwaS5NZXRob2RMb2dnaW5nTGV2ZWwuSU5GTyxcbiAgICAgICAgICAgICAgICBkYXRhVHJhY2VFbmFibGVkOiB0cnVlXG4gICAgICAgICAgICB9LFxuICAgICAgICAgICAgZGVmYXVsdE1ldGhvZE9wdGlvbnM6IHtcbiAgICAgICAgICAgICAgICBhdXRob3JpemF0aW9uVHlwZTogYXBpLkF1dGhvcml6YXRpb25UeXBlLklBTVxuICAgICAgICAgICAgfVxuICAgICAgICB9XG4gICAgfTtcbiAgICByZXR1cm4gZGVmYXVsdEdhdGV3YXlQcm9wcztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIERlZmF1bHRHbG9iYWxBcGlQcm9wcygpIHtcbiAgICBjb25zdCBkZWZhdWx0R2F0ZXdheVByb3BzOiBhcGkuUmVzdEFwaVByb3BzID0ge1xuICAgICAgICBlbmRwb2ludFR5cGVzOiBbYXBpLkVuZHBvaW50VHlwZS5FREdFXSxcbiAgICAgICAgY2xvdWRXYXRjaFJvbGU6IGZhbHNlLFxuICAgICAgICAvLyBDb25maWd1cmUgQVBJIEdhdGV3YXkgRXhlY3V0aW9uIGxvZ2dpbmdcbiAgICAgICAgZGVwbG95T3B0aW9uczoge1xuICAgICAgICAgICAgbG9nZ2luZ0xldmVsOiBhcGkuTWV0aG9kTG9nZ2luZ0xldmVsLklORk8sXG4gICAgICAgICAgICBkYXRhVHJhY2VFbmFibGVkOiB0cnVlXG4gICAgICAgIH0sXG4gICAgICAgIGRlZmF1bHRNZXRob2RPcHRpb25zOiB7XG4gICAgICAgICAgICBhdXRob3JpemF0aW9uVHlwZTogYXBpLkF1dGhvcml6YXRpb25UeXBlLklBTVxuICAgICAgICB9XG4gICAgfTtcbiAgICByZXR1cm4gZGVmYXVsdEdhdGV3YXlQcm9wcztcbn0iXX0=