/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.DataRangeType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRangeVisitor;
import org.semanticweb.owlapi.model.OWLDataRangeVisitorEx;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.HashCode;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLObjectTypeIndexProvider;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWL2DatatypeImpl
implements OWLDatatype {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWL2Datatype owl2Datatype;

    public OWL2DatatypeImpl(@Nonnull OWL2Datatype owl2Datatype) {
        this.owl2Datatype = (OWL2Datatype)OWLAPIPreconditions.checkNotNull((Object)owl2Datatype, (String)"owl2Datatype must not be null");
    }

    public OWL2Datatype getBuiltInDatatype() {
        return this.owl2Datatype;
    }

    public boolean isString() {
        return this.owl2Datatype == OWL2Datatype.XSD_STRING;
    }

    public boolean isInteger() {
        return this.owl2Datatype == OWL2Datatype.XSD_INTEGER;
    }

    public boolean isFloat() {
        return this.owl2Datatype == OWL2Datatype.XSD_FLOAT;
    }

    public boolean isDouble() {
        return this.owl2Datatype == OWL2Datatype.XSD_DOUBLE;
    }

    public boolean isBoolean() {
        return this.owl2Datatype == OWL2Datatype.XSD_BOOLEAN;
    }

    public boolean isRDFPlainLiteral() {
        return this.owl2Datatype == OWL2Datatype.RDF_PLAIN_LITERAL;
    }

    public boolean isDatatype() {
        return true;
    }

    public boolean isTopDatatype() {
        return this.owl2Datatype == OWL2Datatype.RDFS_LITERAL;
    }

    @Nonnull
    public OWLDatatype asOWLDatatype() {
        return this;
    }

    public DataRangeType getDataRangeType() {
        return DataRangeType.DATATYPE;
    }

    public void accept(OWLDataVisitor visitor) {
        visitor.visit((OWLDatatype)this);
    }

    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatype)this);
    }

    public void accept(OWLDataRangeVisitor visitor) {
        visitor.visit((OWLDatatype)this);
    }

    public <O> O accept(OWLDataRangeVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatype)this);
    }

    public EntityType<?> getEntityType() {
        return EntityType.DATATYPE;
    }

    public boolean isType(EntityType<?> entityType) {
        return EntityType.DATATYPE.equals(entityType);
    }

    public boolean isBuiltIn() {
        return true;
    }

    public boolean isOWLClass() {
        return false;
    }

    public OWLClass asOWLClass() {
        throw new UnsupportedOperationException("Not an OWLClass");
    }

    public boolean isOWLObjectProperty() {
        return false;
    }

    public OWLObjectProperty asOWLObjectProperty() {
        throw new UnsupportedOperationException("Not an OWLObjectProperty");
    }

    public boolean isOWLDataProperty() {
        return false;
    }

    public OWLDataProperty asOWLDataProperty() {
        throw new UnsupportedOperationException("Not an OWLDataProperty");
    }

    public boolean isOWLNamedIndividual() {
        return false;
    }

    public OWLNamedIndividual asOWLNamedIndividual() {
        throw new UnsupportedOperationException("Not an OWLNamedIndividual");
    }

    public boolean isOWLDatatype() {
        return true;
    }

    public boolean isOWLAnnotationProperty() {
        return false;
    }

    public OWLAnnotationProperty asOWLAnnotationProperty() {
        throw new UnsupportedOperationException("Not an OWLAnnotationProperty");
    }

    public String toStringID() {
        return this.owl2Datatype.getIRI().toString();
    }

    public String toString() {
        return this.toStringID();
    }

    public void accept(OWLEntityVisitor visitor) {
        visitor.visit((OWLDatatype)this);
    }

    public <O> O accept(OWLEntityVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatype)this);
    }

    public IRI getIRI() {
        return this.owl2Datatype.getIRI();
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit((OWLDatatype)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLDatatype)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatype)this);
    }

    public <O> O accept(OWLNamedObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatype)this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLDatatype)) {
            return false;
        }
        OWLDatatype other = (OWLDatatype)obj;
        return this.owl2Datatype.getIRI().equals((Object)other.getIRI());
    }

    public Set<OWLEntity> getSignature() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(Collections.singleton(this));
    }

    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        return this.equals(owlEntity);
    }

    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection((Collection)CollectionFactory.emptySet());
    }

    public Set<OWLClass> getClassesInSignature() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection((Collection)CollectionFactory.emptySet());
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection((Collection)CollectionFactory.emptySet());
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection((Collection)CollectionFactory.emptySet());
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection((Collection)CollectionFactory.emptySet());
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection((Collection)CollectionFactory.emptySet());
    }

    public Set<OWLDatatype> getDatatypesInSignature() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(Collections.singleton(this));
    }

    public Set<OWLClassExpression> getNestedClassExpressions() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection((Collection)CollectionFactory.emptySet());
    }

    public boolean isTopEntity() {
        return this.owl2Datatype == OWL2Datatype.RDF_PLAIN_LITERAL;
    }

    public boolean isBottomEntity() {
        return false;
    }

    public int compareTo(OWLObject o) {
        if (!(o instanceof OWLDatatype)) {
            OWLObjectTypeIndexProvider provider = new OWLObjectTypeIndexProvider();
            return provider.getTypeIndex(o);
        }
        OWLDatatype other = (OWLDatatype)o;
        return this.getIRI().compareTo((OWLObject)other.getIRI());
    }

    public int hashCode() {
        return HashCode.hashCode((OWLObject)this);
    }
}

