/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.owl.owlapi.tutorialowled2011;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLQuantifiedDataRestriction;
import org.semanticweb.owlapi.model.OWLQuantifiedObjectRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;
import org.semanticweb.owlapi.util.QNameShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class OWLTutorialSyntaxObjectRenderer
extends OWLObjectVisitorAdapter {
    @Nonnull
    private final ShortFormProvider shortForms;
    private final Writer writer;
    private int pos;
    int lastNewLinePos;
    private static final boolean TABLES = true;
    private static final int TABLE_COLUMNS = 3;

    @Nonnull
    public String labelFor(@Nonnull OWLEntity entity) {
        return this.shortForms.getShortForm(entity);
    }

    public OWLTutorialSyntaxObjectRenderer(Writer writer) {
        this.writer = writer;
        this.shortForms = new QNameShortFormProvider();
    }

    private void write(@Nonnull String s) {
        try {
            int newLineIndex = s.indexOf(10);
            if (newLineIndex != -1) {
                this.lastNewLinePos = this.pos + newLineIndex;
            }
            this.pos += s.length();
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void write(int i) {
        try {
            String s = " " + i + ' ';
            this.pos += s.length();
            this.writer.write(s);
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void write(@Nonnull IRI iri) {
        this.write("<");
        this.write(iri.toQuotedString());
        this.write(">");
    }

    public void header() {
        this.write("<html>\n");
        this.write("<head>\n");
        this.write("<style>\n");
        this.write("body { font-family: sans-serif; }\n");
        this.write(".key { color: grey; font-size: 75%; }\n");
        this.write(".op { color: grey; }\n");
        this.write(".cl { color: #800; }\n");
        this.write(".pr { color: #080; }\n");
        this.write(".in { color: #008; }\n");
        this.write(".box { border: solid 1px grey; padding: 10px; margin: 10px; }\n");
        int width = 33;
        this.write("table { width: 100%; }\n");
        this.write("td { padding-left: 10px; padding-right: 10px; width: " + width + "%;}\n");
        this.write("</style>\n");
        this.write("<body>\n");
    }

    public void footer() {
        this.write("</body>\n");
        this.write("</html>\n");
    }

    private <T extends OWLObject> void writeCollection(@Nonnull Collection<T> objects) {
        this.writeTable(objects);
    }

    private <T extends OWLObject> void writeTable(@Nonnull Collection<T> objects) {
        this.writeTableStart();
        int count = 0;
        Iterator<T> it = objects.iterator();
        while (it.hasNext()) {
            if (count % 3 == 0) {
                if (count > 0) {
                    this.writeTableRowEnd();
                }
                this.writeTableRowStart();
            }
            this.writeTableCellStart();
            ((OWLObject)it.next()).accept((OWLObjectVisitor)this);
            this.writeTableCellEnd();
            ++count;
        }
        this.writeTableRowEnd();
        this.writeTableEnd();
    }

    private <T extends OWLObject> void writeList(@Nonnull Collection<T> objects) {
        this.writeListStart();
        Iterator<T> it = objects.iterator();
        while (it.hasNext()) {
            this.writeListItemStart();
            ((OWLObject)it.next()).accept((OWLObjectVisitor)this);
            this.writeListItemEnd();
        }
        this.writeListEnd();
    }

    public void visit(@Nonnull OWLOntology ontology) {
        this.header();
        this.write("<h1>");
        this.write(ontology.getOntologyID().toString());
        this.write("</h1>\n");
        this.write("<div>");
        this.write("<div class='box'>\n");
        for (OWLImportsDeclaration decl : ontology.getImportsDeclarations()) {
            this.write("Imports: ");
            this.write(decl.getIRI().toString());
            this.write("\n");
        }
        this.write("<h2>Classes</h2>\n");
        this.writeCollection(ontology.getClassesInSignature());
        this.write("</div>\n");
        this.write("<div class='box'>\n");
        this.write("<h2>Properties</h2>\n");
        this.writeCollection(ontology.getObjectPropertiesInSignature());
        this.writeCollection(ontology.getDataPropertiesInSignature());
        this.write("</div>\n");
        this.write("<div class='box'>\n");
        this.write("<h2>Individuals</h2>\n");
        this.writeCollection(ontology.getIndividualsInSignature());
        this.write("</div>");
        this.write("<div>");
        this.write("<div class='box'>");
        this.write("<h2>Axioms</h2>\n");
        this.writeListStart();
        for (OWLAxiom ax : ontology.getAxioms()) {
            this.writeListItemStart();
            ax.accept((OWLObjectVisitor)this);
            this.writeListEnd();
        }
        this.writeListEnd();
        this.write("</div>");
        this.footer();
    }

    public void write(@Nonnull String str, @Nonnull OWLObject o) {
        this.write(str);
        this.write("(");
        o.accept((OWLObjectVisitor)this);
        this.write(")");
    }

    private void write(@Nonnull Collection<? extends OWLObject> objects, @Nonnull String separator) {
        Iterator<? extends OWLObject> it = objects.iterator();
        while (it.hasNext()) {
            it.next().accept((OWLObjectVisitor)this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(separator);
            this.writeSpace();
        }
    }

    private void write(@Nonnull Collection<? extends OWLObject> objects) {
        this.write(objects, "");
    }

    public void writeOpenBracket() {
        this.write("(");
    }

    public void writeCloseBracket() {
        this.write(")");
    }

    public void writeSpace() {
        this.write(" ");
    }

    public void writeAnnotations(OWLAxiom ax) {
    }

    public void writeListStart() {
        this.write("<ul>\n");
    }

    public void writeListEnd() {
        this.write("</ul>\n");
    }

    public void writeTableStart() {
        this.write("<table>\n");
    }

    public void writeTableEnd() {
        this.write("</table>\n");
    }

    public void writeTableRowStart() {
        this.write("<tr>\n");
    }

    public void writeTableRowEnd() {
        this.write("</tr>\n");
    }

    public void writeTableCellStart() {
        this.write("<td>\n");
    }

    public void writeTableCellEnd() {
        this.write("</td>\n");
    }

    public void writeListItemStart() {
        this.write("<li>\n");
    }

    public void writeListItemEnd() {
        this.write("</li>\n");
    }

    public void writePropertyCharacteristic(String str, OWLAxiom ax, @Nonnull OWLPropertyExpression prop) {
        this.write(this.keyword(str));
        this.writeSpace();
        prop.accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLAsymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic("asymmetric", (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept((OWLObjectVisitor)this);
        this.write(this.keyword(":"));
        this.writeSpace();
        axiom.getClassExpression().accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLDataPropertyDomainAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(this.keyword("domain"));
        this.writeSpace();
        axiom.getDomain().accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLDataPropertyRangeAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(this.keyword("range"));
        this.writeSpace();
        ((OWLDataRange)axiom.getRange()).accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLSubDataPropertyOfAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(this.keyword("subProperty"));
        this.writeSpace();
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
    }

    public void visit(OWLDeclarationAxiom axiom) {
    }

    public void visit(@Nonnull OWLDifferentIndividualsAxiom axiom) {
        this.write(axiom.getIndividuals(), this.keyword("!="));
    }

    public void visit(@Nonnull OWLDisjointClassesAxiom axiom) {
        this.write(axiom.getClassExpressions(), this.keyword("|"));
    }

    public void visit(@Nonnull OWLDisjointDataPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), this.keyword("|"));
    }

    public void visit(@Nonnull OWLDisjointObjectPropertiesAxiom axiom) {
        this.write(this.keyword("disjoint"));
        this.write(axiom.getProperties(), this.keyword("|"));
    }

    public void visit(@Nonnull OWLDisjointUnionAxiom axiom) {
        axiom.getOWLClass().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(this.keyword("=="));
        this.writeSpace();
        this.write(axiom.getClassExpressions(), this.keyword("|"));
    }

    public void visit(@Nonnull OWLEquivalentClassesAxiom axiom) {
        this.write(axiom.getClassExpressions(), this.keyword("=="));
    }

    public void visit(@Nonnull OWLEquivalentDataPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), this.keyword("=="));
    }

    public void visit(@Nonnull OWLEquivalentObjectPropertiesAxiom axiom) {
        this.write(axiom.getProperties(), this.keyword("=="));
    }

    public void visit(@Nonnull OWLFunctionalDataPropertyAxiom axiom) {
        this.writePropertyCharacteristic("functional", (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic("functional", (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLImportsDeclaration axiom) {
        this.write(this.keyword("imports"));
        this.write(axiom.getIRI());
    }

    public void visit(@Nonnull OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic("inversefunctional", (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLInverseObjectPropertiesAxiom axiom) {
        axiom.getFirstProperty().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(this.keyword("inverse"));
        this.writeSpace();
        axiom.getSecondProperty().accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic("Irreflexive", (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLNegativeDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(this.keyword("notvalue"));
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLNegativeObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(this.keyword("notvalue"));
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLSubPropertyChainOfAxiom axiom) {
        this.write("chain");
        this.writeOpenBracket();
        this.write(axiom.getPropertyChain());
        this.writeCloseBracket();
        this.writeSpace();
        this.write(this.keyword("subProperty"));
        this.writeSpace();
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLObjectPropertyDomainAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(this.keyword("domain"));
        this.writeSpace();
        axiom.getDomain().accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLObjectPropertyRangeAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(this.keyword("range"));
        this.writeSpace();
        ((OWLClassExpression)axiom.getRange()).accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLSubObjectPropertyOfAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(this.keyword("subProperty"));
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLReflexiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic("reflexive", (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLSameIndividualAxiom axiom) {
        this.write(axiom.getIndividuals(), this.keyword("="));
    }

    public void visit(@Nonnull OWLSubClassOfAxiom axiom) {
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        this.writeSpace();
        this.write(this.keyword("subClass"));
        this.writeSpace();
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLSymmetricObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic("symmetric", (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(@Nonnull OWLTransitiveObjectPropertyAxiom axiom) {
        this.writePropertyCharacteristic("transitive", (OWLAxiom)axiom, axiom.getProperty());
    }

    public void visit(OWLClass ce) {
        this.write("<span class='cl'>" + this.labelFor((OWLEntity)ce) + "</span>");
    }

    private void writeRestriction(@Nonnull String str, @Nonnull OWLCardinalityRestriction<?> restriction, @Nonnull OWLPropertyExpression property) {
        this.write(str);
        this.writeOpenBracket();
        this.write(restriction.getCardinality());
        this.writeSpace();
        property.accept((OWLObjectVisitor)this);
        if (restriction.isQualified()) {
            this.writeSpace();
            restriction.getFiller().accept((OWLObjectVisitor)this);
        }
        this.writeCloseBracket();
    }

    private void writeRestriction(@Nonnull String str, @Nonnull OWLQuantifiedDataRestriction restriction) {
        this.writeRestriction(str, (OWLPropertyExpression)restriction.getProperty(), (OWLObject)restriction.getFiller());
    }

    private void writeRestriction(@Nonnull String str, @Nonnull OWLQuantifiedObjectRestriction restriction) {
        this.writeRestriction(str, (OWLPropertyExpression)restriction.getProperty(), (OWLObject)restriction.getFiller());
    }

    private void writeRestriction(@Nonnull String str, @Nonnull OWLPropertyExpression prop, @Nonnull OWLObject filler) {
        this.write(str);
        this.writeOpenBracket();
        prop.accept((OWLObjectVisitor)this);
        this.writeSpace();
        filler.accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(OWLDataAllValuesFrom ce) {
        this.writeRestriction(this.operator("only"), (OWLQuantifiedDataRestriction)ce);
    }

    public void visit(@Nonnull OWLDataExactCardinality ce) {
        this.writeRestriction("exact", (OWLCardinalityRestriction<?>)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(@Nonnull OWLDataMaxCardinality ce) {
        this.writeRestriction("atmost", (OWLCardinalityRestriction<?>)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(@Nonnull OWLDataMinCardinality ce) {
        this.writeRestriction("atleast", (OWLCardinalityRestriction<?>)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(OWLDataSomeValuesFrom ce) {
        this.writeRestriction(this.operator("some"), (OWLQuantifiedDataRestriction)ce);
    }

    public void visit(@Nonnull OWLDataHasValue ce) {
        this.writeRestriction("has-value", (OWLPropertyExpression)ce.getProperty(), ce.getFiller());
    }

    public void visit(OWLObjectAllValuesFrom ce) {
        this.writeRestriction(this.operator("only"), (OWLQuantifiedObjectRestriction)ce);
    }

    public void visit(@Nonnull OWLObjectComplementOf ce) {
        this.write(this.operator("not"), (OWLObject)ce.getOperand());
    }

    public void visit(@Nonnull OWLObjectExactCardinality ce) {
        this.writeRestriction("exact", (OWLCardinalityRestriction<?>)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(@Nonnull OWLObjectIntersectionOf ce) {
        this.writeOpenBracket();
        this.write(ce.getOperands(), this.keyword("and"));
        this.writeCloseBracket();
    }

    public void visit(@Nonnull OWLObjectMaxCardinality ce) {
        this.writeRestriction("atmost", (OWLCardinalityRestriction<?>)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(@Nonnull OWLObjectMinCardinality ce) {
        this.writeRestriction("atleast", (OWLCardinalityRestriction<?>)ce, (OWLPropertyExpression)ce.getProperty());
    }

    public void visit(@Nonnull OWLObjectOneOf ce) {
        this.write(this.operator("one-of"));
        this.writeOpenBracket();
        this.write(ce.getIndividuals());
        this.writeCloseBracket();
    }

    public void visit(@Nonnull OWLObjectHasSelf ce) {
        this.write("self", (OWLObject)ce.getProperty());
    }

    public void visit(OWLObjectSomeValuesFrom ce) {
        this.writeRestriction(this.operator("some"), (OWLQuantifiedObjectRestriction)ce);
    }

    public void visit(@Nonnull OWLObjectUnionOf ce) {
        this.writeOpenBracket();
        this.write(ce.getOperands(), " or ");
        this.writeCloseBracket();
    }

    public void visit(@Nonnull OWLObjectHasValue ce) {
        this.writeRestriction("hasValue", (OWLPropertyExpression)ce.getProperty(), ce.getFiller());
    }

    public void visit(@Nonnull OWLDataComplementOf node) {
        this.write(this.operator("not"), (OWLObject)node.getDataRange());
    }

    public void visit(@Nonnull OWLDataOneOf node) {
        this.write(this.operator("one-of"));
        this.write("(");
        this.write(node.getValues());
        this.write(")");
    }

    public void visit(@Nonnull OWLDatatype node) {
        this.write("Datatype");
        this.writeOpenBracket();
        this.write(node.getIRI());
        this.writeCloseBracket();
    }

    public void visit(@Nonnull OWLDatatypeRestriction node) {
        this.write("DatatypeRestriction");
        this.writeOpenBracket();
        node.getDatatype().accept((OWLObjectVisitor)this);
        for (OWLFacetRestriction restriction : node.getFacetRestrictions()) {
            this.writeSpace();
            restriction.accept((OWLObjectVisitor)this);
        }
        this.writeCloseBracket();
    }

    public void visit(@Nonnull OWLFacetRestriction node) {
        this.write(node.getFacet().getIRI());
        this.writeSpace();
        node.getFacetValue().accept((OWLObjectVisitor)this);
    }

    public void visit(@Nonnull OWLLiteral node) {
        this.write("\"");
        this.write(node.getLiteral());
        this.write("\"");
        if (node.hasLang()) {
            this.write("@");
            this.write(node.getLang());
        } else {
            this.write("^^");
            this.write(node.getDatatype().getIRI());
        }
    }

    public void visit(OWLDataProperty property) {
        this.write("<span class='pr'>" + this.labelFor((OWLEntity)property) + "</span>");
    }

    public void visit(OWLObjectProperty property) {
        this.write("<span class='pr'>" + this.labelFor((OWLEntity)property) + "</span>");
    }

    public void visit(@Nonnull OWLObjectInverseOf property) {
        this.write("inv");
        this.writeOpenBracket();
        property.getInverse().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    public void visit(OWLNamedIndividual individual) {
        this.write("<span class='in'>" + this.labelFor((OWLEntity)individual) + "</span>");
    }

    public void visit(SWRLRule rule) {
    }

    @Nonnull
    public String keyword(String str) {
        return "<span class='key'>" + str + "</span>";
    }

    @Nonnull
    public String operator(String str) {
        return "<span class='op'>" + str + "</span>";
    }
}

