/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.hierarchy;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.semanticweb.HermiT.hierarchy.HierarchyNode;

public class HierarchySearch {
    public static <E> HierarchyNode<E> findPosition(Relation<E> hierarchyRelation, E element, HierarchyNode<E> topNode, HierarchyNode<E> bottomNode) {
        Set<HierarchyNode<E>> childNodes;
        Set<HierarchyNode<E>> parentNodes = HierarchySearch.findParents(hierarchyRelation, element, topNode);
        if (parentNodes.equals(childNodes = HierarchySearch.findChildren(hierarchyRelation, element, bottomNode, parentNodes))) {
            assert (parentNodes.size() == 1 && childNodes.size() == 1);
            return parentNodes.iterator().next();
        }
        HashSet<E> equivalentElements = new HashSet<E>();
        equivalentElements.add(element);
        return new HierarchyNode<E>(element, equivalentElements, parentNodes, childNodes);
    }

    protected static <E> Set<HierarchyNode<E>> findParents(final Relation<E> hierarchyRelation, final E element, HierarchyNode<E> topNode) {
        return HierarchySearch.search(new SearchPredicate<HierarchyNode<E>>(){

            @Override
            public Set<HierarchyNode<E>> getSuccessorElements(HierarchyNode<E> u) {
                return u.m_childNodes;
            }

            @Override
            public Set<HierarchyNode<E>> getPredecessorElements(HierarchyNode<E> u) {
                return u.m_parentNodes;
            }

            @Override
            public boolean trueOf(HierarchyNode<E> u) {
                return hierarchyRelation.doesSubsume(u.getRepresentative(), element);
            }
        }, Collections.singleton(topNode), null);
    }

    protected static <E> Set<HierarchyNode<E>> findChildren(final Relation<E> hierarchyRelation, final E element, HierarchyNode<E> bottomNode, Set<HierarchyNode<E>> parentNodes) {
        if (parentNodes.size() == 1 && hierarchyRelation.doesSubsume(element, parentNodes.iterator().next().getRepresentative())) {
            return parentNodes;
        }
        Iterator<HierarchyNode<E>> parentNodesIterator = parentNodes.iterator();
        HashSet<HierarchyNode<E>> marked = new HashSet<HierarchyNode<E>>(parentNodesIterator.next().getDescendantNodes());
        while (parentNodesIterator.hasNext()) {
            HierarchyNode currentNode;
            HashSet freshlyMarked = new HashSet();
            HashSet visited = new HashSet();
            LinkedList linkedList = new LinkedList();
            linkedList.add(parentNodesIterator.next());
            while (!linkedList.isEmpty()) {
                currentNode = (HierarchyNode)linkedList.remove();
                for (HierarchyNode childNode : currentNode.m_childNodes) {
                    if (marked.contains(childNode)) {
                        freshlyMarked.add(childNode);
                        continue;
                    }
                    if (!visited.add(childNode)) continue;
                    linkedList.add(childNode);
                }
            }
            linkedList.addAll(freshlyMarked);
            while (!linkedList.isEmpty()) {
                currentNode = (HierarchyNode)linkedList.remove();
                for (HierarchyNode childNode : currentNode.m_childNodes) {
                    if (!freshlyMarked.add(childNode)) continue;
                    linkedList.add(childNode);
                }
            }
            marked = freshlyMarked;
        }
        HashSet<HierarchyNode> aboveBottomNodes = new HashSet<HierarchyNode>();
        for (HierarchyNode hierarchyNode : marked) {
            if (!hierarchyNode.m_childNodes.contains(bottomNode) || !hierarchyRelation.doesSubsume(element, hierarchyNode.getRepresentative())) continue;
            aboveBottomNodes.add(hierarchyNode);
        }
        if (aboveBottomNodes.isEmpty()) {
            HashSet<HierarchyNode<HierarchyNode<E>>> childNodes = new HashSet<HierarchyNode<HierarchyNode<E>>>();
            childNodes.add(bottomNode);
            return childNodes;
        }
        return HierarchySearch.search(new SearchPredicate<HierarchyNode<E>>(){

            @Override
            public Set<HierarchyNode<E>> getSuccessorElements(HierarchyNode<E> u) {
                return u.m_parentNodes;
            }

            @Override
            public Set<HierarchyNode<E>> getPredecessorElements(HierarchyNode<E> u) {
                return u.m_childNodes;
            }

            @Override
            public boolean trueOf(HierarchyNode<E> u) {
                return hierarchyRelation.doesSubsume(element, u.getRepresentative());
            }
        }, aboveBottomNodes, marked);
    }

    public static <U> Set<U> search(SearchPredicate<U> searchPredicate, Collection<U> startSearch, Set<U> possibilities) {
        SearchCache<U> cache = new SearchCache<U>(searchPredicate, possibilities);
        HashSet result = new HashSet();
        HashSet<U> visited = new HashSet<U>(startSearch);
        LinkedList<U> toProcess = new LinkedList<U>(startSearch);
        while (!toProcess.isEmpty()) {
            Object current = toProcess.remove();
            boolean foundSubordinateElement = false;
            Set<U> subordinateElements = searchPredicate.getSuccessorElements(current);
            for (U subordinateElement : subordinateElements) {
                if (!cache.trueOf(subordinateElement)) continue;
                foundSubordinateElement = true;
                if (!visited.add(subordinateElement)) continue;
                toProcess.add(subordinateElement);
            }
            if (foundSubordinateElement) continue;
            result.add(current);
        }
        return result;
    }

    protected static final class SearchCache<U> {
        protected final SearchPredicate<U> m_searchPredicate;
        protected final Set<U> m_possibilities;
        protected final Set<U> m_positives;
        protected final Set<U> m_negatives;

        public SearchCache(SearchPredicate<U> f, Set<U> possibilities) {
            this.m_searchPredicate = f;
            this.m_possibilities = possibilities;
            this.m_positives = new HashSet<U>();
            this.m_negatives = new HashSet<U>();
        }

        public boolean trueOf(U element) {
            if (this.m_positives.contains(element)) {
                return true;
            }
            if (this.m_negatives.contains(element) || this.m_possibilities != null && !this.m_possibilities.contains(element)) {
                return false;
            }
            for (U superordinateElement : this.m_searchPredicate.getPredecessorElements(element)) {
                if (this.trueOf(superordinateElement)) continue;
                this.m_negatives.add(element);
                return false;
            }
            if (this.m_searchPredicate.trueOf(element)) {
                this.m_positives.add(element);
                return true;
            }
            this.m_negatives.add(element);
            return false;
        }
    }

    public static interface SearchPredicate<U> {
        public Set<U> getSuccessorElements(U var1);

        public Set<U> getPredecessorElements(U var1);

        public boolean trueOf(U var1);
    }

    public static interface Relation<U> {
        public boolean doesSubsume(U var1, U var2);
    }
}

