/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap_lite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.search.Searcher;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.utilities.Utilities;
import uk.ac.ox.krr.logmap_lite.PrecomputeIndexCombination;
import uk.ac.ox.krr.logmap_lite.io.ReadFile;

public class OntologyProcessing {
    private Map<Set<String>, Set<Integer>> invertedFileExactLabels = new HashMap<Set<String>, Set<Integer>>();
    private Map<Set<String>, Set<Integer>> invertedFileExactLabels_dProp = new HashMap<Set<String>, Set<Integer>>();
    private Map<Set<String>, Set<Integer>> invertedFileExactLabels_oProp = new HashMap<Set<String>, Set<Integer>>();
    private Map<Set<String>, Set<Integer>> invertedFileExactLabels_indiv = new HashMap<Set<String>, Set<Integer>>();
    private Map<Set<String>, Set<Integer>> invertedFileWeakLabels = new HashMap<Set<String>, Set<Integer>>();
    private Map<Integer, Set<List<String>>> identifier2labels = new HashMap<Integer, Set<List<String>>>();
    private List<OWLClass> listofOWLClass = new ArrayList<OWLClass>();
    private List<OWLDataProperty> listofOWLDProp = new ArrayList<OWLDataProperty>();
    private List<OWLObjectProperty> listofOWLOProp = new ArrayList<OWLObjectProperty>();
    private List<OWLNamedIndividual> listofOWLIndividual = new ArrayList<OWLNamedIndividual>();
    protected String rdf_label_uri = "http://www.w3.org/2000/01/rdf-schema#label";
    public String rdf_comment_uri = "http://www.w3.org/2000/01/rdf-schema#comment";
    protected String synonym_iri = "http://oaei.ontologymatching.org/annotations#synonym";
    private String hasRelatedSynonym_uri = "http://www.geneontology.org/formats/oboInOwl#hasRelatedSynonym";
    private String hasExactSynonym_uri = "http://www.geneontology.org/formats/oboInOwl#hasExactSynonym";
    private String hasExactSynonym_uri2 = "http://www.geneontology.org/formats/oboInOWL#hasExactSynonym";
    private String skos_pref_label = "http://www.w3.org/2004/02/skos/core#prefLabel";
    private String skos_alt_label = "http://www.w3.org/2004/02/skos/core#altLabel";
    private String name_dprop_im_uri = "http://oaei.ontologymatching.org/2012/IIMBTBOX/name";
    private String article_dprop_im_uri = "http://oaei.ontologymatching.org/2012/IIMBTBOX/article";
    private String has_value_dprop_im_uri = "http://www.instancematching.org/IIMB2012/ADDONS#has_value";
    private String article_oprop_im_uri = "http://www.instancematching.org/IIMB2012/ADDONS#article";
    private String name_oprop_im_uri = "http://www.instancematching.org/IIMB2012/ADDONS#name";
    private String population_dprop_im_uri = "http://dbpedia.org/ontology/populationTotal";
    private String birthName_dprop_im_uri = "http://dbpedia.org/ontology/birthName";
    private String label_oprop_im_uri = "http://www.instancematching.org/label";
    private String curriculum_oprop_im_uri = "http://www.instancematching.org/curriculum";
    private String places_oprop_im_uri = "http://www.instancematching.org/places";
    private String name_dprop_im_uri_2015 = "http://islab.di.unimi.it/imoaei2015#name";
    private OWLOntology onto;
    private Set<String> stopwordsSet = new HashSet<String>();
    private boolean extract_overlapping;
    private PrecomputeIndexCombination precomputeIndexCombination = new PrecomputeIndexCombination();

    public OntologyProcessing(OWLOntology ont, boolean extract_overlapping) throws Exception {
        this.onto = ont;
        this.extract_overlapping = extract_overlapping;
        this.precomputeIndexCombination.preComputeIdentifierCombination();
        this.loadStopWords();
        this.processOntologyClassLabels();
        this.processOntologyObjPropLabels();
        this.processOntologyDataPropLabels();
        this.processOntologyIndividualsLabels();
        this.precomputeIndexCombination.clearStructures();
    }

    public void clearOntoloy() {
        this.onto = null;
    }

    private void processOntologyClassLabels() {
        HashSet<String> words = new HashSet<String>();
        int ident = 0;
        for (OWLClass cls : this.onto.getClassesInSignature(true)) {
            if (cls.isTopEntity() || cls.isBottomEntity()) continue;
            this.listofOWLClass.add(cls);
            if (this.extract_overlapping) {
                this.identifier2labels.put(ident, new HashSet());
            }
            for (String label : this.extractLabels4OWLEntity((OWLEntity)cls, 6)) {
                words.addAll(this.cleanLabel(label));
                if (words.size() > 0) {
                    if (!this.invertedFileExactLabels.containsKey(words)) {
                        this.invertedFileExactLabels.put(new HashSet(words), new HashSet());
                    }
                    this.invertedFileExactLabels.get(words).add(ident);
                    if (this.extract_overlapping) {
                        if (!this.invertedFileWeakLabels.containsKey(words)) {
                            this.invertedFileWeakLabels.put(new HashSet(words), new HashSet());
                        }
                        this.invertedFileWeakLabels.get(words).add(ident);
                        this.identifier2labels.get(ident).add(new ArrayList(words));
                    }
                }
                words.clear();
            }
            ++ident;
        }
        if (this.extract_overlapping) {
            this.setInvertedFileWeak4Overlapping();
        }
    }

    private void processOntologyDataPropLabels() {
        HashSet<String> words = new HashSet<String>();
        int ident = 0;
        for (OWLDataProperty dProp : this.onto.getDataPropertiesInSignature(true)) {
            if (dProp.isTopEntity() || dProp.isBottomEntity()) continue;
            this.listofOWLDProp.add(dProp);
            for (String label : this.extractLabels4OWLEntity((OWLEntity)dProp, 1)) {
                words.addAll(this.cleanLabel(label));
                if (words.size() > 0) {
                    if (!this.invertedFileExactLabels_dProp.containsKey(words)) {
                        this.invertedFileExactLabels_dProp.put(new HashSet(words), new HashSet());
                    }
                    this.invertedFileExactLabels_dProp.get(words).add(ident);
                }
                words.clear();
            }
            ++ident;
        }
    }

    private void processOntologyObjPropLabels() {
        HashSet<String> words = new HashSet<String>();
        int ident = 0;
        for (OWLObjectProperty oProp : this.onto.getObjectPropertiesInSignature(true)) {
            if (oProp.isTopEntity() || oProp.isBottomEntity()) continue;
            this.listofOWLOProp.add(oProp);
            for (String label : this.extractLabels4OWLEntity((OWLEntity)oProp, 1)) {
                words.addAll(this.cleanLabel(label));
                if (words.size() > 0) {
                    if (!this.invertedFileExactLabels_oProp.containsKey(words)) {
                        this.invertedFileExactLabels_oProp.put(new HashSet(words), new HashSet());
                    }
                    this.invertedFileExactLabels_oProp.get(words).add(ident);
                }
                words.clear();
            }
            ++ident;
        }
    }

    private void processOntologyIndividualsLabels() {
        int ident = 0;
        HashSet<String> words = new HashSet<String>();
        ExtractAcceptedLabelsFromRoleAssertions indivLabelExtractor = new ExtractAcceptedLabelsFromRoleAssertions();
        for (OWLNamedIndividual indiv : this.onto.getIndividualsInSignature(true)) {
            this.listofOWLIndividual.add(indiv);
            if (indivLabelExtractor.isDummyIndividual(indiv)) {
                ++ident;
                continue;
            }
            for (String label : indivLabelExtractor.extractLexiconFromRoleAssertions(indiv)) {
                words.addAll(this.cleanLabel(label));
                if (words.size() > 0) {
                    if (!this.invertedFileExactLabels_indiv.containsKey(words)) {
                        this.invertedFileExactLabels_indiv.put(new HashSet(words), new HashSet());
                    }
                    this.invertedFileExactLabels_indiv.get(words).add(ident);
                }
                words.clear();
            }
            ++ident;
        }
    }

    public Map<Set<String>, Set<Integer>> getInvertedFileExact() {
        return this.invertedFileExactLabels;
    }

    public Map<Set<String>, Set<Integer>> getInvertedFileExactIndividuals() {
        return this.invertedFileExactLabels_indiv;
    }

    public Map<Set<String>, Set<Integer>> getInvertedFileExactDataProp() {
        return this.invertedFileExactLabels_dProp;
    }

    public Map<Set<String>, Set<Integer>> getInvertedFileExactObjectProp() {
        return this.invertedFileExactLabels_oProp;
    }

    public Map<Set<String>, Set<Integer>> getWeakInvertedFile() {
        return this.invertedFileWeakLabels;
    }

    public String getIRI4identifier(int ident) {
        return this.listofOWLClass.get(ident).getIRI().toString();
    }

    public String getIRI4DPropIdentifier(int ident) {
        return this.listofOWLDProp.get(ident).getIRI().toString();
    }

    public String getIRI4OPropIdentifier(int ident) {
        return this.listofOWLOProp.get(ident).getIRI().toString();
    }

    public String getIRI4Individual(int ident) {
        return this.listofOWLIndividual.get(ident).getIRI().toString();
    }

    public String getLabel4identifier(int ident) {
        return Utilities.getEntityLabelFromURI(this.listofOWLClass.get(ident).getIRI().toString());
    }

    public OWLClass getOWLClass4identifier(int ident) {
        return this.listofOWLClass.get(ident);
    }

    public void clearStructures() {
        this.invertedFileExactLabels.clear();
        this.invertedFileExactLabels_indiv.clear();
        this.invertedFileExactLabels_dProp.clear();
        this.invertedFileExactLabels_oProp.clear();
        this.invertedFileWeakLabels.clear();
        this.listofOWLClass.clear();
        this.listofOWLDProp.clear();
        this.listofOWLOProp.clear();
        this.stopwordsSet.clear();
    }

    private Set<String> extractLabels4OWLEntity(OWLEntity ent, int max_size) {
        HashSet<String> labels = new HashSet<String>();
        for (OWLAnnotationAssertionAxiom annAx : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)ent, (OWLOntology)this.onto)) {
            if (annAx.getAnnotation().getProperty().getIRI().toString().equals(this.rdf_label_uri) || annAx.getAnnotation().getProperty().getIRI().toString().equals(this.synonym_iri) || annAx.getAnnotation().getProperty().getIRI().toString().equals(this.skos_pref_label) || annAx.getAnnotation().getProperty().getIRI().toString().equals(this.skos_alt_label)) {
                labels.add(((OWLLiteral)annAx.getAnnotation().getValue()).getLiteral());
            } else if (annAx.getAnnotation().getProperty().getIRI().toString().equals(this.hasRelatedSynonym_uri) || annAx.getAnnotation().getProperty().getIRI().toString().equals(this.hasExactSynonym_uri) || annAx.getAnnotation().getProperty().getIRI().toString().equals(this.hasExactSynonym_uri2)) {
                try {
                    OWLAnonymousIndividual geneid_value = ((OWLAnonymousIndividual)annAx.getAnnotation().getValue()).asOWLAnonymousIndividual();
                    for (OWLAnnotationAssertionAxiom annGeneidAx : this.onto.getAnnotationAssertionAxioms((OWLAnnotationSubject)geneid_value)) {
                        if (!annGeneidAx.getAnnotation().getProperty().getIRI().toString().equals(this.rdf_label_uri)) continue;
                        labels.add(((OWLLiteral)annGeneidAx.getAnnotation().getValue()).getLiteral().toString());
                    }
                }
                catch (Exception e) {
                    try {
                        labels.add(((OWLLiteral)annAx.getAnnotation().getValue()).getLiteral());
                    }
                    catch (Exception e1) {
                        System.err.println("Error accessing annotation: hasRelatedSynonym_uri or hasExactSynonym_uri");
                    }
                }
            }
            if (labels.size() < max_size) continue;
            break;
        }
        if (labels.isEmpty()) {
            labels.add(Utilities.getEntityLabelFromURI(ent.getIRI().toString()));
        }
        return labels;
    }

    private String[] splitStringByCapitalLetter(String str) {
        String pattern = "(?<=[^\\p{Upper}])(?=\\p{Upper})|(?<=[\\p{Lower}])(?=\\d)";
        return str.split(pattern);
    }

    private List<String> cleanLabel(String label_value) {
        ArrayList<String> cleanWords = new ArrayList<String>();
        String[] words = (label_value = label_value.replace(",", "")).indexOf("_") > 0 ? label_value.split("_") : (label_value.indexOf(" ") > 0 ? label_value.split(" ") : this.splitStringByCapitalLetter(label_value));
        for (int i = 0; i < words.length; ++i) {
            words[i] = words[i].toLowerCase();
            if (words[i].length() <= 0 || this.getStopwordsSet().contains(words[i])) continue;
            cleanWords.add(words[i]);
        }
        return cleanWords;
    }

    private void setInvertedFileWeak4Overlapping() {
        this.setInvertedFileWeakLabels();
        this.identifier2labels.clear();
    }

    private void setInvertedFileWeakLabels() {
        int max_size_labels = 6;
        int max_size_words_missing = 2;
        for (int ident : this.identifier2labels.keySet()) {
            for (List<String> words : this.identifier2labels.get(ident)) {
                if (words.size() > max_size_labels || words.size() <= 1) continue;
                this.createWeakLabels4Identifier(words, ident, 1);
                if (words.size() <= 3 || max_size_words_missing <= 1) continue;
                this.createWeakLabels4Identifier(words, ident, 2);
                if (words.size() <= 5 || max_size_words_missing <= 2) continue;
                this.createWeakLabels4Identifier(words, ident, 3);
                if (words.size() <= 7 || max_size_words_missing <= 3) continue;
                this.createWeakLabels4Identifier(words, ident, 4);
            }
        }
    }

    private void createWeakLabels4Identifier(List<String> cleanWords, int ident, int missing_words) {
        HashSet<String> combo = new HashSet<String>();
        Set<Set<Integer>> combination_set = this.precomputeIndexCombination.getIdentifierCombination(cleanWords.size(), missing_words);
        for (Set<Integer> toExclude : combination_set) {
            for (int pos = 0; pos < cleanWords.size(); ++pos) {
                if (toExclude.contains(pos)) continue;
                combo.add(cleanWords.get(pos));
            }
            if (!this.invertedFileWeakLabels.containsKey(combo)) {
                this.invertedFileWeakLabels.put(new HashSet(combo), new HashSet());
            }
            this.invertedFileWeakLabels.get(combo).add(ident);
            combo.clear();
        }
    }

    private void loadStopWords() throws Exception {
        String line;
        ReadFile reader = new ReadFile(OntologyProcessing.class.getResourceAsStream("stopwords.txt"));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            this.stopwordsSet.add(line);
        }
        reader.closeBuffer();
    }

    private Set<String> getStopwordsSet() {
        return this.stopwordsSet;
    }

    private class ExtractAcceptedLabelsFromRoleAssertions {
        Set<String> lexiconValues4individual = new HashSet<String>();
        Set<String> accepted_data_uris = new HashSet<String>();
        Set<String> accepted_obj_uris = new HashSet<String>();
        Set<String> accepted_data_uris_deep2 = new HashSet<String>();
        String label_value;
        int max_size_name_label = 0;
        int min_size_name_label = 5000;

        ExtractAcceptedLabelsFromRoleAssertions() {
            this.accepted_data_uris.add(OntologyProcessing.this.article_dprop_im_uri);
            this.accepted_data_uris.add(OntologyProcessing.this.name_dprop_im_uri);
            this.accepted_data_uris.add(OntologyProcessing.this.birthName_dprop_im_uri);
            this.accepted_data_uris.add(OntologyProcessing.this.population_dprop_im_uri);
            this.accepted_data_uris.add(OntologyProcessing.this.name_dprop_im_uri_2015);
            this.accepted_obj_uris.add(OntologyProcessing.this.article_oprop_im_uri);
            this.accepted_obj_uris.add(OntologyProcessing.this.name_oprop_im_uri);
            this.accepted_obj_uris.add(OntologyProcessing.this.label_oprop_im_uri);
            this.accepted_obj_uris.add(OntologyProcessing.this.places_oprop_im_uri);
            this.accepted_obj_uris.add(OntologyProcessing.this.curriculum_oprop_im_uri);
            this.accepted_data_uris_deep2.add(OntologyProcessing.this.has_value_dprop_im_uri);
        }

        protected Set<String> extractLexiconFromRoleAssertions(OWLNamedIndividual indiv) {
            this.lexiconValues4individual.clear();
            this.label_value = Utilities.getEntityLabelFromURI(indiv.getIRI().toString());
            if (this.label_value.length() > 2) {
                this.lexiconValues4individual.add(this.label_value);
            }
            for (OWLAnnotationAssertionAxiom indivAnnAx : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)indiv, (OWLOntology)OntologyProcessing.this.onto)) {
                String uri_ann = indivAnnAx.getAnnotation().getProperty().getIRI().toString();
                if (!OntologyProcessing.this.rdf_comment_uri.equals(uri_ann) && !OntologyProcessing.this.rdf_label_uri.equals(uri_ann)) continue;
                try {
                    this.label_value = this.processLabel(((OWLLiteral)indivAnnAx.getAnnotation().getValue()).getLiteral().toLowerCase());
                }
                catch (Exception e) {
                    this.label_value = "";
                }
                if (this.label_value.length() > this.max_size_name_label) {
                    this.max_size_name_label = this.label_value.length();
                }
                if (this.label_value.length() > 0 && this.label_value.length() < this.min_size_name_label) {
                    this.min_size_name_label = this.label_value.length();
                }
                if (this.label_value.length() <= 2) continue;
                this.lexiconValues4individual.add(this.label_value);
            }
            for (String uri_indiv_ann : this.accepted_data_uris) {
                for (OWLLiteral assertion_value : Searcher.values((Collection)OntologyProcessing.this.onto.getDataPropertyAssertionAxioms((OWLIndividual)indiv), (OWLDataPropertyExpression)OWLManager.getOWLDataFactory().getOWLDataProperty(IRI.create((String)uri_indiv_ann)))) {
                    this.label_value = this.processLabel(assertion_value.getLiteral().toLowerCase());
                    if (this.label_value.length() > this.max_size_name_label) {
                        this.max_size_name_label = this.label_value.length();
                    }
                    if (this.label_value.length() > 0 && this.label_value.length() < this.min_size_name_label) {
                        this.min_size_name_label = this.label_value.length();
                    }
                    if (this.label_value.length() <= 2) continue;
                    this.lexiconValues4individual.add(this.label_value);
                }
            }
            for (String uri_indiv_ann_deep1 : this.accepted_obj_uris) {
                for (OWLIndividual assertion_value_indiv : Searcher.values((Collection)OntologyProcessing.this.onto.getObjectPropertyAssertionAxioms((OWLIndividual)indiv), (OWLObjectPropertyExpression)OWLManager.getOWLDataFactory().getOWLObjectProperty(IRI.create((String)uri_indiv_ann_deep1)))) {
                    if (!assertion_value_indiv.isNamed()) continue;
                    for (String uri_indiv_ann_deep2 : this.accepted_data_uris_deep2) {
                        for (OWLLiteral assertion_value_deep2 : Searcher.values((Collection)OntologyProcessing.this.onto.getDataPropertyAssertionAxioms((OWLIndividual)assertion_value_indiv.asOWLNamedIndividual()), (OWLDataPropertyExpression)OWLManager.getOWLDataFactory().getOWLDataProperty(IRI.create((String)uri_indiv_ann_deep2)))) {
                            this.label_value = this.processLabel(assertion_value_deep2.getLiteral().toLowerCase());
                            if (this.label_value.length() > this.max_size_name_label) {
                                this.max_size_name_label = this.label_value.length();
                            }
                            if (this.label_value.length() <= 2) continue;
                            this.lexiconValues4individual.add(this.label_value);
                        }
                    }
                    for (OWLAnnotationAssertionAxiom indivAnnAx_level2 : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)assertion_value_indiv.asOWLNamedIndividual(), (OWLOntology)OntologyProcessing.this.onto)) {
                        String uri_ann = indivAnnAx_level2.getAnnotation().getProperty().getIRI().toString();
                        if (!OntologyProcessing.this.rdf_comment_uri.equals(uri_ann)) continue;
                        try {
                            this.label_value = this.processLabel(((OWLLiteral)indivAnnAx_level2.getAnnotation().getValue()).getLiteral().toLowerCase());
                        }
                        catch (Exception e) {
                            this.label_value = "";
                        }
                        if (this.label_value.length() > this.max_size_name_label) {
                            this.max_size_name_label = this.label_value.length();
                        }
                        if (this.label_value.length() > 0 && this.label_value.length() < this.min_size_name_label) {
                            this.min_size_name_label = this.label_value.length();
                        }
                        if (this.label_value.length() <= 2) continue;
                        this.lexiconValues4individual.add(this.label_value);
                    }
                }
            }
            return this.lexiconValues4individual;
        }

        private String processLabel(String value) {
            String processedLabel = "";
            String reg_ex_split = "[&\\,;(/]|(\\s)is(\\s)|(\\s)are(\\s)|(\\s)was(\\s)|(\\s)were(\\s)|(\\s)est(\\s)|(\\s)fut(\\s)|(\\s)un(\\s)|(\\s)a(\\s)|(\\s)an(\\s)";
            int manegeable_lenght = 65;
            if (processedLabel.length() <= manegeable_lenght && !processedLabel.contains("<p>") && !processedLabel.contains("</p>")) {
                processedLabel = processedLabel.split(reg_ex_split)[0];
                if (!this.isGoodLabel(processedLabel = processedLabel.trim())) {
                    return "";
                }
                return processedLabel;
            }
            if (processedLabel.startsWith("<p>")) {
                processedLabel = processedLabel.split("<p>")[1];
                processedLabel = processedLabel.split(reg_ex_split)[0];
                if ((processedLabel = processedLabel.trim()).length() <= manegeable_lenght && this.isGoodLabel(processedLabel)) {
                    return processedLabel;
                }
                return "";
            }
            processedLabel = processedLabel.split(reg_ex_split)[0];
            if ((processedLabel = processedLabel.trim()).length() <= manegeable_lenght) {
                if (this.isGoodLabel(processedLabel)) {
                    return processedLabel;
                }
                LogOutput.printAlways("BAD: " + processedLabel);
            } else if (this.isGoodLabel(processedLabel = processedLabel.substring(0, manegeable_lenght))) {
                return processedLabel;
            }
            LogOutput.printAlways("Filtered: " + processedLabel.substring(0, 50));
            return "";
        }

        private boolean isGoodLabel(String label) {
            String consonant_regex = "[b-df-hj-np-tv-xz]";
            String more3_consonants_regex = consonant_regex + consonant_regex + consonant_regex + consonant_regex + "+";
            String more5_consonants_regex = consonant_regex + consonant_regex + consonant_regex + consonant_regex + consonant_regex + consonant_regex + "+";
            String vowel_regex = "[aeiou]";
            String more3_vowels_regex = vowel_regex + vowel_regex + vowel_regex + vowel_regex + "+";
            String same_character_3_times = ".*(.)\\1\\1.*";
            String space_character_3_times = ".*(\\s)\\1\\1.*";
            if (label.length() < 3) {
                return false;
            }
            if (label.contains("!") || label.contains("?")) {
                return false;
            }
            if (label.matches(space_character_3_times)) {
                return false;
            }
            String[] words = label.split(" ");
            boolean has_min_size_word = false;
            for (String word : words) {
                if ((word = word.toLowerCase()).equals("st")) continue;
                if (word.length() < 2) {
                    if (word.equals("a")) continue;
                    return false;
                }
                has_min_size_word = true;
                if (word.matches(same_character_3_times)) {
                    return false;
                }
                if (!word.startsWith("mc") && word.matches(more3_consonants_regex + ".*")) {
                    return false;
                }
                if (word.matches(".*" + more5_consonants_regex + ".*")) {
                    return false;
                }
                if (word.matches(".*" + more3_vowels_regex + ".*")) {
                    return false;
                }
                if (!word.matches(consonant_regex + "+") && !word.matches(vowel_regex + "+")) continue;
                return false;
            }
            return has_min_size_word;
        }

        protected boolean isDummyIndividual(OWLNamedIndividual indiv) {
            for (OWLAxiom refAx : OntologyProcessing.this.onto.getReferencingAxioms((OWLPrimitive)indiv, true)) {
                OWLObjectPropertyAssertionAxiom opaa;
                if (!(refAx instanceof OWLObjectPropertyAssertionAxiom) || ((OWLIndividual)(opaa = (OWLObjectPropertyAssertionAxiom)refAx).getObject()).isAnonymous() || !indiv.equals(((OWLIndividual)opaa.getObject()).asOWLNamedIndividual()) || ((OWLObjectPropertyExpression)opaa.getProperty()).isAnonymous()) continue;
                String prop_uri = ((OWLObjectPropertyExpression)opaa.getProperty()).asOWLObjectProperty().getIRI().toString();
                for (String op4indiv : Parameters.accepted_object_assertion_URIs_for_individuals) {
                    if (!prop_uri.equals(op4indiv)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

