/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.statistics;

import uk.ac.ox.krr.logmap2.interactive.objects.MappingObjectInteractivity;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.mappings.MappingManager;

public class StatisticsManager {
    public static int MFinal;
    public static int MFinal_ok;
    public static int MMissing;
    public static int Mall;
    public static int Mall_ok;
    public static int Manchors;
    public static int Manchors_ok;
    public static int Mask;
    public static int Mask_ok;
    public static int Mask_heur;
    public static int Msplit;
    public static int Msplit_ok;
    public static int Mdisc;
    public static int Mdisc_ok;
    public static int Mharddisc;
    public static int Mharddisc_ok;
    public static int Mconf;
    public static int Mconf_ok;
    public static int Mconf_dg;
    public static int Mconf_dg_ok;
    public static double precision_anc;
    public static double recall_anc;
    public static double fmeasure_anc;
    public static MappingManager mapping_manager;

    public static void setMappingManager(MappingManager m_manager) {
        mapping_manager = m_manager;
    }

    public static void extractStatisticsAnchors() {
        for (int ide1 : mapping_manager.getLogMapMappings().keySet()) {
            for (int ide2 : mapping_manager.getLogMapMappings().get(ide1)) {
                if (!mapping_manager.isId1SmallerThanId2(ide1, ide2)) continue;
                ++Manchors;
                if (!mapping_manager.isMappingInGoldStandard(ide1, ide2)) continue;
                ++Manchors_ok;
            }
        }
    }

    public static void extractStatisticsMappings2Ask() {
        Mask = mapping_manager.getListOfMappingsToAskUser().size();
        for (MappingObjectInteractivity mapping : mapping_manager.getListOfMappingsToAskUser()) {
            if (!mapping_manager.isMappingInGoldStandard(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2())) continue;
            ++Mask_ok;
        }
    }

    public static void extracStatisticsDiscardedMappings() {
        for (int ide1 : mapping_manager.getDiscardedMappings().keySet()) {
            for (int ide2 : mapping_manager.getDiscardedMappings().get(ide1)) {
                if (!mapping_manager.isId1SmallerThanId2(ide1, ide2)) continue;
                ++Mdisc;
                if (!mapping_manager.isMappingInGoldStandard(ide1, ide2)) continue;
                ++Mdisc_ok;
            }
        }
    }

    public static void extracStatisticsHardDiscardedMappings() {
        for (int ide1 : mapping_manager.getHardDiscardedMappings().keySet()) {
            for (int ide2 : mapping_manager.getHardDiscardedMappings().get(ide1)) {
                if (mapping_manager.isMappingInDiscardedSet(ide1, ide2) || mapping_manager.isMappingInDiscardedSet(ide2, ide1) || !mapping_manager.isId1SmallerThanId2(ide1, ide2)) continue;
                ++Mharddisc;
                if (!mapping_manager.isMappingInGoldStandard(ide1, ide2)) continue;
                ++Mharddisc_ok;
            }
        }
    }

    public static void extracStatisticsConflictiveMappings() {
        for (int ide1 : mapping_manager.getConflictiveMappings().keySet()) {
            for (int ide2 : mapping_manager.getConflictiveMappings().get(ide1)) {
                if (!mapping_manager.isId1SmallerThanId2(ide1, ide2) && mapping_manager.getConflictiveMappings().containsKey(ide2) && mapping_manager.getConflictiveMappings().get(ide2).contains(ide1)) continue;
                ++Mconf;
                if (!mapping_manager.isMappingInGoldStandard(ide1, ide2) && !mapping_manager.isMappingInGoldStandard(ide2, ide1)) continue;
                ++Mconf_ok;
            }
        }
    }

    public static void extracStatisticsConflictiveMappings_D_G() {
        for (int ide1 : mapping_manager.getConflictiveMappings_D_G().keySet()) {
            for (int ide2 : mapping_manager.getConflictiveMappings_D_G().get(ide1)) {
                if (!mapping_manager.isId1SmallerThanId2(ide1, ide2) && mapping_manager.getConflictiveMappings_D_G().containsKey(ide2) && mapping_manager.getConflictiveMappings_D_G().get(ide2).contains(ide1)) continue;
                ++Mconf_dg;
                if (!mapping_manager.isMappingInGoldStandard(ide1, ide2) && !mapping_manager.isMappingInGoldStandard(ide2, ide1)) continue;
                ++Mconf_dg_ok;
            }
        }
    }

    public static void addStatisticsSplitMapping(int ide1, int ide2) {
        ++Msplit;
        if (mapping_manager.isMappingInGoldStandard(ide1, ide2)) {
            ++Msplit_ok;
        }
    }

    public static void addStatisticsMappingsAll(int ide1, int ide2) {
        ++Mall;
        if (mapping_manager.isMappingInGoldStandard(ide1, ide2)) {
            ++Mall_ok;
        }
    }

    public static void setMFinal(int size_m) {
        MFinal = size_m;
    }

    public static void setGoodMFinal(int size_m) {
        MFinal_ok = size_m;
    }

    public static void setMMissing(int size_m) {
        MMissing = size_m;
    }

    public static int getMFinal() {
        return MFinal;
    }

    public static int getGoodMFinal() {
        return MFinal_ok;
    }

    public static int getMMissing() {
        return MMissing;
    }

    public static void setPrecisionAndRecallAnchors(int numGS) {
        precision_anc = (double)Manchors_ok / (double)Manchors;
        recall_anc = (double)Manchors_ok / (double)numGS;
        fmeasure_anc = 2.0 * precision_anc * recall_anc / (precision_anc + recall_anc);
    }

    public static void reInitValues() {
        MFinal = 0;
        MFinal_ok = 0;
        MMissing = 0;
        Mall = 0;
        Mall_ok = 0;
        Manchors = 0;
        Manchors_ok = 0;
        precision_anc = 0.0;
        recall_anc = 0.0;
        fmeasure_anc = 0.0;
        Mask = 0;
        Mask_ok = 0;
        Mask_heur = 0;
        Msplit = 0;
        Msplit_ok = 0;
        Mdisc = 0;
        Mdisc_ok = 0;
        Mharddisc = 0;
        Mharddisc_ok = 0;
        Mconf = 0;
        Mconf_ok = 0;
        Mconf_dg = 0;
        Mconf_dg_ok = 0;
    }

    public static void printStatisticsLogMap_mappings() {
        LogOutput.printAlways("---------------------");
        LogOutput.printAlways("All Candidate mappings: " + Mall);
        LogOutput.printAlways("Good Candidate mappings: " + Mall_ok);
        LogOutput.printAlways("---------------------");
        LogOutput.printAlways("LogMap anchors: " + Manchors);
        LogOutput.printAlways("Good LogMap anchors: " + Manchors_ok);
        LogOutput.printAlways("Precision LogMap anchors: " + precision_anc);
        LogOutput.printAlways("Recall LogMap anchors: " + recall_anc);
        LogOutput.printAlways("Fmeasure LogMap anchors: " + fmeasure_anc);
        LogOutput.printAlways("---------------------");
        LogOutput.printAlways("LogMap 2 ask mappings: " + Mask);
        LogOutput.printAlways("Good LogMap 2ask mappings: " + Mask_ok);
        LogOutput.printAlways("---------------------");
        LogOutput.printAlways("LogMap split mappings: " + Msplit);
        LogOutput.printAlways("Good LogMap split mappings: " + Msplit_ok);
        LogOutput.printAlways("---------------------");
        LogOutput.printAlways("LogMap discarded mappings: " + Mdisc);
        LogOutput.printAlways("Good LogMap discarded mappings: " + Mdisc_ok);
        LogOutput.printAlways("---------------------");
        LogOutput.printAlways("LogMap hard discarded mappings: " + Mharddisc);
        LogOutput.printAlways("Good LogMap hard discarded mappings: " + Mharddisc_ok);
        LogOutput.printAlways("---------------------");
        LogOutput.printAlways("LogMap conflictive mappings: " + Mconf);
        LogOutput.printAlways("Good LogMap conflictive mappings: " + Mconf_ok);
        LogOutput.printAlways("---------------------");
        LogOutput.printAlways("LogMap conflictive mappings D&G: " + Mconf_dg);
        LogOutput.printAlways("Good LogMap conflictive mappings D&G: " + Mconf_dg_ok);
        LogOutput.printAlways("---------------------");
        LogOutput.printAlways("All Candidates recount: " + (Manchors + Mask + Msplit + Mdisc + Mharddisc + Mconf));
        LogOutput.printAlways("Good Candidates recount: " + (Manchors_ok + Mask_ok + Msplit_ok + Mdisc_ok + Mharddisc_ok + Mconf_ok));
        LogOutput.printAlways("---------------------");
    }

    public static void printMappingsAskedHeur() {
        LogOutput.printAlways("\n---------------------");
        LogOutput.printAlways("LogMap asked heuristics: " + Mask_heur);
        LogOutput.printAlways("---------------------\n");
    }

    static {
        Mall = 0;
        Mall_ok = 0;
        Manchors = 0;
        Manchors_ok = 0;
        Mask = 0;
        Mask_ok = 0;
        Mask_heur = 0;
        Msplit = 0;
        Msplit_ok = 0;
        Mdisc = 0;
        Mdisc_ok = 0;
        Mharddisc = 0;
        Mharddisc_ok = 0;
        Mconf = 0;
        Mconf_ok = 0;
        Mconf_dg = 0;
        Mconf_dg_ok = 0;
        precision_anc = 0.0;
        recall_anc = 0.0;
        fmeasure_anc = 0.0;
    }
}

