/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.repair;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import uk.ac.ox.krr.logmap2.indexing.IndexManager;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.mappings.MappingManager;
import uk.ac.ox.krr.logmap2.overlapping.OverlappingExtractor;
import uk.ac.ox.krr.logmap2.reasoning.ReasonerAccess;
import uk.ac.ox.krr.logmap2.reasoning.ReasonerManager;
import uk.ac.ox.krr.logmap2.reasoning.StructuralReasonerExtended;
import uk.ac.ox.krr.logmap2.reasoning.explanation.BlackBoxExplanationExtractor;
import uk.ac.ox.krr.logmap2.reasoning.explanation.PlanExtractor;
import uk.ac.ox.krr.logmap2.utilities.ELAxiomVisitor;
import uk.ac.ox.krr.logmap2.utilities.Utilities;

public class AnchorsAssessmentFullReasoning {
    private IndexManager index;
    private MappingManager mapping_extractor;
    private OverlappingExtractor overlappingExtractor;
    private ReasonerAccess reasoner_access;
    private BlackBoxExplanationExtractor explanations_onto;
    private int max_explanations = 1;
    private int reasoner_id = ReasonerManager.HERMIT;
    private List<Set<OWLAxiom>> justifications_unsat = new ArrayList<Set<OWLAxiom>>();
    private List<Set<OWLAxiom>> repair_plans;
    private PlanExtractor planExtractor;
    private Map<OWLClass, Integer> owlclass2identifier = new HashMap<OWLClass, Integer>();
    private Map<OWLDataProperty, Integer> owldprop2identifier = new HashMap<OWLDataProperty, Integer>();
    private Map<OWLObjectProperty, Integer> owloprop2identifier = new HashMap<OWLObjectProperty, Integer>();
    private MappingAxiomVisitor mappingVisitor = new MappingAxiomVisitor();
    private Set<OWLAxiom> mappingAxioms = new HashSet<OWLAxiom>();
    private Set<OWLAxiom> mappingAxioms2repair = new HashSet<OWLAxiom>();
    private boolean review_anchors = true;
    private StructuralReasonerExtended strctReasoner;
    private long init;
    private long fin;

    public AnchorsAssessmentFullReasoning(int ReasonerID, IndexManager index, MappingManager mapping_extractor, OverlappingExtractor overlappingExtractor, boolean review_anchors) throws Exception {
        this.reasoner_id = ReasonerID;
        this.index = index;
        this.mapping_extractor = mapping_extractor;
        this.overlappingExtractor = overlappingExtractor;
        this.review_anchors = review_anchors;
        this.setUpReasoner(false);
    }

    public void checkUnsatisfiability() throws Exception {
        LogOutput.printAlways("\nUNSATISFIABILITY");
        this.getOWLAxioms4Mappings();
        this.setUpReasoner(false);
        this.init = Calendar.getInstance().getTimeInMillis();
        int unsat = 0;
        int unknown = 0;
        int num_class = 0;
        for (OWLClass cls : this.reasoner_access.getOntology().getClassesInSignature()) {
            ++num_class;
            int state = this.reasoner_access.isSatisfiable_withTimeout((OWLClassExpression)cls, 10);
            if (state == 1) {
                ++unsat;
                continue;
            }
            if (state != 2) continue;
            ++unknown;
            LogOutput.printAlways("\t" + cls.getIRI().toString() + "-  UNKNOWN SAT. Test: " + num_class);
        }
        this.fin = Calendar.getInstance().getTimeInMillis();
        double time = (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
        LogOutput.printAlways("\tUNSAT classes: " + unsat + " of " + this.reasoner_access.getOntology().getClassesInSignature().size());
        LogOutput.printAlways("\tUNKNOWN classes: " + unknown + " of " + this.reasoner_access.getOntology().getClassesInSignature().size());
        LogOutput.printAlways("\tTIME checking unsatisfiability (s): " + time + ", Averageper class: " + Utilities.getRoundValue(time / (double)this.reasoner_access.getOntology().getClassesInSignature().size(), 8));
    }

    public boolean checkIfAnyUnsat() throws Exception {
        LogOutput.printAlways("\nUNSATISFIABILITY");
        long initlocal = Calendar.getInstance().getTimeInMillis();
        int num_class = 0;
        for (OWLClass cls : this.reasoner_access.getOntology().getClassesInSignature()) {
            ++num_class;
            int state = this.reasoner_access.isSatisfiable_withTimeout((OWLClassExpression)cls, 10);
            if (state == 1) {
                return true;
            }
            if (state != 2) continue;
            LogOutput.printAlways("\t" + cls.getIRI().toString() + "-  UNKNOWN SAT. Test: " + num_class);
        }
        this.fin = Calendar.getInstance().getTimeInMillis();
        double time = (double)((float)((double)this.fin - (double)initlocal)) / 1000.0;
        return false;
    }

    public void classifyAndRepairUnsatisfiability() throws Exception {
        this.init = Calendar.getInstance().getTimeInMillis();
        LogOutput.printAlways("\nCLASSIFYING");
        this.getOWLAxioms4Mappings();
        this.setUpReasoner(true);
        this.setUpBlackBosExplanationManager();
        this.strctReasoner = new StructuralReasonerExtended(this.reasoner_access.getOntology());
        int it = 0;
        LogOutput.printAlways("\nREPAIR GREEDY ALGO:");
        while (this.reasoner_access.hasUnsatisfiableClasses()) {
            LogOutput.printAlways("\tUNSAT CLASSES iter  " + it + ": " + this.reasoner_access.getUnsatisfiableClasses().size());
            if (!this.repairUnsatisfiability()) break;
            this.applyBestRepairPlan();
            this.clearStructures();
            this.getOWLAxioms4Mappings();
            LogOutput.printAlways("\tCLASSIFYING");
            this.setUpReasoner(true);
            this.setUpBlackBosExplanationManager();
            ++it;
        }
        this.fin = Calendar.getInstance().getTimeInMillis();
        double time = (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
        LogOutput.printAlways("\tTIME GREEDY Repair Algorithm (s): " + time);
        LogOutput.printAlways("\tUNSAT CLASSES after cleaning: " + this.reasoner_access.getUnsatisfiableClasses().size());
    }

    public ReasonerAccess getReasoner() {
        return this.reasoner_access;
    }

    private void getOWLAxioms4Mappings() {
        this.mappingAxioms.clear();
        this.mappingAxioms2repair.clear();
        if (this.review_anchors) {
            for (int ide1 : this.mapping_extractor.getLogMapMappings().keySet()) {
                for (int ide2 : this.mapping_extractor.getLogMapMappings().get(ide1)) {
                    if (ide1 >= ide2) continue;
                    this.mappingAxioms.add((OWLAxiom)this.index.getFactory().getOWLEquivalentClassesAxiom((OWLClassExpression)this.index.getOWLClass4ConceptIndex(ide1), (OWLClassExpression)this.index.getOWLClass4ConceptIndex(ide2)));
                    this.mappingAxioms2repair.add((OWLAxiom)this.index.getFactory().getOWLEquivalentClassesAxiom((OWLClassExpression)this.index.getOWLClass4ConceptIndex(ide1), (OWLClassExpression)this.index.getOWLClass4ConceptIndex(ide2)));
                    this.owlclass2identifier.put(this.index.getOWLClass4ConceptIndex(ide1), ide1);
                    this.owlclass2identifier.put(this.index.getOWLClass4ConceptIndex(ide2), ide2);
                }
            }
        } else {
            for (int ide1 : this.mapping_extractor.getFixedMappings().keySet()) {
                for (int ide2 : this.mapping_extractor.getFixedMappings().get(ide1)) {
                    if (ide1 >= ide2) continue;
                    this.mappingAxioms.add((OWLAxiom)this.index.getFactory().getOWLEquivalentClassesAxiom((OWLClassExpression)this.index.getOWLClass4ConceptIndex(ide1), (OWLClassExpression)this.index.getOWLClass4ConceptIndex(ide2)));
                    this.owlclass2identifier.put(this.index.getOWLClass4ConceptIndex(ide1), ide1);
                    this.owlclass2identifier.put(this.index.getOWLClass4ConceptIndex(ide2), ide2);
                }
            }
            for (int ide1 : this.mapping_extractor.getMappings2Review().keySet()) {
                for (int ide2 : this.mapping_extractor.getMappings2Review().get(ide1)) {
                    if (ide1 >= ide2) continue;
                    this.mappingAxioms.add((OWLAxiom)this.index.getFactory().getOWLEquivalentClassesAxiom((OWLClassExpression)this.index.getOWLClass4ConceptIndex(ide1), (OWLClassExpression)this.index.getOWLClass4ConceptIndex(ide2)));
                    this.mappingAxioms2repair.add((OWLAxiom)this.index.getFactory().getOWLEquivalentClassesAxiom((OWLClassExpression)this.index.getOWLClass4ConceptIndex(ide1), (OWLClassExpression)this.index.getOWLClass4ConceptIndex(ide2)));
                    this.owlclass2identifier.put(this.index.getOWLClass4ConceptIndex(ide1), ide1);
                    this.owlclass2identifier.put(this.index.getOWLClass4ConceptIndex(ide2), ide2);
                }
            }
        }
        for (int ide1 : this.mapping_extractor.getDataPropertyAnchors().keySet()) {
            int ide2 = this.mapping_extractor.getDataPropertyAnchors().get(ide1);
            this.mappingAxioms.add((OWLAxiom)this.index.getFactory().getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)this.index.getOWLDataProperty4PropertyIndex(ide1), (OWLDataPropertyExpression)this.index.getOWLDataProperty4PropertyIndex(ide2)));
            this.mappingAxioms2repair.add((OWLAxiom)this.index.getFactory().getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)this.index.getOWLDataProperty4PropertyIndex(ide1), (OWLDataPropertyExpression)this.index.getOWLDataProperty4PropertyIndex(ide2)));
            this.owldprop2identifier.put(this.index.getOWLDataProperty4PropertyIndex(ide1), ide1);
            this.owldprop2identifier.put(this.index.getOWLDataProperty4PropertyIndex(ide2), ide2);
        }
        for (int ide1 : this.mapping_extractor.getObjectPropertyAnchors().keySet()) {
            int ide2 = this.mapping_extractor.getObjectPropertyAnchors().get(ide1);
            this.mappingAxioms.add((OWLAxiom)this.index.getFactory().getOWLEquivalentObjectPropertiesAxiom((OWLObjectPropertyExpression)this.index.getOWLObjectProperty4PropertyIndex(ide1), (OWLObjectPropertyExpression)this.index.getOWLObjectProperty4PropertyIndex(ide2)));
            this.mappingAxioms2repair.add((OWLAxiom)this.index.getFactory().getOWLEquivalentObjectPropertiesAxiom((OWLObjectPropertyExpression)this.index.getOWLObjectProperty4PropertyIndex(ide1), (OWLObjectPropertyExpression)this.index.getOWLObjectProperty4PropertyIndex(ide2)));
            this.owloprop2identifier.put(this.index.getOWLObjectProperty4PropertyIndex(ide1), ide1);
            this.owloprop2identifier.put(this.index.getOWLObjectProperty4PropertyIndex(ide2), ide2);
        }
        LogOutput.printAlways("\tNUMBER OF MAPPINGS: " + this.mappingAxioms.size() + " (to repair: " + this.mappingAxioms2repair.size() + ").");
    }

    public void clearStructures() {
        this.reasoner_access.clearStructures();
        this.owlclass2identifier.clear();
        this.owldprop2identifier.clear();
        this.owloprop2identifier.clear();
        this.mappingAxioms.clear();
        this.mappingAxioms2repair.clear();
        this.explanations_onto = null;
        this.justifications_unsat.clear();
    }

    private void setUpReasoner(boolean classify) throws Exception {
        this.reasoner_access = ReasonerManager.getMergedOntologyReasoner(this.reasoner_id, this.overlappingExtractor.getTBOXOverlappingOnto1(), this.overlappingExtractor.getTBOXOverlappingOnto2(), this.mappingAxioms, true);
        if (classify) {
            this.reasoner_access.classifyOntology();
        }
    }

    private void setUpBlackBosExplanationManager() {
        this.explanations_onto = new BlackBoxExplanationExtractor(this.reasoner_access.getOntology(), this.reasoner_access.getReasonerFactory(), this.reasoner_access.getReasoner(), this.mappingAxioms2repair, this.max_explanations);
    }

    private void repairUnsatisfiability(int maxExplanations) {
        this.explanations_onto.setMaxExplanations(maxExplanations);
        this.init = Calendar.getInstance().getTimeInMillis();
        int number = 0;
        int numExplanations = 0;
        int numExplanationsSearch = 0;
        for (OWLClass cls : this.reasoner_access.getUnsatisfiableClasses()) {
            ++number;
            this.explanations_onto.handleExplanations((OWLAxiom)this.index.getFactory().getOWLSubClassOfAxiom((OWLClassExpression)cls, (OWLClassExpression)this.index.getFactory().getOWLNothing()));
            numExplanations += this.explanations_onto.getNumberExplanations();
            numExplanationsSearch += this.explanations_onto.getNumberExplanationSearch();
            if (this.explanations_onto.isTimedOut()) {
                LogOutput.print("Time out in explanation extraction");
            }
            if (number != 10) continue;
            break;
        }
        this.fin = Calendar.getInstance().getTimeInMillis();
        double time = (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
        LogOutput.printAlways("\tAverage Explanations per unsat (s): " + Utilities.getRoundValue((double)numExplanations / (double)number, 4));
        LogOutput.printAlways("\tAverage Explanation Search per unsat (s): " + Utilities.getRoundValue((double)numExplanationsSearch / (double)number, 4));
        LogOutput.printAlways("\tTIME getting explanations per unsat classes (s): " + time + ", Average per unsat class: " + Utilities.getRoundValue(time / (double)number, 4));
    }

    private boolean repairUnsatisfiability() {
        int max_unsat4repair = 100;
        int num = 0;
        this.explanations_onto.setMaxExplanations(1);
        Set<Object> topUnsat = new HashSet();
        if (this.reasoner_access.getUnsatisfiableClasses().size() < 5000) {
            ArrayList<OWLClass> initialUnsat = new ArrayList<OWLClass>();
            HashSet hashSet = new HashSet();
            initialUnsat.addAll(this.reasoner_access.getUnsatisfiableClasses());
            for (int i = 0; i < initialUnsat.size(); ++i) {
                if (hashSet.contains(initialUnsat.get(i))) continue;
                boolean isTop = true;
                for (int j = 0; j < initialUnsat.size(); ++j) {
                    if (i == j) continue;
                    if (this.strctReasoner.areEquivalent((OWLClass)initialUnsat.get(i), (OWLClass)initialUnsat.get(j))) {
                        hashSet.add(initialUnsat.get(j));
                        continue;
                    }
                    if (this.strctReasoner.isSubClassOf((OWLClass)initialUnsat.get(j), (OWLClass)initialUnsat.get(i))) {
                        hashSet.add(initialUnsat.get(j));
                        continue;
                    }
                    if (!this.strctReasoner.isSubClassOf((OWLClass)initialUnsat.get(i), (OWLClass)initialUnsat.get(j))) continue;
                    isTop = false;
                    break;
                }
                if (!isTop) continue;
                topUnsat.add(initialUnsat.get(i));
                if (topUnsat.size() >= max_unsat4repair) break;
            }
            initialUnsat.clear();
            hashSet.clear();
        }
        System.out.println("TopUnsat: " + topUnsat.size());
        if (topUnsat.isEmpty()) {
            topUnsat = this.reasoner_access.getUnsatisfiableClasses();
        }
        for (OWLClass oWLClass : topUnsat) {
            this.explanations_onto.handleExplanations((OWLAxiom)this.index.getFactory().getOWLSubClassOfAxiom((OWLClassExpression)oWLClass, (OWLClassExpression)this.index.getFactory().getOWLNothing()));
            if (this.explanations_onto.isTimedOut()) {
                // empty if block
            }
            this.justifications_unsat.addAll(this.explanations_onto.getExplanations());
            if (++num <= max_unsat4repair) continue;
            break;
        }
        topUnsat.clear();
        this.planExtractor = new PlanExtractor(this.justifications_unsat);
        this.planExtractor.extractPlans();
        this.repair_plans = this.planExtractor.getAllPlansAx();
        LogOutput.printAlways("\tRepair plans number: " + this.repair_plans.size());
        if (this.repair_plans.size() == 0) {
            LogOutput.print("No repairs were found!");
            return false;
        }
        return true;
    }

    private void applyBestRepairPlan() {
        Set<OWLAxiom> best_repair = null;
        double min_conf = 10000.0;
        this.mappingVisitor.setDeleteAxiom(false);
        for (Set<OWLAxiom> repair : this.repair_plans) {
            double conf = this.getConfidence4Plan(repair);
            if (!(min_conf > conf)) continue;
            min_conf = conf;
            best_repair = repair;
        }
        this.mappingVisitor.setDeleteAxiom(true);
        for (OWLAxiom ax : best_repair) {
            ax.accept((OWLAxiomVisitor)this.mappingVisitor);
        }
    }

    private double getConfidence4Plan(Set<OWLAxiom> repair) {
        double conf = 0.0;
        for (OWLAxiom ax : repair) {
            ax.accept((OWLAxiomVisitor)this.mappingVisitor);
            conf += this.mappingVisitor.conf;
        }
        return conf;
    }

    public class MappingAxiomVisitor
    extends ELAxiomVisitor {
        public int ide1;
        public int ide2;
        public int type;
        public double conf;
        private boolean deleteAxiom = false;

        public void setDeleteAxiom(boolean delete_axiom) {
            this.deleteAxiom = delete_axiom;
        }

        @Override
        public void visit(OWLSubClassOfAxiom ax) {
            this.ide1 = (Integer)AnchorsAssessmentFullReasoning.this.owlclass2identifier.get(ax.getSubClass().asOWLClass());
            this.ide2 = (Integer)AnchorsAssessmentFullReasoning.this.owlclass2identifier.get(ax.getSuperClass().asOWLClass());
            this.type = 0;
            this.conf = AnchorsAssessmentFullReasoning.this.mapping_extractor.getConfidence4Mapping(this.ide1, this.ide2);
            this.deleteSubMapping();
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom ax) {
            this.ide1 = (Integer)AnchorsAssessmentFullReasoning.this.owlclass2identifier.get(((OWLClassExpression)ax.getClassExpressionsAsList().get(0)).asOWLClass());
            this.ide2 = (Integer)AnchorsAssessmentFullReasoning.this.owlclass2identifier.get(((OWLClassExpression)ax.getClassExpressionsAsList().get(1)).asOWLClass());
            this.type = 1;
            this.conf = AnchorsAssessmentFullReasoning.this.mapping_extractor.getConfidence4Mapping(this.ide1, this.ide2);
            this.deleteEquivMapping();
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom ax) {
            Iterator it = ax.getProperties().iterator();
            this.ide1 = (Integer)AnchorsAssessmentFullReasoning.this.owloprop2identifier.get(((OWLObjectPropertyExpression)it.next()).asOWLObjectProperty());
            this.ide2 = (Integer)AnchorsAssessmentFullReasoning.this.owloprop2identifier.get(((OWLObjectPropertyExpression)it.next()).asOWLObjectProperty());
            this.type = 2;
            this.conf = AnchorsAssessmentFullReasoning.this.mapping_extractor.getConfidence4ObjectPropertyAnchor(this.ide1, this.ide2);
            if (this.deleteAxiom) {
                AnchorsAssessmentFullReasoning.this.mapping_extractor.getObjectPropertyAnchors().remove(this.ide1);
            }
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom ax) {
            Iterator it = ax.getProperties().iterator();
            this.ide1 = (Integer)AnchorsAssessmentFullReasoning.this.owldprop2identifier.get(((OWLDataPropertyExpression)it.next()).asOWLDataProperty());
            this.ide2 = (Integer)AnchorsAssessmentFullReasoning.this.owloprop2identifier.get(((OWLDataPropertyExpression)it.next()).asOWLDataProperty());
            this.type = 3;
            this.conf = AnchorsAssessmentFullReasoning.this.mapping_extractor.getConfidence4DataPropertyAnchor(this.ide1, this.ide2);
            if (this.deleteAxiom) {
                AnchorsAssessmentFullReasoning.this.mapping_extractor.getDataPropertyAnchors().remove(this.ide1);
            }
        }

        private void deleteSubMapping() {
            if (this.deleteAxiom) {
                if (AnchorsAssessmentFullReasoning.this.review_anchors) {
                    AnchorsAssessmentFullReasoning.this.mapping_extractor.removeSubMappingFromStructure(this.ide1, this.ide2);
                } else {
                    AnchorsAssessmentFullReasoning.this.mapping_extractor.removeSubMappingFromMappings2Review(this.ide1, this.ide2);
                }
                AnchorsAssessmentFullReasoning.this.mapping_extractor.addSubMapping2ConflictiveAnchors(this.ide1, this.ide2);
            }
        }

        private void deleteEquivMapping() {
            if (this.deleteAxiom) {
                if (AnchorsAssessmentFullReasoning.this.review_anchors) {
                    AnchorsAssessmentFullReasoning.this.mapping_extractor.removeSubMappingFromStructure(this.ide1, this.ide2);
                    AnchorsAssessmentFullReasoning.this.mapping_extractor.removeSubMappingFromStructure(this.ide2, this.ide1);
                } else {
                    AnchorsAssessmentFullReasoning.this.mapping_extractor.removeSubMappingFromMappings2Review(this.ide1, this.ide2);
                    AnchorsAssessmentFullReasoning.this.mapping_extractor.removeSubMappingFromMappings2Review(this.ide2, this.ide1);
                }
                AnchorsAssessmentFullReasoning.this.mapping_extractor.addSubMapping2ConflictiveAnchors(this.ide1, this.ide2);
                AnchorsAssessmentFullReasoning.this.mapping_extractor.addSubMapping2ConflictiveAnchors(this.ide2, this.ide1);
            }
        }
    }
}

