/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.reasoning.profiles;

import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.profiles.OWL2DLProfile;
import org.semanticweb.owlapi.profiles.OWL2ELProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import uk.ac.ox.krr.logmap2.OntologyLoader;

public class CheckOWL2Profile {
    OWLOntology onto;
    OWL2DLProfile owl2dlchecker = new OWL2DLProfile();
    OWL2ELProfile owl2elchecker = new OWL2ELProfile();
    OWLProfileReport report;

    public CheckOWL2Profile(OWLOntology onto) {
        this.onto = onto;
    }

    public CheckOWL2Profile() {
    }

    public boolean isInOWL2ELProfile(OWLOntology onto) {
        try {
            this.report = this.owl2elchecker.checkOntology(onto);
            for (OWLProfileViolation violation : this.report.getViolations()) {
                if (violation.toString().startsWith("Use of undeclared class") || violation.toString().startsWith("Use of undeclared object property") || violation.toString().startsWith("Use of undeclared data property") || violation.toString().startsWith("Use of data range not in profile: xsd:") || violation.toString().startsWith("Not enough operands; at least two needed:") || violation.toString().startsWith("Use of reserved vocabulary for class IRI: rdf:List")) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public OWLProfileReport getReport4OWL2DL() {
        return this.owl2dlchecker.checkOntology(this.onto);
    }

    public OWLProfileReport getReport4OWL2EL() {
        return this.owl2elchecker.checkOntology(this.onto);
    }

    public static void main(String[] args) {
        try {
            OntologyLoader loader = new OntologyLoader("http://www.co-ode.org/ontologies/pizza/pizza.owl");
            CheckOWL2Profile checker = new CheckOWL2Profile(loader.getOWLOntology());
            System.out.println("OWL 2 DL:\n" + checker.getReport4OWL2DL().isInProfile());
            System.out.println("");
            System.out.println("OWL 2 EL:\n" + checker.getReport4OWL2EL().isInProfile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

