/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.reasoning.explanation;

import com.clarkparsia.owlapi.explanation.util.ExplanationProgressMonitor;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;

public class ExplanationProgressManager
implements ExplanationProgressMonitor {
    private Set<Set<OWLAxiom>> SetOfJustAxioms = new HashSet<Set<OWLAxiom>>();
    boolean cancelled = false;
    private int maxExplanations = 50;
    private int numberExplanations = 0;
    private int maxExplanationSearch = 500;
    private int explanationSearch = 0;
    private Set<OWLAxiom> axioms2consider;
    private long max_time = 60000L;
    private long time_out;

    public ExplanationProgressManager(Set<OWLAxiom> axioms2consider, int maxExplanations) {
        this.axioms2consider = axioms2consider;
        this.maxExplanations = maxExplanations;
        this.cancelled = false;
    }

    public boolean isCancelled() {
        if (System.currentTimeMillis() > this.time_out) {
            this.cancelled = true;
        }
        return this.cancelled;
    }

    public void foundExplanation(Set<OWLAxiom> set) {
        this.handleFoundExplanation(set);
    }

    public void foundAllExplanations() {
        this.cancelled = true;
    }

    private void handleFoundExplanation(Set<OWLAxiom> explanation) {
        if (this.cancelled) {
            return;
        }
        ++this.explanationSearch;
        if (!this.SetOfJustAxioms.contains(explanation)) {
            if (this.axioms2consider.size() > 0) {
                explanation.retainAll(this.axioms2consider);
            }
            if (explanation.size() > 0) {
                this.SetOfJustAxioms.add(explanation);
                ++this.numberExplanations;
            }
        }
        if (this.numberExplanations >= this.maxExplanations || this.explanationSearch > this.maxExplanationSearch || System.currentTimeMillis() > this.time_out) {
            this.cancelled = true;
        }
    }

    public Set<Set<OWLAxiom>> getSetOfExplanantions() {
        return this.SetOfJustAxioms;
    }

    public void setClearMonitor() {
        this.SetOfJustAxioms.clear();
        this.cancelled = false;
        this.numberExplanations = 0;
        this.explanationSearch = 0;
        this.time_out = System.currentTimeMillis() + this.max_time;
    }

    public void setMaxExplanations(int maxExp) {
        this.maxExplanations = maxExp;
    }

    public void setMaxExplanationSearch(int maxSearch) {
        this.maxExplanationSearch = maxSearch;
    }

    public void setMaxTimeOut(long milisec) {
        this.max_time = milisec;
    }

    public int getNumberExplanations() {
        return this.numberExplanations;
    }

    public int getNumberExplanationSearch() {
        return this.explanationSearch;
    }
}

