/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.reasoning;

import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;

public class DisjointnessAxiomExtractor {
    public static OWLClassNodeSet getExplicitOWLDisjointnessAxioms(OWLReasoner reasoner, OWLOntology ontology, OWLClass cls) {
        OWLClassNodeSet nodeSet = new OWLClassNodeSet();
        for (OWLDisjointClassesAxiom ax : ontology.getDisjointClassesAxioms(cls)) {
            for (OWLClassExpression op : ax.getClassExpressions()) {
                if (op.isAnonymous() || op.equals(cls)) continue;
                nodeSet.addNode(reasoner.getEquivalentClasses(op));
            }
        }
        return nodeSet;
    }

    public static OWLClassNodeSet getExplicitDLDisjointnessAxioms(OWLReasoner reasoner, OWLOntology ontology, OWLClass cls) {
        OWLClassNodeSet nodeSet = new OWLClassNodeSet();
        block0: for (OWLSubClassOfAxiom sax : ontology.getSubClassAxiomsForSuperClass(OWLManager.getOWLDataFactory().getOWLNothing())) {
            Set set;
            OWLClassExpression subExp = sax.getSubClass();
            if (!(subExp instanceof OWLObjectIntersectionOf) || !(set = subExp.asConjunctSet()).contains(cls) || set.size() != 2) continue;
            for (OWLClassExpression op : set) {
                if (op.equals(cls) || op.isAnonymous()) continue;
                nodeSet.addNode(reasoner.getEquivalentClasses(op));
                continue block0;
            }
        }
        return nodeSet;
    }

    public static OWLClassNodeSet getDisjointnessAxiomsWithNegation(OWLReasoner reasoner, OWLOntology ontology, OWLClass cls) {
        OWLClassNodeSet nodeSet = new OWLClassNodeSet();
        for (OWLClassAxiom ax : ontology.getAxioms(cls.asOWLClass())) {
            OWLClassExpression exp;
            OWLSubClassOfAxiom sax2;
            OWLClassExpression sup;
            if (!(ax instanceof OWLSubClassOfAxiom) || !((sup = (sax2 = (OWLSubClassOfAxiom)ax).getSuperClass()) instanceof OWLObjectComplementOf)) continue;
            OWLClassExpression sub = sax2.getSubClass();
            if (sub.equals(cls)) {
                exp = ((OWLObjectComplementOf)sup).getOperand();
                if (exp.isAnonymous()) continue;
                nodeSet.addNode(reasoner.getEquivalentClasses(exp));
                continue;
            }
            if (sub.isAnonymous() || !(exp = ((OWLObjectComplementOf)sup).getOperand()).equals(cls)) continue;
            nodeSet.addNode(reasoner.getEquivalentClasses(sub));
        }
        return nodeSet;
    }
}

