/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.oaei.reader;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.oaei.reader.MappingsReader;
import uk.ac.ox.krr.logmap2.oaei.reader.OWLMappingAxiomVisitor;

public class OWLAlignmentReader
extends MappingsReader {
    OWLMappingAxiomVisitor4Reader owlMappingAxiomVisitor = new OWLMappingAxiomVisitor4Reader();
    ValueVisitor valueVisitor = new ValueVisitor();

    public OWLAlignmentReader(String owl_alignment_file) throws Exception {
        OWLOntology onto_mappings = this.loadOntology(owl_alignment_file);
        for (OWLAxiom ax : onto_mappings.getAxioms()) {
            this.owlMappingAxiomVisitor.reInitValues();
            ax.accept((OWLAxiomVisitor)this.owlMappingAxiomVisitor);
            if (this.owlMappingAxiomVisitor.getIRIEntity1() == null || this.owlMappingAxiomVisitor.getIRIEntity2() == null || this.owlMappingAxiomVisitor.getIRIEntity1().equals("") || this.owlMappingAxiomVisitor.getIRIEntity2().equals("")) continue;
            this.mappings.add(new MappingObjectStr(this.owlMappingAxiomVisitor.getIRIEntity1(), this.owlMappingAxiomVisitor.getIRIEntity2(), this.owlMappingAxiomVisitor.getMeasure(), this.owlMappingAxiomVisitor.getRelation(), this.owlMappingAxiomVisitor.getTypeMapping()));
        }
        LogOutput.print("Read OWL mapping objects: " + this.getMappingObjectsSize());
    }

    private OWLOntology loadOntology(String uri) throws Exception {
        System.out.println("Loading ontology " + uri);
        return this.loadOntology(IRI.create((String)uri));
    }

    private OWLOntology loadOntology(IRI uri) throws Exception {
        OWLOntologyManager ontologyManager = OWLManager.createOWLOntologyManager();
        return ontologyManager.loadOntology(uri);
    }

    public static void main(String[] args) {
        String mappings_path = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/OAEI_datasets/Mappings_Tools_2012/";
        try {
            new OWLAlignmentReader(mappings_path + "logmap_small_fma2nci_new.owl");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class ValueVisitor
    implements OWLAnnotationValueVisitor {
        String literal_str;

        public void visit(OWLLiteral literal) {
            this.literal_str = literal.getLiteral();
            if (literal.isDouble()) {
                OWLAlignmentReader.this.owlMappingAxiomVisitor.setMeasure(literal.parseDouble());
            } else if (this.literal_str.equals("=")) {
                OWLAlignmentReader.this.owlMappingAxiomVisitor.setRelation(-2);
            } else if (this.literal_str.equals(">")) {
                OWLAlignmentReader.this.owlMappingAxiomVisitor.setRelation(-1);
            } else if (this.literal_str.equals("<")) {
                OWLAlignmentReader.this.owlMappingAxiomVisitor.setRelation(0);
            }
        }

        public String getStringLiteral() {
            return this.literal_str;
        }

        public void visit(IRI iri) {
        }

        public void visit(OWLAnonymousIndividual individual) {
        }
    }

    public class OWLMappingAxiomVisitor4Reader
    extends OWLMappingAxiomVisitor {
        private String iri1;
        private String iri2;
        private int relation;
        private int type;
        private double measure;

        public String getIRIEntity1() {
            return this.iri1;
        }

        public String getIRIEntity2() {
            return this.iri2;
        }

        public int getRelation() {
            return this.relation;
        }

        public int getTypeMapping() {
            return this.type;
        }

        public double getMeasure() {
            return this.measure;
        }

        public void setMeasure(double conf) {
            this.measure = conf;
        }

        public void setRelation(int rel) {
            this.relation = rel;
        }

        private void reInitValues() {
            this.iri1 = "";
            this.iri2 = "";
            this.type = 0;
            this.relation = -2;
        }

        private void treatAnnotation(OWLAnnotation ann) {
            String property = ann.getProperty().getIRI().toString().toLowerCase();
            if (property.contains("entity1")) {
                ann.getValue().accept((OWLAnnotationValueVisitor)OWLAlignmentReader.this.valueVisitor);
                this.iri1 = OWLAlignmentReader.this.valueVisitor.getStringLiteral();
            } else if (property.contains("entity2")) {
                ann.getValue().accept((OWLAnnotationValueVisitor)OWLAlignmentReader.this.valueVisitor);
                this.iri2 = OWLAlignmentReader.this.valueVisitor.getStringLiteral();
            } else if (property.contains("measure")) {
                ann.getValue().accept((OWLAnnotationValueVisitor)OWLAlignmentReader.this.valueVisitor);
            } else if (property.contains("relation")) {
                ann.getValue().accept((OWLAnnotationValueVisitor)OWLAlignmentReader.this.valueVisitor);
            }
        }

        @Override
        public void visit(OWLSubClassOfAxiom ax) {
            this.type = 0;
            for (OWLAnnotation ann : ax.getAnnotations()) {
                this.treatAnnotation(ann);
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom ax) {
            this.relation = -2;
            this.type = 0;
            for (OWLAnnotation ann : ax.getAnnotations()) {
                this.treatAnnotation(ann);
            }
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom ax) {
            this.relation = -2;
            this.type = 2;
            for (OWLAnnotation ann : ax.getAnnotations()) {
                this.treatAnnotation(ann);
            }
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom ax) {
            this.type = 2;
            for (OWLAnnotation ann : ax.getAnnotations()) {
                this.treatAnnotation(ann);
            }
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom ax) {
            this.relation = -2;
            this.type = 1;
            for (OWLAnnotation ann : ax.getAnnotations()) {
                this.treatAnnotation(ann);
            }
        }

        @Override
        public void visit(OWLSubDataPropertyOfAxiom ax) {
            this.type = 1;
            for (OWLAnnotation ann : ax.getAnnotations()) {
                this.treatAnnotation(ann);
            }
        }

        @Override
        public void visit(OWLSameIndividualAxiom ax) {
            this.relation = -2;
            this.type = 3;
            for (OWLAnnotation ann : ax.getAnnotations()) {
                this.treatAnnotation(ann);
            }
        }
    }
}

