/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.oaei.oracle;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import uk.ac.ox.krr.logmap2.io.ReadFile;
import uk.ac.ox.krr.logmap2.oaei.oracle.Oraculo;

public class LocalOracle
extends Oraculo {
    private static Map<String, Set<String>> oracle_mappings = new HashMap<String, Set<String>>();

    @Override
    public boolean isMappingValid(String uri1, String uri2) {
        return LocalOracle.isMappingInLocalOracle(uri1, uri2);
    }

    private static void addMapping2LocalOracle(String uri1, String uri2) {
        if (!oracle_mappings.containsKey(uri1)) {
            oracle_mappings.put(uri1, new HashSet());
        }
        oracle_mappings.get(uri1).add(uri2);
    }

    private static boolean isMappingInLocalOracle(String uri1, String uri2) {
        return oracle_mappings.containsKey(uri1) && oracle_mappings.get(uri1).contains(uri2);
    }

    public static void loadLocalOraculo(String base_path) {
        try {
            int count = 0;
            String pattern = ".txt";
            File directory = new File(base_path);
            String[] filenames = directory.list();
            for (int i = 0; i < filenames.length; ++i) {
                if (!filenames[i].contains(pattern)) continue;
                ReadFile reader = new ReadFile(base_path + filenames[i]);
                String line = reader.readLine();
                while (line != null) {
                    if (line.indexOf("|") < 0) {
                        line = reader.readLine();
                        continue;
                    }
                    String[] elements = line.split("\\|");
                    LocalOracle.addMapping2LocalOracle(elements[0], elements[1]);
                    ++count;
                    line = reader.readLine();
                }
                reader.closeBuffer();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String base_path = "/usr/local/data/MappingsConferenceBenchmark/reference-alignment-subset2012/";
        LocalOracle.loadLocalOraculo(base_path);
    }

    @Override
    public boolean isActive() {
        return true;
    }
}

