/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.multilingual;

import com.memetix.mst.language.Language;
import com.memetix.mst.translate.Translate;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.multilingual.Translator;

public class MicrosoftBasedTranslator
extends Translator {
    public static final Map<String, Language> LanguageMap = new HashMap<String, Language>(){
        {
            for (Language lang : Language.values()) {
                if (lang.toString().length() != 2) continue;
                this.put(lang.toString(), lang);
            }
            this.put("zh", Language.CHINESE_SIMPLIFIED);
            this.put("cn", Language.CHINESE_SIMPLIFIED);
            this.put("cz", Language.CZECH);
        }
    };

    @Override
    public String getToolAPITranslation(String label, String originLang, String targetLang) throws Exception {
        return this.getMicrosoftTranslation(label, originLang, targetLang);
    }

    private String getMicrosoftTranslation(String text, String originLangStr, String targetLangStr) throws Exception {
        if (text.equals("") || text.equals(" ")) {
            return "";
        }
        String translatedText = text;
        if (this.isInLocalDictionary(text)) {
            return this.getLocalTranslation(text);
        }
        if (Parameters.call_online_translator) {
            Translate.setClientId((String)"LogMapMultilingualOntologyMatcher");
            Translate.setClientSecret((String)"YMWwAB7c3qRQ+QoBnH/dtZx8C9kFqQObhqZpmGGdE4E=");
            Language originLang = LanguageMap.get(originLangStr);
            Language targetLang = LanguageMap.get(targetLangStr);
            this.num_tranlated_characters += text.length();
            ++this.num_calls;
            LogOutput.printAlways("Translating: '" + text + "' from " + originLangStr + " to " + targetLangStr + " using Microsoft API. Num chars translated so far: " + this.num_tranlated_characters);
            if (!Parameters.is_test_mode_multilingual) {
                try {
                    translatedText = Translate.execute((String)text, (Language)originLang, (Language)targetLang);
                }
                catch (Exception e) {
                    LogOutput.printError("Error Translating: '" + text + "' from " + originLangStr + " to " + targetLangStr + " using Microsoft API. " + e.getMessage());
                    return "";
                }
            } else {
                translatedText = text + "_" + this.num_tranlated_characters + "_m";
            }
            this.addTranslation2Map(text, translatedText);
        }
        return translatedText;
    }

    @Override
    public String getTranslatorName() {
        return "microsoft";
    }

    public static void main(String[] args) {
        MicrosoftBasedTranslator translator = new MicrosoftBasedTranslator();
        System.out.println("'" + translator.getTranslation("MedicoCabecera", "es", "en") + "'");
        for (Language l : Language.values()) {
            if (l.toString().length() <= 1) continue;
            System.out.println(l.toString().length() + "  " + l.toString().substring(0, 2) + "  " + l.name() + "  " + l.toString());
        }
        System.out.println(Language.ENGLISH.toString());
        System.out.println(Language.CHINESE_SIMPLIFIED.toString());
        System.out.println(Language.CHINESE_TRADITIONAL.toString());
        System.out.println(Language.CZECH);
    }
}

