/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.io;

import java.util.Vector;
import uk.ac.ox.krr.logmap2.io.FlatAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.FlatTSVAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.OAEIRDFAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.OWLAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.OutputMappingsFormat;

public class OutPutFilesManagerStatic {
    public static final int OWLFormat = 0;
    public static final int OAEIFormat = 1;
    public static final int FlatFormat = 2;
    public static final int FlatTSVFormat = 3;
    public static final int AllFormats = 4;
    private static Vector<OutputMappingsFormat> file_formats = new Vector();

    public static void createOutFiles(String output_file, int file_type, String oiri1, String oiri2) throws Exception {
        file_formats.clear();
        if (file_type == 0) {
            file_formats.add(new OWLAlignmentFormat("file:" + output_file + ".owl"));
        } else if (file_type == 1) {
            file_formats.add(new OAEIRDFAlignmentFormat(output_file + ".rdf", oiri1, oiri2));
        } else if (file_type == 2) {
            file_formats.add(new FlatAlignmentFormat(output_file + ".txt"));
        } else if (file_type == 3) {
            file_formats.add(new FlatAlignmentFormat(output_file + ".tsv"));
        } else {
            file_formats.add(new OWLAlignmentFormat("file:" + output_file + ".owl"));
            file_formats.add(new OAEIRDFAlignmentFormat(output_file + ".rdf", oiri1, oiri2));
            file_formats.add(new FlatAlignmentFormat(output_file + ".txt"));
            file_formats.add(new FlatTSVAlignmentFormat(output_file + ".tsv"));
        }
    }

    public static void addClassMapping2Files(String iri_str1, String iri_str2, int dir_mapping, double conf) throws Exception {
        for (int i = 0; i < file_formats.size(); ++i) {
            file_formats.get(i).addClassMapping2Output(iri_str1, iri_str2, dir_mapping, conf);
        }
    }

    public static void addDataPropMapping2Files(String iri_str1, String iri_str2, int dir_mapping, double conf) throws Exception {
        for (int i = 0; i < file_formats.size(); ++i) {
            file_formats.get(i).addDataPropMapping2Output(iri_str1, iri_str2, dir_mapping, conf);
        }
    }

    public static void addObjPropMapping2Files(String iri_str1, String iri_str2, int dir_mapping, double conf) throws Exception {
        for (int i = 0; i < file_formats.size(); ++i) {
            file_formats.get(i).addObjPropMapping2Output(iri_str1, iri_str2, dir_mapping, conf);
        }
    }

    public static void addInstanceMapping2Files(String iri_str1, String iri_str2, double conf) throws Exception {
        for (int i = 0; i < file_formats.size(); ++i) {
            file_formats.get(i).addInstanceMapping2Output(iri_str1, iri_str2, conf);
        }
    }

    public static void closeAndSaveFiles() throws Exception {
        for (int i = 0; i < file_formats.size(); ++i) {
            file_formats.get(i).saveOutputFile();
        }
    }
}

