/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.io;

import java.util.Set;
import java.util.Vector;
import uk.ac.ox.krr.logmap2.io.FlatAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.FlatTSVAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.OAEIRDFAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.OWLAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.OutputMappingsFormat;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;

public class OutPutFilesManager {
    public static final int OWLFormat = 0;
    public static final int OAEIFormat = 1;
    public static final int FlatFormat = 2;
    public static final int FlatTSVFormat = 3;
    public static final int AllFormats = 4;
    private Vector<OutputMappingsFormat> file_formats = new Vector();

    public void createOutFiles(String output_file, int file_type, String oiri1, String oiri2) throws Exception {
        this.file_formats.clear();
        if (file_type == 0) {
            this.file_formats.add(new OWLAlignmentFormat("file:" + output_file + ".owl"));
        } else if (file_type == 1) {
            this.file_formats.add(new OAEIRDFAlignmentFormat(output_file + ".rdf", oiri1, oiri2));
        } else if (file_type == 2) {
            this.file_formats.add(new FlatAlignmentFormat(output_file + ".txt"));
        } else if (file_type == 3) {
            this.file_formats.add(new FlatAlignmentFormat(output_file + ".tsv"));
        } else {
            this.file_formats.add(new OWLAlignmentFormat("file:" + output_file + ".owl"));
            this.file_formats.add(new OAEIRDFAlignmentFormat(output_file + ".rdf", oiri1, oiri2));
            this.file_formats.add(new FlatAlignmentFormat(output_file + ".txt"));
            this.file_formats.add(new FlatTSVAlignmentFormat(output_file + ".tsv"));
        }
    }

    public void addMapping(MappingObjectStr mapping) throws Exception {
        if (mapping.isClassMapping()) {
            this.addClassMapping2Files(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
        } else if (mapping.isObjectPropertyMapping()) {
            this.addObjPropMapping2Files(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
        } else if (mapping.isDataPropertyMapping()) {
            this.addDataPropMapping2Files(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
        } else if (mapping.isInstanceMapping()) {
            this.addInstanceMapping2Files(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getConfidence());
        } else {
            this.addClassMapping2Files(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
        }
    }

    public void addMappings(Set<MappingObjectStr> mappings) throws Exception {
        for (MappingObjectStr mapping : mappings) {
            this.addMapping(mapping);
        }
    }

    public void addClassMapping2Files(String iri_str1, String iri_str2, int dir_mapping, double conf) throws Exception {
        for (int i = 0; i < this.file_formats.size(); ++i) {
            this.file_formats.get(i).addClassMapping2Output(iri_str1, iri_str2, dir_mapping, conf);
        }
    }

    public void addDataPropMapping2Files(String iri_str1, String iri_str2, int dir_mapping, double conf) throws Exception {
        for (int i = 0; i < this.file_formats.size(); ++i) {
            this.file_formats.get(i).addDataPropMapping2Output(iri_str1, iri_str2, dir_mapping, conf);
        }
    }

    public void addObjPropMapping2Files(String iri_str1, String iri_str2, int dir_mapping, double conf) throws Exception {
        for (int i = 0; i < this.file_formats.size(); ++i) {
            this.file_formats.get(i).addObjPropMapping2Output(iri_str1, iri_str2, dir_mapping, conf);
        }
    }

    public void addInstanceMapping2Files(String iri_str1, String iri_str2, double conf) throws Exception {
        for (int i = 0; i < this.file_formats.size(); ++i) {
            this.file_formats.get(i).addInstanceMapping2Output(iri_str1, iri_str2, conf);
        }
    }

    public void closeAndSaveFiles() throws Exception {
        for (int i = 0; i < this.file_formats.size(); ++i) {
            this.file_formats.get(i).saveOutputFile();
        }
    }
}

