/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.io;

import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import uk.ac.ox.krr.logmap2.io.OutPutFilesManager;
import uk.ac.ox.krr.logmap2.utilities.Utilities;

public class OWL2RDFAlignment {
    protected OWLOntologyManager managerOnto;
    protected OWLOntology onto;
    protected String iri_onto1;
    protected String iri_onto2;
    protected double conf = 100.0;
    OutPutFilesManager outPutFilesManager = new OutPutFilesManager();

    public OWL2RDFAlignment(String owl_file_path, String oaei_file_path, String iri_onto1, String iri_onto2) throws Exception {
        this.iri_onto1 = iri_onto1;
        this.iri_onto2 = iri_onto2;
        this.outPutFilesManager.createOutFiles(oaei_file_path, 1, iri_onto1, iri_onto2);
        System.out.println("Load ontology: ");
        this.loadOWLMappings(owl_file_path);
        this.outPutFilesManager.closeAndSaveFiles();
    }

    private void setSilentMissingImportStrategy() {
        OWLOntologyLoaderConfiguration config = new OWLOntologyLoaderConfiguration();
        config.setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT);
        this.managerOnto.setOntologyLoaderConfiguration(config);
    }

    private void loadOWLMappings(String phy_iri_onto) throws Exception {
        this.managerOnto = OWLManager.createOWLOntologyManager();
        this.setSilentMissingImportStrategy();
        this.onto = this.managerOnto.loadOntology(IRI.create((String)phy_iri_onto));
        MappingVisitor mVisitor = new MappingVisitor();
        for (OWLAxiom ax : this.onto.getAxioms()) {
            ax.accept((OWLAxiomVisitor)mVisitor);
        }
    }

    public static void main(String[] args) {
        String rootPath = "/usr/local/data/DataUMLS/UMLS_Onto_Versions/";
        String irirootPath = "file:/usr/local/data/DataUMLS/UMLS_Onto_Versions/";
        String fma = "http://bioontology.org/projects/ontologies/fma/fmaOwlDlComponent_2_0";
        String nci = "http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl";
        String snmd = "http://www.ihtsdo.org/snomed";
        try {
            String pair_path = irirootPath + "FMA2NCI/UMLS_debugging/FMA2NCI_original_UMLS_mappings.owl";
            String pair_path_out = rootPath + "FMA2NCI/UMLS_debugging/FMA2NCI_original_UMLS_mappings";
            new OWL2RDFAlignment(pair_path, pair_path_out, fma, nci);
            pair_path = irirootPath + "FMA2SNOMED/UMLS_debugging/FMA2SNMD_original_UMLS_mappings.owl";
            pair_path_out = rootPath + "FMA2SNOMED/UMLS_debugging/FMA2SNMD_original_UMLS_mappings";
            new OWL2RDFAlignment(pair_path, pair_path_out, fma, snmd);
            pair_path = irirootPath + "SNOMED2NCI/UMLS_debugging/SNMD2NCI_original_UMLS_mappings.owl";
            pair_path_out = rootPath + "SNOMED2NCI/UMLS_debugging/SNMD2NCI_original_UMLS_mappings";
            new OWL2RDFAlignment(pair_path, pair_path_out, snmd, nci);
            pair_path = irirootPath + "FMA2NCI/UMLS_debugging/FMA2NCI_repaired_UMLS_mappings.owl";
            pair_path_out = rootPath + "FMA2NCI/UMLS_debugging/FMA2NCI_repaired_UMLS_mappings";
            new OWL2RDFAlignment(pair_path, pair_path_out, fma, nci);
            pair_path = irirootPath + "FMA2SNOMED/UMLS_debugging/FMA2SNMD_repaired_UMLS_mappings.owl";
            pair_path_out = rootPath + "FMA2SNOMED/UMLS_debugging/FMA2SNMD_repaired_UMLS_mappings";
            new OWL2RDFAlignment(pair_path, pair_path_out, fma, snmd);
            pair_path = irirootPath + "SNOMED2NCI/UMLS_debugging/SNMD2NCI_repaired_UMLS_mappings.owl";
            pair_path_out = rootPath + "SNOMED2NCI/UMLS_debugging/SNMD2NCI_repaired_UMLS_mappings";
            new OWL2RDFAlignment(pair_path, pair_path_out, snmd, nci);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class MappingVisitor
    implements OWLAxiomVisitor {
        private boolean isFromOnto1(String iri1) {
            return Utilities.getNameSpaceFromURI(iri1).equals(OWL2RDFAlignment.this.iri_onto1);
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            String iri1 = axiom.getSubClass().asOWLClass().getIRI().toString();
            String iri2 = axiom.getSuperClass().asOWLClass().getIRI().toString();
            try {
                if (this.isFromOnto1(iri1)) {
                    OWL2RDFAlignment.this.outPutFilesManager.addClassMapping2Files(iri1, iri2, 0, OWL2RDFAlignment.this.conf);
                } else {
                    OWL2RDFAlignment.this.outPutFilesManager.addClassMapping2Files(iri2, iri1, -1, OWL2RDFAlignment.this.conf);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            String iri1 = ((OWLClassExpression)axiom.getClassExpressionsAsList().get(0)).asOWLClass().getIRI().toString();
            String iri2 = ((OWLClassExpression)axiom.getClassExpressionsAsList().get(1)).asOWLClass().getIRI().toString();
            try {
                if (this.isFromOnto1(iri1)) {
                    OWL2RDFAlignment.this.outPutFilesManager.addClassMapping2Files(iri1, iri2, -2, OWL2RDFAlignment.this.conf);
                } else {
                    OWL2RDFAlignment.this.outPutFilesManager.addClassMapping2Files(iri2, iri1, -2, OWL2RDFAlignment.this.conf);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        }

        public void visit(OWLAnnotationAssertionAxiom arg0) {
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom arg0) {
        }

        public void visit(OWLAnnotationPropertyDomainAxiom arg0) {
        }

        public void visit(OWLAnnotationPropertyRangeAxiom arg0) {
        }

        public void visit(OWLDeclarationAxiom arg0) {
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom arg0) {
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom arg0) {
        }

        public void visit(OWLReflexiveObjectPropertyAxiom arg0) {
        }

        public void visit(OWLDisjointClassesAxiom arg0) {
        }

        public void visit(OWLDataPropertyDomainAxiom arg0) {
        }

        public void visit(OWLObjectPropertyDomainAxiom arg0) {
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom arg0) {
        }

        public void visit(OWLDifferentIndividualsAxiom arg0) {
        }

        public void visit(OWLDisjointDataPropertiesAxiom arg0) {
        }

        public void visit(OWLDisjointObjectPropertiesAxiom arg0) {
        }

        public void visit(OWLObjectPropertyRangeAxiom arg0) {
        }

        public void visit(OWLObjectPropertyAssertionAxiom arg0) {
        }

        public void visit(OWLFunctionalObjectPropertyAxiom arg0) {
        }

        public void visit(OWLDisjointUnionAxiom arg0) {
        }

        public void visit(OWLSymmetricObjectPropertyAxiom arg0) {
        }

        public void visit(OWLDataPropertyRangeAxiom arg0) {
        }

        public void visit(OWLFunctionalDataPropertyAxiom arg0) {
        }

        public void visit(OWLClassAssertionAxiom arg0) {
        }

        public void visit(OWLDataPropertyAssertionAxiom arg0) {
        }

        public void visit(OWLTransitiveObjectPropertyAxiom arg0) {
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom arg0) {
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom arg0) {
        }

        public void visit(OWLSameIndividualAxiom arg0) {
        }

        public void visit(OWLSubPropertyChainOfAxiom arg0) {
        }

        public void visit(OWLInverseObjectPropertiesAxiom arg0) {
        }

        public void visit(OWLHasKeyAxiom arg0) {
        }

        public void visit(OWLDatatypeDefinitionAxiom arg0) {
        }

        public void visit(SWRLRule arg0) {
        }
    }
}

