/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.interactive;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import uk.ac.ox.krr.logmap2.indexing.IndexManager;
import uk.ac.ox.krr.logmap2.interactive.InteractiveProcess;
import uk.ac.ox.krr.logmap2.interactive.objects.MappingObjectInteractivity;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.mappings.MappingManager;
import uk.ac.ox.krr.logmap2.oaei.oracle.OracleManager;

public class InteractiveProcessOAEI
extends InteractiveProcess {
    private List<MappingObjectInteractivity> listOrderedMappings2Ask = new ArrayList<MappingObjectInteractivity>();
    private IndexManager index;
    private MappingManager mapping_manager;
    private boolean apply_heuristics;
    private boolean ask_everything;
    private Stack<MappingObjectInteractivity> new2Add;
    private Stack<MappingObjectInteractivity> new2Del;

    public InteractiveProcessOAEI(IndexManager index, MappingManager mapping_manager, boolean ask_everything, boolean apply_heuristics) {
        this.index = index;
        this.mapping_manager = mapping_manager;
        this.apply_heuristics = apply_heuristics;
        this.ask_everything = ask_everything;
        LogOutput.printAlways("Creating ordered mappings to ask to the (simulated) user...");
        this.createOrderedMappings();
        if (!ask_everything) {
            if (apply_heuristics) {
                this.extractAmbiguities();
            }
            this.extractConflicts();
        }
    }

    @Override
    public void startInteractiveProcess() {
        this.new2Add = new Stack();
        this.new2Del = new Stack();
        for (MappingObjectInteractivity mapping : this.listOrderedMappings2Ask) {
            if (mapping.hasDecision()) continue;
            LogOutput.printAlways("Asking mapping...");
            if (OracleManager.isMappingValid(this.index.getIRIStr4ConceptIndex(mapping.getIdentifierOnto1()), this.index.getIRIStr4ConceptIndex(mapping.getIdentifierOnto2()))) {
                mapping.setAddedFlag(true);
                mapping.setAssessedFlag(true);
                if (!this.ask_everything) {
                    this.new2Add.add(mapping);
                }
            } else {
                mapping.setRemovedFlag(true);
                mapping.setAssessedFlag(true);
                if (!this.ask_everything) {
                    this.new2Del.add(mapping);
                }
            }
            if (this.ask_everything) continue;
            this.exploitImpactUserFeedback();
        }
    }

    @Override
    public void endInteractiveProcess() {
        for (MappingObjectInteractivity mapping : this.listOrderedMappings2Ask) {
            if (mapping.isAddedFlagActive()) {
                if (mapping.getDirMapping() == -2 || mapping.getDirMapping() == 0) {
                    this.mapping_manager.addSubMapping2Mappings2Review(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2());
                }
                if (mapping.getDirMapping() != -2 && mapping.getDirMapping() != -1) continue;
                this.mapping_manager.addSubMapping2Mappings2Review(mapping.getIdentifierOnto2(), mapping.getIdentifierOnto1());
                continue;
            }
            if (mapping.getDirMapping() == -2 || mapping.getDirMapping() == 0) {
                this.mapping_manager.addSubMapping2ConflictiveAnchors(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2());
            }
            if (mapping.getDirMapping() != -2 && mapping.getDirMapping() != -1) continue;
            this.mapping_manager.addSubMapping2ConflictiveAnchors(mapping.getIdentifierOnto2(), mapping.getIdentifierOnto1());
        }
    }

    @Override
    public void endInteractiveProcess(boolean filter) {
        this.endInteractiveProcess();
    }

    private void createOrderedMappings() {
        TreeSet<MappingObjectInteractivity> orderedSet = new TreeSet<MappingObjectInteractivity>(new MappingInteractivityComparator());
        for (MappingObjectInteractivity mapping : this.mapping_manager.getListOfMappingsToAskUser()) {
            orderedSet.add(mapping);
        }
        Iterator<MappingObjectInteractivity> it = orderedSet.iterator();
        while (it.hasNext()) {
            this.listOrderedMappings2Ask.add(it.next());
        }
        orderedSet.clear();
    }

    private void extractAmbiguities() {
        for (int i = 0; i < this.listOrderedMappings2Ask.size() - 1; ++i) {
            for (int j = i + 1; j < this.listOrderedMappings2Ask.size(); ++j) {
                if (!this.areMappingsAmbiguous(this.listOrderedMappings2Ask.get(i).getIdentifierOnto1(), this.listOrderedMappings2Ask.get(i).getIdentifierOnto2(), this.listOrderedMappings2Ask.get(j).getIdentifierOnto1(), this.listOrderedMappings2Ask.get(j).getIdentifierOnto2())) continue;
                this.listOrderedMappings2Ask.get(i).addAmbiguousMapping(j);
                this.listOrderedMappings2Ask.get(j).addAmbiguousMapping(i);
            }
        }
    }

    private void extractConflicts() {
        for (int i = 0; i < this.listOrderedMappings2Ask.size() - 1; ++i) {
            for (int j = i + 1; j < this.listOrderedMappings2Ask.size(); ++j) {
                if (!this.areMappingsInConflict(this.listOrderedMappings2Ask.get(i).getIdentifierOnto1(), this.listOrderedMappings2Ask.get(i).getIdentifierOnto2(), this.listOrderedMappings2Ask.get(j).getIdentifierOnto1(), this.listOrderedMappings2Ask.get(j).getIdentifierOnto2())) continue;
                this.listOrderedMappings2Ask.get(i).addConflictiveMapping(j);
                this.listOrderedMappings2Ask.get(j).addConflictiveMapping(i);
            }
        }
    }

    private void exploitImpactUserFeedback() {
        while (this.new2Add.size() > 0 || this.new2Del.size() > 0) {
            MappingObjectInteractivity mapping;
            if (this.new2Add.size() > 0) {
                mapping = this.new2Add.pop();
                for (int m_ide : mapping.getMappingsInconflict()) {
                    this.listOrderedMappings2Ask.get(m_ide).setRemovedFlag(true);
                    this.new2Del.push(this.listOrderedMappings2Ask.get(m_ide));
                }
                if (this.apply_heuristics) {
                    for (int m_ide : mapping.getAmbiguousMappings()) {
                        if (this.listOrderedMappings2Ask.get(m_ide).hasDecision()) continue;
                        this.listOrderedMappings2Ask.get(m_ide).setRemovedFlag(true);
                        this.new2Del.push(this.listOrderedMappings2Ask.get(m_ide));
                    }
                }
            }
            if (this.new2Del.size() <= 0) continue;
            mapping = this.new2Del.pop();
            if (!this.apply_heuristics) continue;
            for (int m_ide : mapping.getAmbiguousMappings()) {
                if (this.listOrderedMappings2Ask.get(m_ide).hasDecision()) continue;
                this.listOrderedMappings2Ask.get(m_ide).setAddedFlag(true);
                this.new2Add.push(this.listOrderedMappings2Ask.get(m_ide));
            }
        }
    }

    private boolean areMappingsAmbiguous(int ideA, int ideB, int ideAA, int ideBB) {
        return ideA == ideAA || ideB == ideBB;
    }

    private boolean areMappingsInConflict(int ideA, int ideB, int ideAA, int ideBB) {
        boolean AequivAA = false;
        boolean BequivBB = false;
        boolean AcontAA = false;
        boolean AAcontA = false;
        boolean BcontBB = false;
        boolean BBcontB = false;
        boolean AdisjAA = false;
        boolean BdisjBB = false;
        boolean conflict = false;
        AequivAA = this.index.areEquivalentClasses(ideA, ideAA);
        BequivBB = this.index.areEquivalentClasses(ideB, ideBB);
        AcontAA = AequivAA || this.index.isSubClassOf(ideA, ideAA);
        AAcontA = AequivAA || this.index.isSubClassOf(ideAA, ideA);
        BcontBB = BequivBB || this.index.isSubClassOf(ideB, ideBB);
        BBcontB = BequivBB || this.index.isSubClassOf(ideBB, ideB);
        AdisjAA = !AcontAA && !AAcontA && this.index.areDisjoint(ideA, ideAA);
        BdisjBB = !BcontBB && !BBcontB && this.index.areDisjoint(ideB, ideBB);
        conflict = (AcontAA || AAcontA) && BdisjBB || (BcontBB || BBcontB) && AdisjAA;
        return conflict;
    }

    private class MappingInteractivityComparator
    implements Comparator<MappingObjectInteractivity> {
        private MappingInteractivityComparator() {
        }

        @Override
        public int compare(MappingObjectInteractivity m1, MappingObjectInteractivity m2) {
            return this.orderByScopeAndLex(m1, m2);
        }

        public int orderByScopeAndLex(MappingObjectInteractivity m1, MappingObjectInteractivity m2) {
            if (m1.getScope() < m2.getScope()) {
                return 1;
            }
            if (m1.getScope() == m2.getScope()) {
                if (m1.getLexSim() < m2.getLexSim()) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }
    }

    private class NoComparator
    implements Comparator<MappingObjectInteractivity> {
        private NoComparator() {
        }

        @Override
        public int compare(MappingObjectInteractivity m1, MappingObjectInteractivity m2) {
            return -1;
        }
    }
}

