/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.interactive;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Stack;
import java.util.TreeSet;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.indexing.IndexManager;
import uk.ac.ox.krr.logmap2.interactive.InteractiveProcess;
import uk.ac.ox.krr.logmap2.interactive.objects.MappingObjectInteractivity;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.io.WriteFile;
import uk.ac.ox.krr.logmap2.mappings.MappingManager;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.repair.AnchorAssessment;
import uk.ac.ox.krr.logmap2.statistics.StatisticsManager;

public class InteractiveProcessAmbiguity
extends InteractiveProcess {
    private IndexManager index;
    private MappingManager mapping_manager;
    private AnchorAssessment mapping_assessment;
    private boolean useHeuristics;
    private int error_user;
    private boolean record_process;
    private Stack<MappingObjectInteractivity> new2Add;
    private Stack<MappingObjectInteractivity> new2Del;
    String interactivityFile;
    private Random generator;
    int good_marked = 0;
    int bad_marked = 0;

    public InteractiveProcessAmbiguity(IndexManager index, MappingManager mapping_manager, boolean useHeuristics, boolean orderQuestions, int error_user, boolean ask_everything, boolean record_process, String interactivityFile) {
        this.interactivityFile = interactivityFile;
        this.index = index;
        this.mapping_manager = mapping_manager;
        this.mapping_assessment = new AnchorAssessment(index, mapping_manager);
        this.useHeuristics = useHeuristics;
        this.error_user = error_user;
        this.record_process = record_process;
        this.generator = new Random(Calendar.getInstance().getTimeInMillis());
        this.new2Add = new Stack();
        this.new2Del = new Stack();
        this.orderedMappings2Ask = orderQuestions ? new TreeSet<MappingObjectInteractivity>(new MappingInteractivityComparator()) : new TreeSet<MappingObjectInteractivity>(new NoComparator());
        if (ask_everything) {
            Iterator<Object> iterator = mapping_manager.getLogMapMappings().keySet().iterator();
            while (iterator.hasNext()) {
                int ide1 = (Integer)iterator.next();
                for (int ide2 : mapping_manager.getLogMapMappings().get(ide1)) {
                    if (!mapping_manager.isId1SmallerThanId2(ide1, ide2)) continue;
                    mapping_manager.addMappingObject2AskUserList(ide1, ide2);
                }
            }
            mapping_manager.getLogMapMappings().clear();
        }
        for (MappingObjectInteractivity mapping : mapping_manager.getListOfMappingsToAskUser()) {
            int ambiguity = mapping_manager.getEntityAmbiguity_UserMappings(mapping.getIdentifierOnto1()) + mapping_manager.getEntityAmbiguity_UserMappings(mapping.getIdentifierOnto2());
            mapping.addSimilarityValue2List(ambiguity);
            this.orderedMappings2Ask.add(mapping);
        }
        if (record_process) {
            this.printOrdering();
        }
    }

    private void printOrdering() {
        WriteFile writer = new WriteFile("/usr/local/data/DataUMLS/InteractiveProcess/ambiguityOrdering.txt");
        Iterator it = this.orderedMappings2Ask.descendingIterator();
        int num = 0;
        while (it.hasNext()) {
            MappingObjectInteractivity mapping = (MappingObjectInteractivity)it.next();
            writer.writeLine(mapping + " -> " + this.getAmbiguityScore(mapping) + " " + this.getConfidence4Mapping(mapping) + " " + this.mapping_manager.isMappingInGoldStandard(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2()) + ", isub: " + this.mapping_manager.extractISUB4Mapping(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2()) + ", scope all: " + this.mapping_manager.extractScopeAll4Mapping(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2()) + ", scope anc: " + this.mapping_manager.extractScopeAnchors4Mapping(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2()) + ", Sim weak: " + this.mapping_manager.getSimWeak4Mapping2(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2()));
            ++num;
        }
        writer.closeBuffer();
        LogOutput.print("Num entries: " + num);
    }

    private double getConfidence4Mapping(MappingObjectInteractivity mapping) {
        return this.mapping_manager.getConfidence4Mapping(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2());
    }

    @Override
    public void startInteractiveProcess() {
        try {
            WriteFile writer = null;
            ArrayList<Integer> recordResultsPoints = new ArrayList<Integer>();
            recordResultsPoints.add(3000);
            int num_user_int = 0;
            int point = 0;
            int max_user_int = 4000;
            double time = 0.0;
            this.good_marked = 0;
            this.bad_marked = 0;
            if (this.record_process) {
                writer = new WriteFile(this.interactivityFile);
                writer.writeLine("User Actions\tGood\tBad\tStill to ask\tPrecision\tRecall\tFMeasure\tTime Uuser");
                writer.writeLine(num_user_int + "\t" + this.good_marked + "\t" + this.bad_marked + "\t" + this.orderedMappings2Ask.size() + "\t" + this.precision + "\t" + this.recall + "\t" + this.Fmeasure + "\t" + 0.0);
                recordResultsPoints.clear();
                recordResultsPoints.add(5);
                recordResultsPoints.add(10);
                recordResultsPoints.add(20);
                recordResultsPoints.add(30);
                recordResultsPoints.add(40);
                recordResultsPoints.add(50);
                recordResultsPoints.add(75);
                recordResultsPoints.add(100);
                recordResultsPoints.add(125);
                recordResultsPoints.add(150);
                recordResultsPoints.add(200);
                recordResultsPoints.add(250);
                recordResultsPoints.add(300);
                recordResultsPoints.add(350);
                recordResultsPoints.add(400);
                recordResultsPoints.add(450);
                recordResultsPoints.add(500);
                recordResultsPoints.add(600);
                recordResultsPoints.add(700);
                recordResultsPoints.add(800);
                recordResultsPoints.add(900);
                recordResultsPoints.add(1000);
                recordResultsPoints.add(1250);
                recordResultsPoints.add(1500);
                recordResultsPoints.add(1750);
                recordResultsPoints.add(2000);
                recordResultsPoints.add(2500);
                recordResultsPoints.add(3000);
            }
            this.cleanMappingsAndRecordPrecisionAndRecall();
            if (this.useHeuristics) {
                while (this.orderedMappings2Ask.size() > 0 && num_user_int < max_user_int) {
                    MappingObjectInteractivity selected_mapping = (MappingObjectInteractivity)this.orderedMappings2Ask.first();
                    ++num_user_int;
                    this.markMappingAndAdd2List(selected_mapping, this.isMappingGood(selected_mapping));
                    long init = Calendar.getInstance().getTimeInMillis();
                    this.evaluateImpactOfMapping();
                    long fin = Calendar.getInstance().getTimeInMillis();
                    time = ((double)fin - (double)init) / 1000.0;
                    this.reOrderMappings2ask();
                    if (num_user_int != (Integer)recordResultsPoints.get(point) || !this.record_process) continue;
                    LogOutput.print("ITERATION: " + num_user_int);
                    this.cleanMappingsAndRecordPrecisionAndRecall();
                    writer.writeLine(num_user_int + "\t" + this.good_marked + "\t" + this.bad_marked + "\t" + this.orderedMappings2Ask.size() + "\t" + this.precision + "\t" + this.recall + "\t" + this.Fmeasure + "\t" + time);
                    if (point < recordResultsPoints.size() - 1) {
                        ++point;
                        continue;
                    }
                    point = 0;
                }
                StatisticsManager.Mask_heur = num_user_int;
                LogOutput.print("ITERATION: " + num_user_int);
                if (this.record_process) {
                    this.cleanMappingsAndRecordPrecisionAndRecall();
                    writer.writeLine(num_user_int + "\t" + this.good_marked + "\t" + this.bad_marked + "\t" + this.orderedMappings2Ask.size() + "\t" + this.precision + "\t" + this.recall + "\t" + this.Fmeasure + "\t" + time);
                }
            } else {
                for (MappingObjectInteractivity mapping : this.mapping_manager.getListOfMappingsToAskUser()) {
                    if (this.isMappingGood(mapping)) {
                        if (this.isUserFailing()) {
                            mapping.setRemovedFlag(true);
                            continue;
                        }
                        mapping.setAddedFlag(true);
                        continue;
                    }
                    if (this.isUserFailing()) {
                        mapping.setAddedFlag(true);
                        continue;
                    }
                    mapping.setRemovedFlag(true);
                }
            }
            if (this.record_process) {
                writer.closeBuffer();
            }
        }
        catch (Exception e) {
            System.err.println("Error in interactive precess: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private boolean isUserFailing() {
        int random_num = this.generator.nextInt(100);
        return random_num < this.error_user;
    }

    private void markMappingAndAdd2List(MappingObjectInteractivity m, boolean toadd) {
        if (toadd) {
            m.setAddedFlag(true);
            this.new2Add.add(m);
            ++this.good_marked;
            this.mapping_manager.addMappingAddedByUser2Structure(m.getIdentifierOnto1(), m.getIdentifierOnto2());
            this.mapping_manager.addMappingAddedByUser2Structure(m.getIdentifierOnto2(), m.getIdentifierOnto1());
        } else {
            m.setRemovedFlag(true);
            this.new2Del.add(m);
            ++this.bad_marked;
        }
    }

    private void removeMappingsInConflictWithAddition(MappingObjectInteractivity added_mapping) {
        for (MappingObjectInteractivity mapping2check : this.mapping_manager.getListOfMappingsToAskUser()) {
            if (mapping2check.equals(added_mapping) || mapping2check.isRemovedFlagActive() || mapping2check.isAddedFlagActive()) continue;
            if (this.areMappingsAmbiguous(added_mapping.getIdentifierOnto1(), added_mapping.getIdentifierOnto2(), mapping2check.getIdentifierOnto1(), mapping2check.getIdentifierOnto2())) {
                mapping2check.setRemovedFlag(true);
                this.new2Del.push(mapping2check);
                continue;
            }
            if (!this.areMappingsInConflict(added_mapping.getIdentifierOnto1(), added_mapping.getIdentifierOnto2(), mapping2check.getIdentifierOnto1(), mapping2check.getIdentifierOnto2())) continue;
            mapping2check.setRemovedFlag(true);
            this.new2Del.push(mapping2check);
        }
    }

    private void addMappingsAmbiguousWithDeletion(MappingObjectInteractivity del_mapping) {
        for (MappingObjectInteractivity mapping2check : this.mapping_manager.getListOfMappingsToAskUser()) {
            if (mapping2check.equals(del_mapping) || mapping2check.isRemovedFlagActive() || mapping2check.isAddedFlagActive() || !this.hasScopeAll(mapping2check) || !this.hasGoodConfidence(mapping2check) || !this.areMappingsAmbiguous(del_mapping.getIdentifierOnto1(), del_mapping.getIdentifierOnto2(), mapping2check.getIdentifierOnto1(), mapping2check.getIdentifierOnto2())) continue;
            mapping2check.setAddedFlag(true);
            this.new2Add.push(mapping2check);
        }
    }

    private void evaluateImpactOfMapping() {
        while (this.new2Add.size() > 0 || this.new2Del.size() > 0) {
            MappingObjectInteractivity mapping;
            if (this.new2Add.size() > 0) {
                mapping = this.new2Add.pop();
                this.removeMappingsInConflictWithAddition(mapping);
            }
            if (this.new2Del.size() <= 0) continue;
            mapping = this.new2Del.pop();
            this.addMappingsAmbiguousWithDeletion(mapping);
        }
    }

    private void reOrderMappings2ask() {
        this.orderedMappings2Ask.clear();
        for (MappingObjectInteractivity mapping : this.mapping_manager.getListOfMappingsToAskUser()) {
            if (mapping.isRemovedFlagActive() || mapping.isAddedFlagActive()) continue;
            this.orderedMappings2Ask.add(mapping);
        }
    }

    @Override
    public void endInteractiveProcess() {
        this.endInteractiveProcess(false);
    }

    @Override
    public void endInteractiveProcess(boolean filter) {
        for (MappingObjectInteractivity mapping : this.mapping_manager.getListOfMappingsToAskUser()) {
            if (!filter || mapping.isAddedFlagActive() || this.hasScopeAll(mapping) && this.hasGoodConfidence(mapping) && !mapping.isRemovedFlagActive()) {
                if (mapping.getDirMapping() == -2 || mapping.getDirMapping() == 0) {
                    this.mapping_manager.addSubMapping2Mappings2Review(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2());
                }
                if (mapping.getDirMapping() != -2 && mapping.getDirMapping() != -1) continue;
                this.mapping_manager.addSubMapping2Mappings2Review(mapping.getIdentifierOnto2(), mapping.getIdentifierOnto1());
                continue;
            }
            this.mapping_manager.addEquivMapping2DiscardedAnchors(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2());
        }
        this.orderedMappings2Ask.clear();
        this.mapping_manager.setStringAnchors();
    }

    private void setStringMappings() {
        this.mapping_manager.setStringAnchors();
        for (int ide1 : this.mapping_manager.getMappings2Review().keySet()) {
            for (int ide2 : this.mapping_manager.getMappings2Review().get(ide1)) {
                this.mapping_manager.addStringAnchor(ide1, ide2);
            }
        }
    }

    private void getPrecisionAndRecall() {
        this.setStringMappings();
        HashSet<MappingObjectStr> intersection = new HashSet<MappingObjectStr>(this.mapping_manager.getStringLogMapMappings());
        intersection.retainAll(this.mapping_manager.getStringGoldStandardAnchors());
        this.precision = (double)intersection.size() / (double)this.mapping_manager.getStringLogMapMappings().size();
        this.recall = (double)intersection.size() / (double)this.mapping_manager.getStringGoldStandardAnchors().size();
        this.Fmeasure = 2.0 * this.recall * this.precision / (this.precision + this.recall);
        this.mapping_manager.setStringAnchors();
    }

    private void cleanMappingsAndRecordPrecisionAndRecall() throws Exception {
        for (MappingObjectInteractivity mapping : this.mapping_manager.getListOfMappingsToAskUser()) {
            if (!mapping.isAddedFlagActive() && (!this.hasScopeAll(mapping) || !this.hasGoodConfidence(mapping) || mapping.isRemovedFlagActive())) continue;
            this.mapping_manager.addSubMapping2Mappings2Review(mapping.getIdentifierOnto1(), mapping.getIdentifierOnto2());
            this.mapping_manager.addSubMapping2Mappings2Review(mapping.getIdentifierOnto2(), mapping.getIdentifierOnto1());
        }
        this.mapping_assessment.CheckSatisfiabilityOfIntegration_DandG(this.mapping_manager.getMappings2Review());
        this.getPrecisionAndRecall();
        this.mapping_manager.getMappings2Review().clear();
    }

    private boolean areMappingsAmbiguous(int ideA, int ideB, int ideAA, int ideBB) {
        return ideA == ideAA || ideB == ideBB;
    }

    private boolean areMappingsInConflict(int ideA, int ideB, int ideAA, int ideBB) {
        boolean AequivAA = false;
        boolean BequivBB = false;
        boolean AcontAA = false;
        boolean AAcontA = false;
        boolean BcontBB = false;
        boolean BBcontB = false;
        boolean AdisjAA = false;
        boolean BdisjBB = false;
        boolean conflict = false;
        AequivAA = this.index.areEquivalentClasses(ideA, ideAA);
        BequivBB = this.index.areEquivalentClasses(ideB, ideBB);
        AcontAA = AequivAA || this.index.isSubClassOf(ideA, ideAA);
        AAcontA = AequivAA || this.index.isSubClassOf(ideAA, ideA);
        BcontBB = BequivBB || this.index.isSubClassOf(ideB, ideBB);
        BBcontB = BequivBB || this.index.isSubClassOf(ideBB, ideB);
        AdisjAA = !AcontAA && !AAcontA && this.index.areDisjoint(ideA, ideAA);
        BdisjBB = !BcontBB && !BBcontB && this.index.areDisjoint(ideB, ideBB);
        conflict = (AcontAA || AAcontA) && BdisjBB || (BcontBB || BBcontB) && AdisjAA;
        return conflict;
    }

    private boolean isMappingGood(MappingObjectInteractivity m) {
        return this.mapping_manager.isMappingInGoldStandard(m.getIdentifierOnto1(), m.getIdentifierOnto2());
    }

    private double getAmbiguityScore(MappingObjectInteractivity m) {
        return m.getSimilarityList().get(0);
    }

    private void setAmbiguityScore(MappingObjectInteractivity m, double ambiguity) {
        m.getSimilarityList().set(0, ambiguity);
    }

    private boolean hasGoodConfidence(MappingObjectInteractivity m) {
        return this.mapping_manager.getConfidence4Mapping(m.getIdentifierOnto1(), m.getIdentifierOnto2()) > Parameters.good_confidence;
    }

    private boolean hasScopeAll(MappingObjectInteractivity m) {
        return this.mapping_manager.extractScopeAll4Mapping(m.getIdentifierOnto1(), m.getIdentifierOnto2()) > Parameters.bad_score_scope;
    }

    private boolean hasScopeAnchors(MappingObjectInteractivity m) {
        return this.mapping_manager.extractScopeAnchors4Mapping(m.getIdentifierOnto1(), m.getIdentifierOnto2()) > Parameters.bad_score_scope;
    }

    private double getScopeAll(MappingObjectInteractivity m) {
        return this.mapping_manager.extractScopeAll4Mapping(m.getIdentifierOnto1(), m.getIdentifierOnto2());
    }

    private double getScopeAnchors(MappingObjectInteractivity m) {
        return this.mapping_manager.extractScopeAnchors4Mapping(m.getIdentifierOnto1(), m.getIdentifierOnto2());
    }

    private void removeConflictiveMappingsWith(MappingObjectInteractivity added_mapping) {
        for (MappingObjectInteractivity mapping_conf : this.mapping_manager.getListOfMappingsToAskUser()) {
            if (mapping_conf.equals(added_mapping) || mapping_conf.isRemovedFlagActive() || !this.areMappingsInConflict(added_mapping.getIdentifierOnto1(), added_mapping.getIdentifierOnto2(), mapping_conf.getIdentifierOnto1(), mapping_conf.getIdentifierOnto2())) continue;
            if (mapping_conf.isAddedFlagActive()) {
                System.err.println("Conflict between added mappings. Shoudl be solved later");
                continue;
            }
            mapping_conf.setRemovedFlag(true);
            this.new2Del.push(mapping_conf);
        }
    }

    private class MappingInteractivityComparator
    implements Comparator<MappingObjectInteractivity> {
        private MappingInteractivityComparator() {
        }

        public int compare2(MappingObjectInteractivity m1, MappingObjectInteractivity m2) {
            if (InteractiveProcessAmbiguity.this.getScopeAnchors(m1) < InteractiveProcessAmbiguity.this.getScopeAnchors(m2)) {
                return -1;
            }
            if (InteractiveProcessAmbiguity.this.getScopeAnchors(m1) == InteractiveProcessAmbiguity.this.getScopeAnchors(m2)) {
                if (InteractiveProcessAmbiguity.this.getScopeAll(m1) < InteractiveProcessAmbiguity.this.getScopeAll(m2)) {
                    return -1;
                }
                if (InteractiveProcessAmbiguity.this.getScopeAll(m1) == InteractiveProcessAmbiguity.this.getScopeAll(m2)) {
                    if (InteractiveProcessAmbiguity.this.getConfidence4Mapping(m1) < InteractiveProcessAmbiguity.this.getConfidence4Mapping(m2)) {
                        return -1;
                    }
                    return 1;
                }
                return 1;
            }
            return 1;
        }

        public int orderbyConfidence(MappingObjectInteractivity m1, MappingObjectInteractivity m2) {
            if (InteractiveProcessAmbiguity.this.getConfidence4Mapping(m1) < InteractiveProcessAmbiguity.this.getConfidence4Mapping(m2)) {
                return -1;
            }
            return 1;
        }

        public int orderByScope(MappingObjectInteractivity m1, MappingObjectInteractivity m2) {
            if (InteractiveProcessAmbiguity.this.getScopeAll(m1) < InteractiveProcessAmbiguity.this.getScopeAll(m2)) {
                return -1;
            }
            return 1;
        }

        @Override
        public int compare(MappingObjectInteractivity m1, MappingObjectInteractivity m2) {
            if (InteractiveProcessAmbiguity.this.getScopeAnchors(m1) < InteractiveProcessAmbiguity.this.getScopeAnchors(m2)) {
                return -1;
            }
            if (InteractiveProcessAmbiguity.this.getScopeAnchors(m1) == InteractiveProcessAmbiguity.this.getScopeAnchors(m2)) {
                if (InteractiveProcessAmbiguity.this.hasScopeAll(m1) && InteractiveProcessAmbiguity.this.hasScopeAll(m2) || !InteractiveProcessAmbiguity.this.hasScopeAll(m1) && !InteractiveProcessAmbiguity.this.hasScopeAll(m2)) {
                    return this.orderbyConfidence(m1, m2);
                }
                return this.orderByScope(m1, m2);
            }
            return 1;
        }
    }

    private class NoComparator
    implements Comparator<MappingObjectInteractivity> {
        private NoComparator() {
        }

        @Override
        public int compare(MappingObjectInteractivity m1, MappingObjectInteractivity m2) {
            return -1;
        }
    }
}

