/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.indexing.labelling_schema;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.IntervalLabelledHierarchy;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.Node;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.PostIntervalLabelledHierarchy;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.PreIntervalLabelledHierarchy;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.TopologicalSorting;

public class Test {
    private IntervalLabelledHierarchy preHierarchy;
    private IntervalLabelledHierarchy postHierarchy;
    private int[] classes = new int[]{1, 2, 3, 4, 5, 6, 7, 8};

    public static void main(String[] args) {
        new Test().run();
    }

    public Test() {
        HashMap<Integer, Set<Integer>> map = new HashMap<Integer, Set<Integer>>();
        HashSet<Integer> bc = new HashSet<Integer>();
        bc.add(2);
        bc.add(3);
        HashSet<Integer> de = new HashSet<Integer>();
        de.add(4);
        de.add(5);
        HashSet<Integer> eg = new HashSet<Integer>();
        eg.add(5);
        eg.add(7);
        HashSet<Integer> f = new HashSet<Integer>();
        f.add(6);
        HashSet<Integer> h = new HashSet<Integer>();
        h.add(8);
        map.put(1, bc);
        map.put(2, de);
        map.put(3, eg);
        map.put(4, f);
        map.put(5, f);
        map.put(3, eg);
        map.put(7, h);
        this.preHierarchy = new PreIntervalLabelledHierarchy(map, false);
        this.postHierarchy = new PostIntervalLabelledHierarchy(map, false);
    }

    public void run() {
        this.testHierarchy(this.preHierarchy);
        this.checkPrePostConsistency(this.preHierarchy, this.postHierarchy);
    }

    public void printHierarchy(IntervalLabelledHierarchy hierarchy) {
        System.out.println();
        Node root = hierarchy.root;
        this.printHierarchyNode(root, 0, new HashSet<Node>());
    }

    private void testHierarchy(IntervalLabelledHierarchy hierarchy) {
        this.printHierarchy(hierarchy);
        System.out.println(new TopologicalSorting().sort(hierarchy.root));
        this.printTree(hierarchy);
        this.printChildrenAnswers(hierarchy);
        this.checkDescAncConsistency(hierarchy);
    }

    private void printHierarchyNode(Node node, int indent, Set<Node> visited) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        if (visited.contains(node)) {
            System.out.println("[" + node.getClassId() + "]");
        } else {
            visited.add(node);
            System.out.println(this.getNodeDescription(node));
            for (Node child : node.getChildren()) {
                this.printHierarchyNode(child, indent + 1, visited);
            }
        }
    }

    public void printTree(IntervalLabelledHierarchy hierarchy) {
        System.out.println();
        Node root = hierarchy.root;
        this.printTreeNode(root, 0, new HashSet<Node>());
    }

    private void printTreeNode(Node node, int indent, Set<Node> visited) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        if (visited.contains(node)) {
            System.out.println("(" + node.getClassId() + ")");
        } else {
            visited.add(node);
            System.out.println(this.getNodeDescription(node));
            for (Node child : node.getDescTreeChildren()) {
                this.printTreeNode(child, indent + 1, visited);
            }
        }
    }

    private String getNodeDescription(Node node) {
        return node.getClassId() + "(" + node.getDescOrder() + "|" + node.getAscOrder() + "): d=" + node.descIntervals + " a=" + node.ascIntervals;
    }

    private void printChildrenAnswers(IntervalLabelledHierarchy hierarchy) {
        System.out.println();
        for (int parentId : this.classes) {
            System.out.print(parentId + " : ");
            for (int childId : this.classes) {
                if (!hierarchy.hasDescendant(parentId, childId)) continue;
                System.out.print(childId + " ");
            }
            System.out.println();
        }
    }

    private void checkDescAncConsistency(IntervalLabelledHierarchy hierarchy) {
        System.out.println();
        int errors = 0;
        for (int idA : this.classes) {
            for (int idB : this.classes) {
                boolean isAnc;
                boolean isDesc = hierarchy.hasDescendant(idA, idB);
                if (isDesc == (isAnc = hierarchy.hasAncestor(idB, idA))) continue;
                System.out.println("Descendant/Ancestor inconsistency for classes " + idA + ", " + idB + ". hasDescendant = " + isDesc + ", hasAncestor = " + isAnc);
                ++errors;
            }
        }
        if (errors == 0) {
            System.out.println("Ancestor/Descendant consistency checked with no errors.");
        } else {
            System.out.println("Ancestor/Descendant consistency checked with " + errors + " errors.");
        }
    }

    private void checkPrePostConsistency(IntervalLabelledHierarchy preHierarc, IntervalLabelledHierarchy postHierarc) {
        System.out.println();
        int errors = 0;
        for (int idA : this.classes) {
            for (int idB : this.classes) {
                boolean isDescPre = preHierarc.hasDescendant(idA, idB);
                boolean isAncPre = preHierarc.hasAncestor(idB, idA);
                boolean isDescPost = postHierarc.hasDescendant(idA, idB);
                boolean isAncPost = postHierarc.hasAncestor(idB, idA);
                if (isDescPre != isDescPost) {
                    System.out.println("Pre/Postorder inconsistency for classes " + idA + ", " + idB + ". hasDescendant (pre) = " + isDescPre + ", hasDescendant (post) = " + isDescPost);
                    ++errors;
                }
                if (isAncPre == isAncPost) continue;
                System.out.println("Pre/Postorder inconsistency for classes " + idA + ", " + idB + ". hasAncestor (pre) = " + isAncPre + ", hasAncestor (post) = " + isAncPost);
                ++errors;
            }
        }
        if (errors == 0) {
            System.out.println("Pre/Post consistency checked with no errors.");
        } else {
            System.out.println("Pre/Post consistency checked with " + errors + " errors.");
        }
    }
}

