/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.indexing;

import com.google.common.collect.Multimap;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.search.Searcher;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.indexing.ExtractStringFromAnnotationAssertionAxiom;
import uk.ac.ox.krr.logmap2.indexing.IndexManager;
import uk.ac.ox.krr.logmap2.indexing.entities.ClassIndex;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.lexicon.LexicalUtilities;
import uk.ac.ox.krr.logmap2.lexicon.NormalizeDate;
import uk.ac.ox.krr.logmap2.lexicon.NormalizeNumbers;
import uk.ac.ox.krr.logmap2.multilingual.TranslatorManager;
import uk.ac.ox.krr.logmap2.oaei.OAEI2015InstanceProcessing;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;
import uk.ac.ox.krr.logmap2.reasoning.ELKAccess;
import uk.ac.ox.krr.logmap2.reasoning.HermiTAccess;
import uk.ac.ox.krr.logmap2.reasoning.StructuralReasonerExtended;
import uk.ac.ox.krr.logmap2.reasoning.profiles.CheckOWL2Profile;
import uk.ac.ox.krr.logmap2.utilities.Lib;
import uk.ac.ox.krr.logmap2.utilities.PrecomputeIndexCombination;
import uk.ac.ox.krr.logmap2.utilities.Utilities;

public class OntologyProcessing {
    long init;
    long fin;
    private OWLOntology onto;
    private IndexManager index;
    protected Map<Set<String>, Set<Integer>> invertedFileExact = new HashMap<Set<String>, Set<Integer>>();
    protected Map<Set<String>, Integer> invertedFileExactDataProp = new HashMap<Set<String>, Integer>();
    protected Map<Set<String>, Integer> invertedFileExactObjProp = new HashMap<Set<String>, Integer>();
    protected Map<Set<String>, Set<Integer>> invertedFileIndividuals = new HashMap<Set<String>, Set<Integer>>();
    protected Map<String, Set<Integer>> invertedFileWeakIndividuals = new HashMap<String, Set<Integer>>();
    protected Map<String, Set<Integer>> invertedFileRoleassertions = new HashMap<String, Set<Integer>>();
    protected Map<Set<String>, Set<Integer>> invertedFileWeakLabelsStemming = new HashMap<Set<String>, Set<Integer>>();
    protected Map<Set<String>, Set<Integer>> invertedFileWeakLabels = new HashMap<Set<String>, Set<Integer>>();
    protected Map<String, Integer> className2Identifier = new HashMap<String, Integer>();
    protected Map<String, Integer> dataPropName2Identifier = new HashMap<String, Integer>();
    protected Map<String, Integer> objectPropName2Identifier = new HashMap<String, Integer>();
    protected Map<String, Integer> individualName2Identifier = new HashMap<String, Integer>();
    private Map<OWLClass, Integer> class2identifier = new HashMap<OWLClass, Integer>();
    private Map<String, Integer> classIri2identifier = new HashMap<String, Integer>();
    private Map<OWLNamedIndividual, Integer> inidividual2identifier = new HashMap<OWLNamedIndividual, Integer>();
    private Map<Integer, OWLClass> identifier2class = new HashMap<Integer, OWLClass>();
    private Set<Integer> dangerousClasses = new HashSet<Integer>();
    private Set<String> alternative_labels_tmp = new HashSet<String>();
    private Map<Integer, Set<List<String>>> identifier2stemmedlabels = new HashMap<Integer, Set<List<String>>>();
    protected Set<Integer> MeaningfulRootIdentifiers = new HashSet<Integer>();
    protected Set<Integer> TaxRootIdentifiers = new HashSet<Integer>();
    private String rdf_label_uri = "http://www.w3.org/2000/01/rdf-schema#label";
    public static String deprecated_uri = "http://www.w3.org/2002/07/owl#deprecated";
    protected Set<OWLClass> obsolete_classes = new HashSet<OWLClass>();
    private String iri_onto = "http://krono.act.uji.es/ontology.owl";
    private int id_onto;
    int num_syn = 0;
    int toohigh_synset_cases = 0;
    private OWLReasoner reasoner;
    private int reasonerIdentifier;
    boolean use_all_labels_for_weak_mappings = false;
    private LexicalUtilities lexicalUtilities;
    private PrecomputeIndexCombination precomputeIndexCombination = new PrecomputeIndexCombination();
    private ExtractStringFromAnnotationAssertionAxiom annotationExtractor = new ExtractStringFromAnnotationAssertionAxiom();
    public ExtractAcceptedLabelsFromRoleAssertions roleAssertionLabelsExtractor = new ExtractAcceptedLabelsFromRoleAssertions();
    private ExtractCategoriesForIndividual categoryExtractor = new ExtractCategoriesForIndividual();
    private TranslatorManager translator = new TranslatorManager(Parameters.translator_id);
    Set<String> lexiconValues4individual = new HashSet<String>();
    private Set<String> labels_set = new HashSet<String>();
    Set<Integer> ausxSetOfClasses = new HashSet<Integer>();
    int minNumberOfRoots = 0;
    private Map<String, Set<Integer>> singleWordInvertedIndex = new HashMap<String, Set<Integer>>();
    private Map<Set<String>, Set<Integer>> filteredInvertedIndex = new HashMap<Set<String>, Set<Integer>>();

    public String getOntoIRI() {
        return this.iri_onto;
    }

    public OntologyProcessing(OWLOntology onto, IndexManager index, LexicalUtilities lexicalUtilities) {
        this.onto = onto;
        this.index = index;
        this.lexicalUtilities = lexicalUtilities;
        this.precomputeIndexCombination.preComputeIdentifierCombination();
        if (onto.getOntologyID().getOntologyIRI() != null) {
            this.iri_onto = onto.getOntologyID().getOntologyIRI().toString();
        }
        this.id_onto = this.index.addNewOntologyEntry(this.iri_onto);
    }

    public void clearOntologyRelatedInfo() {
        this.onto = null;
        this.class2identifier.clear();
        this.clearReasoner();
    }

    public Map<OWLClass, Integer> getClass2Identifier() {
        return this.class2identifier;
    }

    public int getIdentifier4ConceptIRI(String iri) {
        if (this.classIri2identifier.containsKey(iri)) {
            return this.classIri2identifier.get(iri);
        }
        return -1;
    }

    public void clearInvertedFilesExact() {
        this.invertedFileExact.clear();
    }

    public void clearInvertedFileStemming() {
        this.invertedFileWeakLabelsStemming.clear();
    }

    public void clearInvertedFileWeak() {
        this.invertedFileWeakLabels.clear();
    }

    public void clearInvertedFilesStemmingAndWeak() {
        this.invertedFileWeakLabels.clear();
        this.invertedFileWeakLabelsStemming.clear();
    }

    public void clearStemmedLabels() {
        this.identifier2stemmedlabels.clear();
    }

    public void clearInvertedFiles4properties() {
        this.invertedFileExactDataProp.clear();
        this.invertedFileExactObjProp.clear();
    }

    public void clearInvertedFiles4Individuals() {
        this.invertedFileIndividuals.clear();
        this.invertedFileWeakIndividuals.clear();
        this.invertedFileRoleassertions.clear();
    }

    private void clearTaxonomy() {
    }

    public void clearReasoner() {
        this.reasoner.dispose();
        this.reasoner = null;
    }

    public void precessLexicon() {
        this.precessLexicon(true);
    }

    public void precessLexicon(boolean extractLabels) {
        HashSet<Integer> redundant_ids;
        this.init = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("\nCLASSES: " + this.onto.getClassesInSignature(Imports.INCLUDED).size());
        if (this.onto.getClassesInSignature(Imports.INCLUDED).size() > 300) {
            Parameters.allow_multilingual = false;
        }
        String lang = "";
        if (Parameters.allow_multilingual && !(lang = this.identifyLanguageOfOntologyLabels()).equals("") && !lang.equals(Parameters.target_lang)) {
            try {
                this.translator.loadDictionary(lang);
            }
            catch (FileNotFoundException e) {
                LogOutput.printError("Dictionary file for '" + lang + "' not found.");
            }
        }
        for (OWLClass cls : this.onto.getClassesInSignature(Imports.INCLUDED)) {
            if (cls.isTopEntity() || cls.isBottomEntity()) continue;
            this.processLexiconClasses(cls, extractLabels);
        }
        if (Parameters.avoid_redundant_labels) {
            redundant_ids = new HashSet<Integer>();
            for (Set<String> entry : this.invertedFileExact.keySet()) {
                if (this.invertedFileExact.get(entry).size() <= Parameters.max_redundancy_labels) continue;
                for (int ident : this.invertedFileExact.get(entry)) {
                    if (this.index.getAlternativeLabels4ConceptIndex(ident).size() <= 1) continue;
                    redundant_ids.add(ident);
                }
                this.invertedFileExact.get(entry).removeAll(redundant_ids);
                redundant_ids.clear();
            }
        }
        this.processLexiconDataProperties(extractLabels);
        this.processLexiconObjectProperties(extractLabels);
        if (Parameters.perform_instance_matching) {
            this.processNamedIndividuals(extractLabels);
            if (Parameters.avoid_redundant_labels) {
                redundant_ids = new HashSet();
                for (Set<String> entry : this.invertedFileIndividuals.keySet()) {
                    if (this.invertedFileIndividuals.get(entry).size() <= Parameters.max_redundancy_labels) continue;
                    for (int ident : this.invertedFileIndividuals.get(entry)) {
                        if (this.index.getAlternativeLabels4IndividualIndex(ident).size() <= 1) continue;
                        redundant_ids.add(ident);
                    }
                    this.invertedFileIndividuals.get(entry).removeAll(redundant_ids);
                    redundant_ids.clear();
                }
            }
        }
        if (Parameters.allow_multilingual && !lang.equals("") && !lang.equals(Parameters.target_lang)) {
            this.translator.storeDictionary(lang);
        }
        LogOutput.print("Number of classes/labels: " + this.index.getSizeIndexClasses());
        LogOutput.print("\tNumber of labels + syn: " + this.num_syn);
        LogOutput.print("\tCases with huge combination of synonyms: " + this.toohigh_synset_cases);
        LogOutput.print("\tNumber of entries inverted file (exact): " + this.invertedFileExact.size());
        LogOutput.print("Number of dProp: " + this.index.getSizeDataProperties());
        LogOutput.print("\tNumber of dProp inverted file: " + this.invertedFileExactDataProp.size());
        LogOutput.print("Number of oProp: " + this.index.getSizeObjectProperties());
        LogOutput.print("\tNumber of oProp inverted file: " + this.invertedFileExactObjProp.size());
        LogOutput.print("Number of Indiv: " + this.index.getSizeIndexIndividuals());
        LogOutput.print("\tNumber of Indiv inverted file: " + this.invertedFileIndividuals.size());
        LogOutput.print("\tNumber of Indiv weak inverted file: " + this.invertedFileWeakIndividuals.size());
        LogOutput.print("\tNumber of Indiv Role assertions inverted file: " + this.invertedFileRoleassertions.size());
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Time setting labels and inverted files (s): " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
    }

    private String identifyLanguageOfOntologyLabels() {
        int num_tests = 0;
        String lang = "";
        for (OWLClass cls : this.onto.getClassesInSignature(Imports.INCLUDED)) {
            if (cls.isTopEntity() || cls.isBottomEntity()) continue;
            for (OWLAnnotationAssertionAxiom clsAnnAx : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)cls, (OWLOntology)this.onto)) {
                lang = this.annotationExtractor.getAnntotationLanguage(clsAnnAx);
                if (lang == null || lang.equals("")) continue;
                if (lang.equals("cn")) {
                    return "zh";
                }
                if (lang.equals("cz")) {
                    return "cs";
                }
                return lang;
            }
            if (++num_tests <= 100) continue;
            return lang;
        }
        return lang;
    }

    private Set<String> translateLabel(OWLAnnotationAssertionAxiom entityAnnAx, String label) {
        HashSet<String> translation_labels = new HashSet<String>();
        String lang = this.annotationExtractor.getAnntotationLanguage(entityAnnAx);
        if (!lang.equals(Parameters.target_lang) && !lang.equals("") && (label = this.translator.getTranslation(label, lang)).indexOf("|") >= 0) {
            String[] elements;
            for (String e : elements = label.split("\\|")) {
                translation_labels.add(e);
            }
            return translation_labels;
        }
        translation_labels.add(label);
        return translation_labels;
    }

    private void processLexiconClasses(OWLClass cls, boolean extractLabels) {
        if (this.isDeprecatedClass(cls)) {
            return;
        }
        String ns_ent = Utilities.getNameSpaceFromURI(cls.getIRI().toString());
        int ident = this.index.addNewClassEntry();
        this.index.setOntologyId4Class(ident, this.id_onto);
        String name = Utilities.getEntityLabelFromURI(cls.getIRI().toString());
        this.index.setClassName(ident, name);
        if (!ns_ent.equals("") && !ns_ent.equals(this.iri_onto)) {
            this.index.setClassNamespace(ident, ns_ent);
        }
        this.class2identifier.put(cls, ident);
        this.identifier2class.put(ident, cls);
        this.className2Identifier.put(name, ident);
        this.classIri2identifier.put(cls.getIRI().toString(), ident);
        if (extractLabels) {
            this.createEntryInLexicalInvertedFiles4ClassLabels(cls, ident);
        }
    }

    private void processLexiconDataProperties() {
        this.processLexiconDataProperties(true);
    }

    /*
     * WARNING - void declaration
     */
    private void processLexiconDataProperties(boolean extractLabels) {
        for (OWLDataProperty dProp : this.onto.getDataPropertiesInSignature(Imports.INCLUDED)) {
            List<String> cleanWords;
            String ns_ent = Utilities.getNameSpaceFromURI(dProp.getIRI().toString());
            int ident = this.index.addNewDataPropertyEntry();
            this.index.setOntologyId4DataProp(ident, this.id_onto);
            String name = Utilities.getEntityLabelFromURI(dProp.getIRI().toString());
            this.index.setDataPropName(ident, name);
            this.dataPropName2Identifier.put(name, ident);
            if (!ns_ent.equals("") && !ns_ent.equals(this.iri_onto)) {
                this.index.setDataPropNamespace(ident, ns_ent);
            }
            if ((cleanWords = this.processLabel(name)).size() > 0 && extractLabels) {
                this.invertedFileExactDataProp.put(new HashSet<String>(cleanWords), ident);
            }
            String label = "";
            for (String string : cleanWords) {
                label = label + string;
            }
            this.index.setDataPropLabel(ident, label);
            this.index.addAlternativeDataPropertyLabel(ident, label);
            cleanWords.clear();
            List<String> cleanWordsAlternative = this.createAlternativeLabel(name);
            if (cleanWordsAlternative.size() > 0) {
                label = "";
                for (String word3 : cleanWordsAlternative) {
                    label = label + word3;
                }
                this.index.addAlternativeDataPropertyLabel(ident, label);
            }
            cleanWordsAlternative.clear();
            for (OWLAnnotationAssertionAxiom dPropAnnAx : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)dProp, (OWLOntology)this.onto)) {
                LogOutput.print(name);
                for (String label_value : this.annotationExtractor.getAnntotationString(dPropAnnAx, this.onto, this.index.getFactory())) {
                    if (Parameters.allow_multilingual) {
                        this.alternative_labels_tmp.addAll(this.translateLabel(dPropAnnAx, label_value));
                        continue;
                    }
                    this.alternative_labels_tmp.add(label_value);
                }
                for (String label_value : this.alternative_labels_tmp) {
                    LogOutput.print("\t  " + label_value);
                    cleanWords = this.processLabel(label_value);
                    if (cleanWords.size() <= 0) continue;
                    label = "";
                    for (String word4 : cleanWords) {
                        if (label.length() == 0) {
                            label = word4;
                            continue;
                        }
                        label = label + "_" + word4;
                    }
                    this.index.addAlternativeDataPropertyLabel(ident, label);
                }
                this.alternative_labels_tmp.clear();
            }
            for (OWLClassExpression clsexp : EntitySearcher.getDomains((OWLDataProperty)dProp, (OWLOntology)this.onto)) {
                if (!clsexp.isAnonymous()) {
                    if (!this.class2identifier.containsKey(clsexp.asOWLClass())) continue;
                    this.index.addDomainClass4DataProperty(ident, this.class2identifier.get(clsexp.asOWLClass()));
                    continue;
                }
                if (clsexp.getClassExpressionType() != ClassExpressionType.OBJECT_UNION_OF) continue;
                for (OWLClassExpression clsexpunion : clsexp.asDisjunctSet()) {
                    if (clsexpunion.isAnonymous() || !this.class2identifier.containsKey(clsexpunion.asOWLClass())) continue;
                    this.index.addDomainClass4DataProperty(ident, this.class2identifier.get(clsexpunion.asOWLClass()));
                }
            }
            for (OWLDataRange type : EntitySearcher.getRanges((OWLDataProperty)dProp, (OWLOntology)this.onto)) {
                void var10_21;
                if (!type.isDatatype()) continue;
                try {
                    if (type.asOWLDatatype().isBuiltIn()) {
                        String string = type.asOWLDatatype().getBuiltInDatatype().getShortForm();
                    } else {
                        String string = Utilities.getEntityLabelFromURI(type.asOWLDatatype().getIRI().toString());
                    }
                }
                catch (Exception e) {
                    String string = Utilities.getEntityLabelFromURI(type.asOWLDatatype().getIRI().toString());
                }
                this.index.addRangeType4DataProperty(ident, (String)var10_21);
            }
            ++ident;
        }
    }

    private void processLexiconObjectProperties() {
        this.processLexiconObjectProperties(true);
    }

    private void processLexiconObjectProperties(boolean extractLabels) {
        for (OWLObjectProperty oProp : this.onto.getObjectPropertiesInSignature(Imports.INCLUDED)) {
            List<String> cleanWords;
            String ns_ent = Utilities.getNameSpaceFromURI(oProp.getIRI().toString());
            int ident = this.index.addNewObjectPropertyEntry();
            this.index.setOntologyId4ObjectProp(ident, this.id_onto);
            String name = Utilities.getEntityLabelFromURI(oProp.getIRI().toString());
            this.index.setObjectPropName(ident, name);
            this.objectPropName2Identifier.put(name, ident);
            if (!ns_ent.equals("") && !ns_ent.equals(this.iri_onto)) {
                this.index.setObjectPropNamespace(ident, ns_ent);
            }
            if ((cleanWords = this.processLabel(name)).size() > 0 && extractLabels) {
                this.invertedFileExactObjProp.put(new HashSet<String>(cleanWords), ident);
            }
            String label = "";
            for (String string : cleanWords) {
                label = label + string;
            }
            this.index.setObjectPropLabel(ident, label);
            this.index.addAlternativeObjectPropertyLabel(ident, label);
            cleanWords.clear();
            List<String> cleanWordsAlternative = this.createAlternativeLabel(name);
            if (cleanWordsAlternative.size() > 0) {
                label = "";
                for (String word3 : cleanWordsAlternative) {
                    label = label + word3;
                }
                this.index.addAlternativeObjectPropertyLabel(ident, label);
            }
            cleanWordsAlternative.clear();
            for (OWLAnnotationAssertionAxiom oPropAnnAx : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)oProp, (OWLOntology)this.onto)) {
                LogOutput.print(name);
                for (String label_value : this.annotationExtractor.getAnntotationString(oPropAnnAx, this.onto, this.index.getFactory())) {
                    if (Parameters.allow_multilingual) {
                        this.alternative_labels_tmp.addAll(this.translateLabel(oPropAnnAx, label_value));
                        continue;
                    }
                    this.alternative_labels_tmp.add(label_value);
                }
                for (String label_value : this.alternative_labels_tmp) {
                    LogOutput.print("\t  " + label_value);
                    cleanWords = this.processLabel(label_value);
                    if (cleanWords.size() <= 0) continue;
                    label = "";
                    for (String word : cleanWords) {
                        if (label.length() == 0) {
                            label = word;
                            continue;
                        }
                        label = label + "_" + word;
                    }
                    this.index.addAlternativeObjectPropertyLabel(ident, label);
                }
                this.alternative_labels_tmp.clear();
            }
            for (OWLObjectPropertyExpression propexp : EntitySearcher.getInverses((OWLObjectPropertyExpression)oProp, (OWLOntology)this.onto)) {
                if (propexp.isAnonymous()) continue;
                String string = Utilities.getEntityLabelFromURI(propexp.asOWLObjectProperty().getIRI().toString());
                List<String> cleanWordsInverse = this.processInverseLabel(string);
                if (cleanWordsInverse.size() > 0) {
                    label = "";
                    for (String word4 : cleanWordsInverse) {
                        label = label + word4;
                    }
                    this.index.addAlternativeObjectPropertyLabel(ident, label);
                }
                cleanWordsInverse.clear();
            }
            for (OWLClassExpression clsexp : EntitySearcher.getDomains((OWLObjectPropertyExpression)oProp, (OWLOntology)this.onto)) {
                if (!clsexp.isAnonymous()) {
                    if (!this.class2identifier.containsKey(clsexp.asOWLClass())) continue;
                    this.index.addDomainClass4ObjectProperty(ident, this.class2identifier.get(clsexp.asOWLClass()));
                    continue;
                }
                if (clsexp.getClassExpressionType() != ClassExpressionType.OBJECT_UNION_OF) continue;
                for (OWLClassExpression clsexpunion : clsexp.asDisjunctSet()) {
                    if (clsexpunion.isAnonymous() || !this.class2identifier.containsKey(clsexpunion.asOWLClass())) continue;
                    this.index.addDomainClass4ObjectProperty(ident, this.class2identifier.get(clsexpunion.asOWLClass()));
                }
            }
            for (OWLClassExpression clsexp : EntitySearcher.getRanges((OWLObjectPropertyExpression)oProp, (OWLOntology)this.onto)) {
                if (!clsexp.isAnonymous()) {
                    if (!this.class2identifier.containsKey(clsexp.asOWLClass())) continue;
                    this.index.addRangeClass4ObjectProperty(ident, this.class2identifier.get(clsexp.asOWLClass()));
                    continue;
                }
                if (clsexp.getClassExpressionType() != ClassExpressionType.OBJECT_UNION_OF) continue;
                for (OWLClassExpression clsexpunion : clsexp.asDisjunctSet()) {
                    if (clsexpunion.isAnonymous() || !this.class2identifier.containsKey(clsexpunion.asOWLClass())) continue;
                    this.index.addRangeClass4ObjectProperty(ident, this.class2identifier.get(clsexpunion.asOWLClass()));
                }
            }
            ++ident;
        }
    }

    private void processNamedIndividuals() {
        this.processNamedIndividuals(true);
    }

    private void processNamedIndividuals(boolean extractLabels) {
        HashSet<String> cleanWords = new HashSet<String>();
        HashSet<String> altLabels = new HashSet<String>();
        int num_dummy_indiv = 0;
        HashSet<OWLNamedIndividual> dummyIndividualsSet = new HashSet<OWLNamedIndividual>();
        for (OWLNamedIndividual indiv : this.onto.getIndividualsInSignature(Imports.INCLUDED)) {
            String ns_ent = Utilities.getNameSpaceFromURI(indiv.getIRI().toString());
            int ident = this.index.addNewIndividualEntry();
            this.index.setOntologyId4Individual(ident, this.id_onto);
            this.inidividual2identifier.put(indiv, ident);
            String name = Utilities.getEntityLabelFromURI(indiv.getIRI().toString());
            this.index.setIndividualName(ident, name);
            this.index.setIndividualLabel(ident, name);
            this.individualName2Identifier.put(name, ident);
            if (!ns_ent.equals("") && !ns_ent.equals(this.iri_onto)) {
                this.index.setIndividualNamespace(ident, ns_ent);
            }
            if (this.roleAssertionLabelsExtractor.isDummyIndividual(indiv)) {
                ++num_dummy_indiv;
                dummyIndividualsSet.add(indiv);
                continue;
            }
            altLabels.addAll(this.roleAssertionLabelsExtractor.extractLexiconFromRoleAssertions(indiv));
            altLabels.addAll(this.extractAnnotations4Infividual(indiv));
            this.categoryExtractor.extract(indiv, ident);
            String longestALabel = "";
            for (String string : altLabels) {
                if (this.isLabelAnIdentifier(string)) continue;
                if (string.length() > longestALabel.length()) {
                    longestALabel = string;
                }
                this.index.addAlternativeIndividualLabel(ident, string.toLowerCase());
                List<String> cleanWordsList = this.processLabel(string, true);
                this.changeOrderAltLabelWords(ident, cleanWordsList);
                cleanWords.addAll(cleanWordsList);
                for (String word : cleanWords) {
                    if (!extractLabels) continue;
                    if (!this.invertedFileWeakIndividuals.containsKey(word)) {
                        this.invertedFileWeakIndividuals.put(word, new HashSet());
                    }
                    this.invertedFileWeakIndividuals.get(word).add(ident);
                    String stemmedWord = this.lexicalUtilities.getStemming4Word(word);
                    if (stemmedWord.length() <= 2) continue;
                    if (!this.invertedFileWeakIndividuals.containsKey(stemmedWord)) {
                        this.invertedFileWeakIndividuals.put(stemmedWord, new HashSet());
                    }
                    this.invertedFileWeakIndividuals.get(stemmedWord).add(ident);
                }
                if (cleanWords.size() <= 0) continue;
                if (extractLabels) {
                    if (!this.invertedFileIndividuals.containsKey(cleanWords)) {
                        this.invertedFileIndividuals.put(new HashSet(cleanWords), new HashSet());
                    }
                    this.invertedFileIndividuals.get(cleanWords).add(ident);
                }
                cleanWords.clear();
                cleanWordsList.clear();
            }
            if (!longestALabel.equals("")) {
                this.index.setIndividualLabel(ident, longestALabel);
            }
            altLabels.clear();
        }
        if (extractLabels) {
            OAEI2015InstanceProcessing oaei2015extractor = new OAEI2015InstanceProcessing();
            for (OWLNamedIndividual indiv : this.onto.getIndividualsInSignature(Imports.INCLUDED)) {
                if (dummyIndividualsSet.contains(indiv)) continue;
                for (String str_label : this.roleAssertionLabelsExtractor.extractExtendedLexiconFromRoleAssertions(indiv)) {
                    if (!this.invertedFileRoleassertions.containsKey(str_label)) {
                        this.invertedFileRoleassertions.put(str_label, new HashSet());
                    }
                    this.invertedFileRoleassertions.get(str_label).add(this.inidividual2identifier.get(indiv));
                }
                Multimap multimap = EntitySearcher.getObjectPropertyValues((OWLIndividual)indiv, (OWLOntology)this.onto);
                for (OWLObjectPropertyExpression objprop : multimap.keySet()) {
                    for (OWLIndividual indiv_deep2 : multimap.get((Object)objprop)) {
                        if (indiv_deep2.isAnonymous()) continue;
                        this.index.addReferencedIndividual4Individual(this.inidividual2identifier.get(indiv), this.inidividual2identifier.get(indiv_deep2));
                    }
                }
                this.index.addCharactersitic4Individual(this.inidividual2identifier.get(indiv), oaei2015extractor.getPublicationCount(this.onto, indiv));
                this.index.addCharactersitic4Individual(this.inidividual2identifier.get(indiv), oaei2015extractor.getNumberOfCitations(this.onto, indiv));
                this.index.addCharactersitic4Individual(this.inidividual2identifier.get(indiv), oaei2015extractor.getActiveFromYear(this.onto, indiv));
            }
        }
        this.inidividual2identifier.clear();
        dummyIndividualsSet.clear();
        LogOutput.print("NUMBER OF DUMMY INDIVIDUALS: " + num_dummy_indiv);
        LogOutput.print("MAX SIZE ANNOTATIONS: " + this.roleAssertionLabelsExtractor.max_size_name_label);
        LogOutput.print("MIN SIZE ANNOTATIONS: " + this.roleAssertionLabelsExtractor.min_size_name_label);
    }

    private void changeOrderAltLabelWords(int ident, List<String> cleanWordsList) {
        String original = "";
        String changed = "";
        if (cleanWordsList.size() > 0) {
            int i;
            original = cleanWordsList.get(0);
            for (i = 1; i < cleanWordsList.size(); ++i) {
                original = original + " " + cleanWordsList.get(i);
            }
            changed = cleanWordsList.get(cleanWordsList.size() - 1);
            for (i = cleanWordsList.size() - 2; i > -1; --i) {
                changed = changed + " " + cleanWordsList.get(i);
            }
            this.index.addAlternativeIndividualLabel(ident, original);
            this.index.addAlternativeIndividualLabel(ident, changed);
        }
    }

    private Set<String> extractNameFromDataAssertion(OWLNamedIndividual indiv) {
        this.lexiconValues4individual.clear();
        for (String uri_indiv_ann : Parameters.accepted_data_assertion_URIs_for_individuals) {
            for (OWLLiteral assertion_value : Searcher.values((Collection)this.onto.getDataPropertyAssertionAxioms((OWLIndividual)indiv), (OWLDataPropertyExpression)this.index.getFactory().getOWLDataProperty(IRI.create((String)uri_indiv_ann)))) {
                String label_value = assertion_value.getLiteral().toLowerCase();
                if (label_value.length() <= 2) continue;
                this.lexiconValues4individual.add(label_value);
            }
        }
        return this.lexiconValues4individual;
    }

    private Set<String> extractAnnotations4Infividual(OWLNamedIndividual indiv) {
        this.lexiconValues4individual.clear();
        for (OWLAnnotationAssertionAxiom indivAnnAx : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)indiv, (OWLOntology)this.onto)) {
            for (String label_value : this.annotationExtractor.getAnntotationString(indivAnnAx, this.onto, this.index.getFactory())) {
                if (Parameters.allow_multilingual) {
                    this.alternative_labels_tmp.addAll(this.translateLabel(indivAnnAx, label_value));
                    continue;
                }
                this.alternative_labels_tmp.add(label_value);
            }
            for (String label_value : this.alternative_labels_tmp) {
                if (label_value.length() <= 2) continue;
                this.lexiconValues4individual.add(label_value);
            }
            this.alternative_labels_tmp.clear();
        }
        return this.lexiconValues4individual;
    }

    private List<String> processLabel(String label) {
        return this.processLabel(label, false);
    }

    private List<String> processLabel(String label, boolean filterStopwords) {
        ArrayList<String> cleanWords = new ArrayList<String>();
        String label_value = label.replace(",", "");
        label_value = label.replace("-", "");
        String[] words = label_value.indexOf("_") > 0 ? label_value.split("_") : (label_value.indexOf(" ") > 0 ? label_value.split(" ") : Utilities.splitStringByCapitalLetter(label_value));
        label_value = "";
        for (int i = 0; i < words.length; ++i) {
            words[i] = words[i].toLowerCase();
            if (words[i].length() <= 0 || filterStopwords && this.lexicalUtilities.getStopwordsSet().contains(words[i])) continue;
            cleanWords.add(words[i]);
        }
        return cleanWords;
    }

    private List<String> processInverseLabel(String label) {
        List<String> words = this.processLabel(label);
        int lastIndex = words.size() - 1;
        String firstWord = words.get(0).toLowerCase();
        String lastWord = words.get(lastIndex).toLowerCase();
        if (firstWord.equals("has")) {
            words.remove(0);
            words.add("of");
        } else if (lastWord.equals("of")) {
            words.remove(lastIndex);
            words.add(0, "has");
        } else if (lastWord.equals("by")) {
            words.remove(lastIndex);
            if (firstWord.equals("is")) {
                words.remove(0);
            }
        } else {
            words.clear();
        }
        return words;
    }

    private List<String> createAlternativeLabel(String label) {
        List<String> words = this.processLabel(label);
        int lastIndex = words.size() - 1;
        String firstWord = words.get(0).toLowerCase();
        String lastWord = words.get(lastIndex).toLowerCase();
        if (firstWord.equals("has")) {
            words.remove(0);
        } else if (lastWord.equals("by")) {
            words.remove(lastIndex);
            if (firstWord.equals("is")) {
                words.remove(0);
            }
            words.add(0, "has");
        } else {
            words.clear();
        }
        return words;
    }

    private void createEntryInLexicalInvertedFiles4ClassLabels(OWLClass cls, int ident) {
        String stemmedWord;
        Set<String> cleanWords = this.extractCleanLabel4OWLCls(cls, ident);
        HashSet<String> stemmed_words = new HashSet<String>();
        if (cleanWords.size() > 0) {
            if (!this.invertedFileExact.containsKey(cleanWords)) {
                this.invertedFileExact.put(new HashSet<String>(cleanWords), new HashSet());
            }
            this.invertedFileExact.get(cleanWords).add(ident);
        }
        for (String str : cleanWords) {
            stemmedWord = this.lexicalUtilities.getStemming4Word(str);
            if (stemmedWord.isEmpty()) continue;
            stemmed_words.add(stemmedWord);
        }
        if (!this.invertedFileWeakLabelsStemming.containsKey(stemmed_words)) {
            this.invertedFileWeakLabelsStemming.put(new HashSet(stemmed_words), new HashSet());
        }
        this.invertedFileWeakLabelsStemming.get(stemmed_words).add(ident);
        this.identifier2stemmedlabels.put(ident, new HashSet());
        this.identifier2stemmedlabels.get(ident).add(new ArrayList(stemmed_words));
        stemmed_words.clear();
        cleanWords.clear();
        for (String altlabel_value : this.extractAlternateLabels4OWLCls(cls, ident)) {
            String cleanAltLabel = "";
            String cleanReverseAltLabel = "";
            String stemmedAltLabel = "";
            if (altlabel_value.length() <= 2) continue;
            String[] words = altlabel_value.split("_");
            for (int i = 0; i < words.length; ++i) {
                if (this.lexicalUtilities.getStopwordsSet().contains(words[i]) || words[i].length() <= 0) continue;
                cleanWords.add(words[i]);
                if (cleanAltLabel.length() == 0) {
                    cleanAltLabel = words[i];
                    cleanReverseAltLabel = words[i];
                } else {
                    cleanAltLabel = cleanAltLabel + "_" + words[i];
                    cleanReverseAltLabel = words[i] + "_" + cleanReverseAltLabel;
                }
                stemmedWord = this.lexicalUtilities.getStemming4Word(words[i]);
                if (stemmedWord.isEmpty()) continue;
                stemmedAltLabel = stemmedAltLabel + "_" + stemmedWord;
                this.index.addWordOccurrence(stemmedWord, ident);
            }
            if (cleanWords.size() > 0) {
                if (!this.invertedFileExact.containsKey(cleanWords)) {
                    this.invertedFileExact.put(new HashSet<String>(cleanWords), new HashSet());
                }
                this.invertedFileExact.get(cleanWords).add(ident);
                this.index.addAlternativeClassLabel(ident, cleanAltLabel);
                if (Parameters.reverse_labels) {
                    this.index.addAlternativeClassLabel(ident, cleanReverseAltLabel);
                }
                if (!stemmedAltLabel.isEmpty()) {
                    stemmedAltLabel = stemmedAltLabel.substring(1);
                    this.index.addStemmedAltClassLabel(ident, stemmedAltLabel);
                }
            }
            for (String str : cleanWords) {
                stemmedWord = this.lexicalUtilities.getStemming4Word(str);
                if (stemmedWord.isEmpty()) continue;
                stemmed_words.add(stemmedWord);
            }
            if (!this.invertedFileWeakLabelsStemming.containsKey(stemmed_words)) {
                this.invertedFileWeakLabelsStemming.put(new HashSet(stemmed_words), new HashSet());
            }
            this.invertedFileWeakLabelsStemming.get(stemmed_words).add(ident);
            if (this.use_all_labels_for_weak_mappings) {
                this.identifier2stemmedlabels.get(ident).add(new ArrayList(stemmed_words));
            }
            stemmed_words.clear();
            cleanWords.clear();
        }
    }

    private boolean isDeprecatedClass(OWLClass cls) {
        for (OWLAnnotationAssertionAxiom annAx : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)cls, (OWLOntology)this.onto)) {
            String ann_label;
            if (!annAx.getAnnotation().getProperty().getIRI().toString().equals(deprecated_uri) || (ann_label = ((OWLLiteral)annAx.getAnnotation().getValue()).getLiteral().toLowerCase()) == null || !ann_label.equals("true")) continue;
            return true;
        }
        return false;
    }

    private boolean isLabelAnIdentifier(String label_value) {
        return label_value.matches(".+[0-9][0-9][0-9]+") || label_value.matches("[0-9][0-9][0-9][0-9][0-9]+-[0-9]+") || label_value.matches("[0-9]+(\\.[0-9]+)+") || label_value.matches(".+[0-9]+.+[0-9]+.+[0-9]+.+") || label_value.matches("[a-zA-Z][0-9]+");
    }

    private Set<String> extractCleanLabel4OWLCls(OWLClass cls, int ident) {
        String label_value = "";
        HashSet<String> cleanWords = new HashSet<String>();
        boolean ambiguity_ident = true;
        label_value = this.index.getIdentifier2ClassIndexMap().get(ident).getEntityName();
        if (this.isLabelAnIdentifier(label_value)) {
            for (OWLAnnotationAssertionAxiom annAx : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)cls, (OWLOntology)this.onto)) {
                if (!annAx.getAnnotation().getProperty().getIRI().toString().equals(this.rdf_label_uri)) continue;
                String ann_label = ((OWLLiteral)annAx.getAnnotation().getValue()).getLiteral();
                if (ann_label == null || ann_label.equals("") || ann_label.equals("null")) break;
                label_value = ann_label;
                break;
            }
        }
        if ((label_value = label_value.replace(",", "")).startsWith("_")) {
            label_value = label_value.substring(1, label_value.length());
        }
        if (label_value.endsWith("_")) {
            label_value = label_value.substring(0, label_value.length() - 1);
        }
        String[] words = label_value.indexOf("_") > 0 ? label_value.split("_") : (label_value.indexOf(" ") > 0 ? label_value.split(" ") : Utilities.splitStringByCapitalLetter(label_value));
        label_value = "";
        String entry4ifexact = "";
        for (int i = 0; i < words.length; ++i) {
            words[i] = words[i].toLowerCase();
            if (words[i].length() <= 0) continue;
            entry4ifexact = entry4ifexact + words[i];
            label_value = label_value + words[i] + "_";
            if (this.lexicalUtilities.getStopwordsSet().contains(words[i])) continue;
            cleanWords.add(words[i]);
        }
        if (label_value.length() > 0) {
            label_value = label_value.substring(0, label_value.length() - 1);
            this.index.setClassLabel(ident, label_value);
        } else {
            this.index.setClassLabel(ident, cls.getIRI().toString());
        }
        return cleanWords;
    }

    private void considerLabel(String label_value) {
        this.labels_set.addAll(this.extendAlternativeLabel(label_value));
        if (this.lexicalUtilities.hasSpellingVariants(label_value)) {
            for (String variant : this.lexicalUtilities.getSpellingVariants(label_value)) {
                this.labels_set.addAll(this.extendAlternativeLabel(variant));
            }
        }
    }

    private Set<String> extractAlternateLabels4OWLCls(OWLClass cls, int ident) {
        String label_value = "";
        Object namedIndiv = null;
        this.labels_set.clear();
        label_value = this.index.getIdentifier2ClassIndexMap().get(ident).getEntityName().toLowerCase();
        if (!this.isLabelAnIdentifier(label_value)) {
            this.considerLabel(label_value);
        }
        for (OWLAnnotationAssertionAxiom clsAnnAx : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)cls, (OWLOntology)this.onto)) {
            for (String l_value : this.annotationExtractor.getAnntotationString(clsAnnAx, this.onto, this.index.getFactory())) {
                if (Parameters.allow_multilingual) {
                    this.alternative_labels_tmp.addAll(this.translateLabel(clsAnnAx, l_value));
                    continue;
                }
                this.alternative_labels_tmp.add(l_value);
            }
            for (String l_value : this.alternative_labels_tmp) {
                if (l_value.length() <= 2) continue;
                this.considerLabel(l_value);
            }
            this.alternative_labels_tmp.clear();
        }
        this.num_syn += this.labels_set.size();
        return this.labels_set;
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> extendAlternativeLabel(String label_value) {
        HashSet<String> set_syn = new HashSet<String>();
        ArrayList<Set<String>> wordi2syn = new ArrayList<Set<String>>();
        int shift = 1;
        String[] words = (label_value = label_value.replaceAll("/", "_")).indexOf(" ") > 0 ? label_value.split(" ") : (label_value.indexOf("_") > 0 ? label_value.split("_") : Utilities.splitStringByCapitalLetter(label_value));
        shift = 1;
        for (int i = 0; i < words.length; ++i) {
            set_syn.add(words[i].replace(",", ""));
            if (this.lexicalUtilities.hasNormalization(words[i])) {
                set_syn.addAll(this.lexicalUtilities.getNormalization(words[i]));
            } else if (this.lexicalUtilities.isStemmingUp()) {
                set_syn.add(this.lexicalUtilities.getStemming4Word(words[i]));
            }
            String roman = this.lexicalUtilities.getRomanNormalization4Number(words[i]);
            if (!roman.equals("")) {
                set_syn.add(roman);
            }
            wordi2syn.add(new HashSet(set_syn));
            set_syn.clear();
        }
        long comb = 1L;
        for (Set set : wordi2syn) {
            comb *= (long)set.size();
        }
        if (comb > 50L || comb < 0L) {
            void var10_12;
            ++this.toohigh_synset_cases;
            String label = "";
            boolean bl = false;
            while (var10_12 < words.length - shift) {
                label = label + words[var10_12] + "_";
                ++var10_12;
            }
            label = label + words[words.length - shift];
            set_syn.add(label);
            return set_syn;
        }
        if (wordi2syn.size() == 1) {
            return (Set)wordi2syn.get(0);
        }
        return this.combineWordSynonyms(wordi2syn, (Set)wordi2syn.get(0), 1);
    }

    private Set<String> combineWordSynonyms(List<Set<String>> wordi2syn, Set<String> currentSet, int index) {
        HashSet<String> newSet = new HashSet<String>();
        for (String clabel : currentSet) {
            for (String syn : wordi2syn.get(index)) {
                newSet.add(clabel + "_" + syn);
            }
        }
        if (wordi2syn.size() <= index + 1) {
            return newSet;
        }
        return this.combineWordSynonyms(wordi2syn, newSet, index + 1);
    }

    public void addEntries2InvertedFileWeakLabels(Map<Set<String>, Set<Integer>> entries) {
        this.invertedFileWeakLabels.putAll(entries);
    }

    public void setInvertedFileWeakLabels() {
        int max_size_labels = 8;
        int max_size_list_words_missing = 3;
        for (int ident : this.identifier2stemmedlabels.keySet()) {
            for (List<String> list_words : this.identifier2stemmedlabels.get(ident)) {
                if (list_words.size() > max_size_labels || list_words.size() <= 1) continue;
                this.createWeakLabels4Identifier(list_words, ident, 1);
                if (list_words.size() <= 3 || max_size_list_words_missing <= 1) continue;
                this.createWeakLabels4Identifier(list_words, ident, 2);
                if (list_words.size() <= 5 || max_size_list_words_missing <= 2) continue;
                this.createWeakLabels4Identifier(list_words, ident, 3);
                if (list_words.size() <= 7 || max_size_list_words_missing <= 3) continue;
                this.createWeakLabels4Identifier(list_words, ident, 4);
            }
        }
    }

    public void setFullInvertedFileWeakLabels() {
        ArrayList<String> list_words = new ArrayList<String>();
        int max_size_labels = 8;
        int max_size_list_words_missing = 3;
        for (Set<String> stemmed_set : this.invertedFileWeakLabelsStemming.keySet()) {
            if (stemmed_set.size() > max_size_labels) continue;
            list_words.addAll(stemmed_set);
            Set<Integer> identifiers = this.invertedFileWeakLabelsStemming.get(stemmed_set);
            if (list_words.size() > 1) {
                this.createWeakLabels4Identifier(list_words, identifiers, 1);
                if (list_words.size() > 3 && max_size_list_words_missing > 1) {
                    this.createWeakLabels4Identifier(list_words, identifiers, 2);
                    if (list_words.size() > 5 && max_size_list_words_missing > 2) {
                        this.createWeakLabels4Identifier(list_words, identifiers, 3);
                        if (list_words.size() > 7 && max_size_list_words_missing > 3) {
                            this.createWeakLabels4Identifier(list_words, identifiers, 4);
                        }
                    }
                }
            }
            list_words.clear();
        }
    }

    private void createWeakLabels4Identifier(List<String> cleanWords, int ident, int missing_words) {
        HashSet<String> combo = new HashSet<String>();
        Set<Set<Integer>> combination_set = this.precomputeIndexCombination.getIdentifierCombination(cleanWords.size(), missing_words);
        for (Set<Integer> toExclude : combination_set) {
            for (int pos = 0; pos < cleanWords.size(); ++pos) {
                if (toExclude.contains(pos)) continue;
                combo.add(cleanWords.get(pos));
            }
            if (!this.invertedFileWeakLabels.containsKey(combo)) {
                this.invertedFileWeakLabels.put(new HashSet(combo), new HashSet());
            }
            this.invertedFileWeakLabels.get(combo).add(ident);
            combo.clear();
        }
    }

    private void createWeakLabels4Identifier(List<String> cleanWords, Set<Integer> identifiers, int missing_words) {
        HashSet<String> combo = new HashSet<String>();
        Set<Set<Integer>> combination_set = this.precomputeIndexCombination.getIdentifierCombination(cleanWords.size(), missing_words);
        for (Set<Integer> toExclude : combination_set) {
            for (int pos = 0; pos < cleanWords.size(); ++pos) {
                if (toExclude.contains(pos)) continue;
                combo.add(cleanWords.get(pos));
            }
            if (!this.invertedFileWeakLabels.containsKey(combo)) {
                this.invertedFileWeakLabels.put(new HashSet(combo), new HashSet());
            }
            this.invertedFileWeakLabels.get(combo).addAll(identifiers);
            combo.clear();
        }
    }

    public int getIdentifier4ConceptName(String name) {
        if (this.className2Identifier.containsKey(name)) {
            return this.className2Identifier.get(name);
        }
        return -1;
    }

    public int getIdentifier4ObjectPropName(String name) {
        if (this.objectPropName2Identifier.containsKey(name)) {
            return this.objectPropName2Identifier.get(name);
        }
        return -1;
    }

    public int getIdentifier4DataPropName(String name) {
        if (this.dataPropName2Identifier.containsKey(name)) {
            return this.dataPropName2Identifier.get(name);
        }
        return -1;
    }

    public int getIdentifier4InstanceName(String name) {
        if (this.individualName2Identifier.containsKey(name)) {
            return this.individualName2Identifier.get(name);
        }
        return -1;
    }

    public Map<Set<String>, Set<Integer>> getInvertedFileExactMatching() {
        return this.invertedFileExact;
    }

    public Map<Set<String>, Integer> getInvertedFileExactMatching4DataProp() {
        return this.invertedFileExactDataProp;
    }

    public Map<Set<String>, Integer> getInvertedFileExactMatching4ObjProp() {
        return this.invertedFileExactObjProp;
    }

    public Map<Set<String>, Set<Integer>> getInvertedFileMatching4Individuals() {
        return this.invertedFileIndividuals;
    }

    public Map<String, Set<Integer>> getInvertedFileRoleAssertions() {
        return this.invertedFileRoleassertions;
    }

    public Map<String, Set<Integer>> getInvertedFileWeakMatching4Individuals() {
        return this.invertedFileWeakIndividuals;
    }

    public Map<Set<String>, Set<Integer>> getInvertedFileWeakLabelsStemming() {
        return this.invertedFileWeakLabelsStemming;
    }

    public Map<Set<String>, Set<Integer>> getInvertedFileWeakLabels() {
        return this.invertedFileWeakLabels;
    }

    public void setTaxonomicData() {
        if (Parameters.reasoner.equals(Parameters.hermit)) {
            this.setUpReasoner_HermiT();
        } else if (Parameters.reasoner.equals(Parameters.elk)) {
            this.setUpReasoner_ELK();
        } else {
            this.setUpStructuralReasoner();
        }
        this.extractDangerousClasses();
        this.extractStringTaxonomiesAndDisjointness();
        this.init = Calendar.getInstance().getTimeInMillis();
        this.extractGeneralHornAxioms();
        this.fin = Calendar.getInstance().getTimeInMillis();
        LogOutput.print("Extracting General Axioms: " + (double)((float)((double)this.fin - (double)this.init)) / 1000.0);
        if (Parameters.perform_instance_matching) {
            this.extractInferredTypes4Individuals();
        }
    }

    private void setUpStructuralReasoner() {
        try {
            this.reasoner = this.getIncompleteReasoner();
        }
        catch (Exception e) {
            LogOutput.printError("Error setting up Structural reasoner: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void setUpReasoner_HermiT() {
        try {
            if (Parameters.reason_datatypes || this.onto.getDatatypesInSignature(Imports.INCLUDED).size() == 0) {
                HermiTAccess hermitAccess = new HermiTAccess(SynchronizedOWLManager.createOWLOntologyManager(), this.onto, false);
                hermitAccess.classifyOntology_withTimeout_throws_Exception(Parameters.timeout);
                if (hermitAccess.isOntologyClassified()) {
                    this.reasoner = hermitAccess.getReasoner();
                } else {
                    LogOutput.print("Onto not classified with HermT. Using 'ELK' reasoner instead.");
                    this.setUpReasoner_ELK();
                }
            } else {
                LogOutput.print("Ontology with datatypes. Using 'ELK' reasoner instead.");
                this.setUpReasoner_ELK();
            }
            if (this.reasoner == null) {
                LogOutput.print("Reasoner was null. Using 'ELK' reasoner instead.");
                this.setUpReasoner_ELK();
            }
        }
        catch (Exception e) {
            try {
                LogOutput.print("Error/timeout setting up HermiT reasoner. Using 'ELK' reasoner instead.");
                this.setUpReasoner_ELK();
            }
            catch (Exception e2) {
                LogOutput.printError("Error setting up ELK reasoner: " + e2.getMessage() + ". Using structural reasoner instead.");
                this.setUpStructuralReasoner();
            }
        }
    }

    private void setUpReasoner_ELK() {
        CheckOWL2Profile profileChecker = new CheckOWL2Profile();
        if (!profileChecker.isInOWL2ELProfile(this.onto)) {
            LogOutput.printAlways(this.onto.getOntologyID().getOntologyIRI() + " NOT in OWL 2 EL profile. Using structural reasoner.");
            this.setUpStructuralReasoner();
            return;
        }
        LogOutput.printAlways(this.onto.getOntologyID().getOntologyIRI() + " in OWL 2 EL profile. Using ELK reasoner.");
        try {
            ELKAccess elkAccess = new ELKAccess(SynchronizedOWLManager.createOWLOntologyManager(), this.onto, false);
            elkAccess.classifyOntologyNoProperties();
            if (elkAccess.isOntologyClassified()) {
                this.reasoner = elkAccess.getReasoner();
            } else {
                LogOutput.print("Onto not classified with ELK. Using 'structural' reasoner instead.");
                this.reasoner = this.getIncompleteReasoner();
            }
            if (this.reasoner == null) {
                LogOutput.print("Reasoner was null. Using 'structural' reasoner instead.");
                this.reasoner = this.getIncompleteReasoner();
            }
        }
        catch (Exception e) {
            try {
                LogOutput.print("Error/timeout setting up ELK reasoner. Using 'structural' reasoner instead.");
                this.reasoner = this.getIncompleteReasoner();
            }
            catch (Exception e2) {
                LogOutput.printError("Error setting up Structural reasoner: " + e2.getMessage());
            }
        }
    }

    private OWLReasoner getIncompleteReasoner() throws Exception {
        return new StructuralReasonerExtended(this.onto);
    }

    private void extractDangerousClasses() {
        for (OWLClass cls : this.reasoner.getTopClassNode().getEntitiesMinusTop()) {
            System.out.println(cls.toString());
            this.dangerousClasses.add(this.class2identifier.get(cls));
            this.index.addDangerousClasses(this.class2identifier.get(cls));
        }
        Iterator<Object> iterator = this.dangerousClasses.iterator();
        while (iterator.hasNext()) {
            int ide = (Integer)iterator.next();
            LogOutput.print("DANGEROUS CLASS == TOP: " + this.index.getName4ConceptIndex(ide));
        }
    }

    public Set<Integer> getDangerousClasses() {
        return this.dangerousClasses;
    }

    private void extractStringTaxonomiesAndDisjointness() {
        int identRepresentative;
        OWLClass clsRepresentative;
        int bignode = 0;
        int equiv = 0;
        int disj = 0;
        HashMap<Node, Integer> node2identifier = new HashMap<Node, Integer>();
        NodeSet topClasses = this.reasoner.getSubClasses((OWLClassExpression)this.reasoner.getTopClassNode().getRepresentativeElement(), true);
        for (OWLClass cls : topClasses.getFlattened()) {
            if (!this.class2identifier.containsKey(cls)) continue;
            this.index.addRoot2Structure(this.class2identifier.get(cls));
        }
        NodeSet nodeSet = this.reasoner.getSubClasses((OWLClassExpression)this.reasoner.getTopClassNode().getRepresentativeElement(), false);
        for (Node node : nodeSet) {
            if (node.isBottomNode() || node.isTopNode() || !this.class2identifier.containsKey(clsRepresentative = (OWLClass)node.getRepresentativeElement())) continue;
            identRepresentative = this.class2identifier.get(clsRepresentative);
            node2identifier.put(node, identRepresentative);
            if (node.getEntities().size() <= 1) continue;
            ++bignode;
            this.index.addRepresentativeNode(identRepresentative);
        }
        for (Node node : nodeSet) {
            int ident1;
            if (node.isBottomNode() || node.isTopNode() || !node2identifier.containsKey(node)) continue;
            identRepresentative = (Integer)node2identifier.get(node);
            clsRepresentative = (OWLClass)node.getRepresentativeElement();
            if (!this.reasoner.getSubClasses((OWLClassExpression)clsRepresentative, true).isEmpty()) {
                this.index.getClassIndex(identRepresentative).setEmptyDirectSubClasses();
                for (Node nodeSub : this.reasoner.getSubClasses((OWLClassExpression)clsRepresentative, true).getNodes()) {
                    if (nodeSub.isBottomNode() || nodeSub.isTopNode() || !node2identifier.containsKey(nodeSub)) continue;
                    this.index.getClassIndex(identRepresentative).addDirectSubClass((Integer)node2identifier.get(nodeSub));
                }
            }
            if (!this.reasoner.getSuperClasses((OWLClassExpression)clsRepresentative, true).isEmpty()) {
                this.index.getClassIndex(identRepresentative).setEmptyDirectSuperClasses();
                for (Node nodeSup : this.reasoner.getSuperClasses((OWLClassExpression)clsRepresentative, true).getNodes()) {
                    if (nodeSup.isTopNode() || nodeSup.isBottomNode() || !node2identifier.containsKey(nodeSup)) continue;
                    this.index.getClassIndex(identRepresentative).addDirectSuperClass((Integer)node2identifier.get(nodeSup));
                }
            }
            for (OWLClass nodeClass : node.getEntities()) {
                if (nodeClass.isTopEntity() || nodeClass.isBottomEntity() || this.reasoner.getDisjointClasses((OWLClassExpression)nodeClass).isEmpty()) continue;
                ident1 = this.class2identifier.get(nodeClass);
                this.index.getClassIndex(ident1).setEmptyDisjointClasses();
                ++disj;
                for (Node nodeDisj : this.reasoner.getDisjointClasses((OWLClassExpression)nodeClass).getNodes()) {
                    for (OWLClass disjcls : nodeDisj.getEntities()) {
                        if (disjcls.isTopEntity() || disjcls.isBottomEntity() || !this.class2identifier.containsKey(disjcls) || ident1 == this.class2identifier.get(disjcls)) continue;
                        this.index.getClassIndex(ident1).addDisjointClass(this.class2identifier.get(disjcls));
                        this.index.getClassIndex(this.class2identifier.get(disjcls)).addDisjointClass(ident1);
                    }
                }
            }
            if (node.getEntities().size() <= 1) continue;
            OWLClass[] nodeClasses = new OWLClass[node.getEntities().size()];
            nodeClasses = node.getEntities().toArray(nodeClasses);
            for (int i = 0; i < nodeClasses.length; ++i) {
                ident1 = this.class2identifier.get(nodeClasses[i]);
                this.index.getClassIndex(ident1).setEmptyEquivalentClasses();
                ++equiv;
                for (int j = 0; j < nodeClasses.length; ++j) {
                    if (i == j) continue;
                    int ident2 = this.class2identifier.get(nodeClasses[j]);
                    this.index.getClassIndex(ident1).addEquivalentClass(ident2);
                    if (!this.index.getClassIndex(ident1).hasDirectDisjointClasses()) continue;
                    if (!this.index.getClassIndex(ident2).hasDirectDisjointClasses()) {
                        this.index.getClassIndex(ident2).setEmptyDisjointClasses();
                    }
                    this.index.getClassIndex(ident2).addAllDisjointClasses(this.index.getClassIndex(ident1).getDisjointClasses());
                }
            }
        }
        node2identifier.clear();
        LogOutput.print("Representatives (aggregated): " + this.index.getRepresentativeNodes().size());
        LogOutput.print("Disjoint: " + disj);
        LogOutput.print("Equivalences: " + equiv);
        LogOutput.print("Big nodes: " + bignode);
    }

    private void extractGeneralHornAxioms() {
        for (OWLClass cls : this.class2identifier.keySet()) {
            int idecls = this.class2identifier.get(cls);
            for (OWLEquivalentClassesAxiom ax : this.onto.getEquivalentClassesAxioms(cls)) {
                for (OWLClassExpression exp_equiv : ax.getClassExpressions()) {
                    this.addOWLClassExpresion2GeneralHornAxiom(idecls, exp_equiv);
                }
            }
            for (OWLEquivalentClassesAxiom ax : this.onto.getSubClassAxiomsForSuperClass(cls)) {
                this.addOWLClassExpresion2GeneralHornAxiom(idecls, ax.getSubClass());
            }
        }
        LogOutput.print("->General HORN Axioms: " + this.index.getGeneralHornAxiom().size());
    }

    private void extractInferredTypes4Individuals() {
        for (int identIndiv : this.index.getIndividuaIdentifierSet()) {
            for (Node node_cls : this.reasoner.getTypes(this.index.getOWLNamedIndividual4IndividualIndex(identIndiv), true)) {
                for (OWLClass cls : node_cls.getEntitiesMinusTop()) {
                    this.index.addType4Individual(identIndiv, this.class2identifier.get(cls));
                }
            }
        }
    }

    private void addOWLClassExpresion2GeneralHornAxiom(int idecls, OWLClassExpression exp) {
        this.ausxSetOfClasses.clear();
        if (exp instanceof OWLObjectIntersectionOf) {
            for (OWLClassExpression exp_intersect : ((OWLObjectIntersectionOf)exp).getOperands()) {
                if (!exp_intersect.isAnonymous()) {
                    this.ausxSetOfClasses.add(this.class2identifier.get(exp_intersect.asOWLClass()));
                    continue;
                }
                this.ausxSetOfClasses.clear();
                return;
            }
        } else {
            return;
        }
        if (this.ausxSetOfClasses.size() > 1) {
            this.index.addGeneralHornAxiom2Structure(this.ausxSetOfClasses, idecls);
        }
    }

    private void extractMeaningfulRoots() {
        NodeSet topClasses = this.reasoner.getSubClasses((OWLClassExpression)this.reasoner.getTopClassNode().getRepresentativeElement(), true);
        this.TaxRootIdentifiers.clear();
        for (Node node : topClasses.getNodes()) {
            if (!this.class2identifier.containsKey(node.getRepresentativeElement())) continue;
            this.TaxRootIdentifiers.add(this.class2identifier.get(node.getRepresentativeElement()));
        }
        this.minNumberOfRoots = this.onto.getClassesInSignature(Imports.INCLUDED).size() < 500 ? 4 : 8;
        if (topClasses.getNodes().size() < this.minNumberOfRoots) {
            this.MeaningfulRootIdentifiers.addAll(this.extractMeaningfulRoots((NodeSet<OWLClass>)topClasses, 1));
            if (this.MeaningfulRootIdentifiers.size() > topClasses.getNodes().size()) {
                return;
            }
        }
        this.MeaningfulRootIdentifiers.clear();
        for (Node node : topClasses.getNodes()) {
            if (!this.class2identifier.containsKey(node.getRepresentativeElement())) continue;
            this.MeaningfulRootIdentifiers.add(this.class2identifier.get(node.getRepresentativeElement()));
        }
    }

    private Set<Integer> extractMeaningfulRoots(NodeSet<OWLClass> nodes, int level) {
        HashSet<Integer> mroots = new HashSet<Integer>();
        OWLClassNodeSet mrootsClass = new OWLClassNodeSet();
        for (Node node : nodes.getNodes()) {
            for (Node topNode : this.reasoner.getSubClasses((OWLClassExpression)node.getRepresentativeElement(), true)) {
                mrootsClass.addNode(topNode);
                if (!this.class2identifier.containsKey(topNode.getRepresentativeElement())) continue;
                mroots.add(this.class2identifier.get(topNode.getRepresentativeElement()));
            }
        }
        if (mroots.size() >= this.minNumberOfRoots || level == 3) {
            return mroots;
        }
        return this.extractMeaningfulRoots((NodeSet<OWLClass>)mrootsClass, level + 1);
    }

    private void extractHierarchyLevel(NodeSet<OWLClass> classes, int level) {
        for (Node node : classes.getNodes()) {
            int ident;
            if (this.class2identifier.containsKey(node.getRepresentativeElement()) && this.index.getClassIndex(ident = this.class2identifier.get(node.getRepresentativeElement()).intValue()).getHierarchyLevel() < level) {
                this.index.getClassIndex(ident).setHierarchyLevel(level);
            }
            this.extractHierarchyLevel((NodeSet<OWLClass>)this.reasoner.getSubClasses((OWLClassExpression)node.getRepresentativeElement(), true), level + 1);
        }
    }

    public Set<Integer> getMeaningfulRoots() {
        return this.MeaningfulRootIdentifiers;
    }

    public Set<Integer> getRaelRoots() {
        return this.TaxRootIdentifiers;
    }

    public void clearFrequencyRelatedStructures() {
        this.singleWordInvertedIndex.clear();
        this.filteredInvertedIndex.clear();
    }

    public Integer getFrequency(String word) {
        if (this.singleWordInvertedIndex.containsKey(word)) {
            return this.singleWordInvertedIndex.get(word).size();
        }
        return 0;
    }

    public Map<Set<String>, Set<Integer>> getFilteredInvertedIndex() {
        return this.filteredInvertedIndex;
    }

    public void clearFilteredInvertedIndex() {
        this.filteredInvertedIndex.clear();
    }

    public void buildFilteredInvertedIndex(Set<String> stopWords) {
        for (Integer id : this.className2Identifier.values()) {
            ClassIndex cls = this.index.getClassIndex(id);
            Set<String> labels = cls.getStemmedAltLabels();
            if (labels == null) {
                Lib.debuginfo("A class named " + cls.getEntityName() + " has no labels!");
                continue;
            }
            for (String lab : labels) {
                String[] words;
                HashSet<String> key = new HashSet<String>();
                for (String word : words = lab.split("_")) {
                    if (stopWords.contains(word)) continue;
                    key.add(word);
                }
                if (!this.filteredInvertedIndex.containsKey(key)) {
                    this.filteredInvertedIndex.put(key, new HashSet());
                }
                this.filteredInvertedIndex.get(key).add(id);
            }
        }
    }

    public Set<String> getSuperClass(int id, int TOTAL) {
        HashSet<String> ret = new HashSet<String>();
        HashSet<Integer> visited = new HashSet<Integer>();
        LinkedList<ClassIndex> q = new LinkedList<ClassIndex>();
        q.add(this.index.getClassIndex(id));
        visited.add(id);
        while (!q.isEmpty() && ret.size() < TOTAL) {
            Set<Integer> superclasses = ((ClassIndex)q.remove()).getDirectSuperclasses();
            for (int i : superclasses) {
                if (visited.contains(i)) continue;
                ClassIndex cls = this.index.getClassIndex(i);
                q.add(cls);
                visited.add(i);
                this.addStemmedAltLabels(ret, cls);
            }
        }
        return ret;
    }

    private void addStemmedAltLabels(Set<String> labels, ClassIndex cls) {
        Set<String> newLabs = cls.getStemmedAltLabels();
        if (newLabs == null) {
            return;
        }
        for (String lab : newLabs) {
            labels.add(lab);
        }
    }

    OntologyProcessing() {
    }

    public static void main(String[] args) {
        OntologyProcessing p = new OntologyProcessing();
        p.roleAssertionLabelsExtractor.processLabel("Vicenza  , a city in north-eastern Italy, is the capital of the eponymous province in the Veneto region, at the northern base of the Monte Berico, straddling the Bacchiglione. Vicenza is approximately 60\u00a0km west of Venice and 200\u00a0km east of Milan. Vicenza is a thriving and cosmopolitan city, with a rich history and culture, and many museums, art galleries, piazzas, villas, churches and elegant Renaissance palazzi.");
        System.out.println("Vicenza  ".trim() + "'");
        System.out.println("Vicenza  , a city in north-eastern Italy, is the capital of the eponymous province in the Veneto region, at the northern base of the Monte Berico, straddling the Bacchiglione. Vicenza is approximately 60\u00a0km west of Venice and 200\u00a0km east of Milan. Vicenza is a thriving and cosmopolitan city, with a rich history and culture, and many museums, art galleries, piazzas, villas, churches and elegant Renaissance palazzi.".trim());
    }

    private class ExtractAcceptedLabelsFromRoleAssertions {
        Set<String> lexiconValues4individual = new HashSet<String>();
        String label_value;
        int max_size_name_label = 0;
        int min_size_name_label = 5000;

        ExtractAcceptedLabelsFromRoleAssertions() {
        }

        protected boolean isDummyIndividual(OWLNamedIndividual indiv) {
            for (OWLAxiom refAx : OntologyProcessing.this.onto.getReferencingAxioms((OWLPrimitive)indiv, Imports.INCLUDED)) {
                OWLObjectPropertyAssertionAxiom opaa;
                if (!(refAx instanceof OWLObjectPropertyAssertionAxiom) || ((OWLIndividual)(opaa = (OWLObjectPropertyAssertionAxiom)refAx).getObject()).isAnonymous() || !indiv.equals(((OWLIndividual)opaa.getObject()).asOWLNamedIndividual()) || ((OWLObjectPropertyExpression)opaa.getProperty()).isAnonymous()) continue;
                String prop_uri = ((OWLObjectPropertyExpression)opaa.getProperty()).asOWLObjectProperty().getIRI().toString();
                for (String op4indiv : Parameters.accepted_object_assertion_URIs_for_individuals) {
                    if (!prop_uri.equals(op4indiv)) continue;
                    return true;
                }
            }
            return false;
        }

        protected Set<String> extractLexiconFromRoleAssertions(OWLNamedIndividual indiv) {
            this.lexiconValues4individual.clear();
            for (OWLAnnotationAssertionAxiom indivAnnAx : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)indiv, (OWLOntology)OntologyProcessing.this.onto)) {
                String uri_ann = indivAnnAx.getAnnotation().getProperty().getIRI().toString();
                if (!Parameters.rdf_comment_uri.equals(uri_ann)) continue;
                try {
                    this.label_value = this.processLabel(((OWLLiteral)indivAnnAx.getAnnotation().getValue()).getLiteral().toLowerCase());
                }
                catch (Exception e) {
                    this.label_value = "";
                }
                if (this.label_value.length() > this.max_size_name_label) {
                    this.max_size_name_label = this.label_value.length();
                }
                if (this.label_value.length() > 0 && this.label_value.length() < this.min_size_name_label) {
                    this.min_size_name_label = this.label_value.length();
                }
                if (this.label_value.length() <= 2) continue;
                this.lexiconValues4individual.add(this.label_value);
            }
            for (String uri_indiv_ann : Parameters.accepted_data_assertion_URIs_for_individuals) {
                for (OWLLiteral assertion_value : Searcher.values((Collection)OntologyProcessing.this.onto.getDataPropertyAssertionAxioms((OWLIndividual)indiv), (OWLDataPropertyExpression)OntologyProcessing.this.index.getFactory().getOWLDataProperty(IRI.create((String)uri_indiv_ann)))) {
                    this.label_value = this.processLabel(assertion_value.getLiteral().toLowerCase());
                    if (this.label_value.length() > this.max_size_name_label) {
                        this.max_size_name_label = this.label_value.length();
                    }
                    if (this.label_value.length() > 0 && this.label_value.length() < this.min_size_name_label) {
                        this.min_size_name_label = this.label_value.length();
                    }
                    if (this.label_value.length() <= 2) continue;
                    this.lexiconValues4individual.add(this.label_value);
                }
            }
            for (String uri_indiv_ann_deep1 : Parameters.accepted_object_assertion_URIs_for_individuals) {
                for (OWLIndividual assertion_value_indiv : Searcher.values((Collection)OntologyProcessing.this.onto.getObjectPropertyAssertionAxioms((OWLIndividual)indiv), (OWLObjectPropertyExpression)OntologyProcessing.this.index.getFactory().getOWLObjectProperty(IRI.create((String)uri_indiv_ann_deep1)))) {
                    if (!assertion_value_indiv.isNamed()) continue;
                    for (String uri_indiv_ann_deep2 : Parameters.accepted_data_assertion_URIs_for_individuals_deep2) {
                        for (OWLLiteral assertion_value_deep2 : Searcher.values((Collection)OntologyProcessing.this.onto.getDataPropertyAssertionAxioms(assertion_value_indiv), (OWLDataPropertyExpression)OntologyProcessing.this.index.getFactory().getOWLDataProperty(IRI.create((String)uri_indiv_ann_deep2)))) {
                            this.label_value = this.processLabel(assertion_value_deep2.getLiteral().toLowerCase());
                            if (this.label_value.length() > this.max_size_name_label) {
                                this.max_size_name_label = this.label_value.length();
                            }
                            if (this.label_value.length() <= 2) continue;
                            this.lexiconValues4individual.add(this.label_value);
                        }
                    }
                    for (OWLAnnotationAssertionAxiom indivAnnAx_level2 : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)assertion_value_indiv.asOWLNamedIndividual(), (OWLOntology)OntologyProcessing.this.onto)) {
                        String uri_ann = indivAnnAx_level2.getAnnotation().getProperty().getIRI().toString();
                        if (!Parameters.rdf_comment_uri.equals(uri_ann) && !Parameters.rdf_label_uri.equals(uri_ann)) continue;
                        try {
                            this.label_value = this.processLabel(((OWLLiteral)indivAnnAx_level2.getAnnotation().getValue()).getLiteral().toLowerCase());
                        }
                        catch (Exception e) {
                            this.label_value = "";
                        }
                        if (this.label_value.length() > this.max_size_name_label) {
                            this.max_size_name_label = this.label_value.length();
                        }
                        if (this.label_value.length() > 0 && this.label_value.length() < this.min_size_name_label) {
                            this.min_size_name_label = this.label_value.length();
                        }
                        if (this.label_value.length() <= 2) continue;
                        this.lexiconValues4individual.add(this.label_value);
                    }
                }
            }
            return this.lexiconValues4individual;
        }

        protected Set<String> extractExtendedLexiconFromRoleAssertions(OWLNamedIndividual indiv) {
            String label_name;
            this.lexiconValues4individual.clear();
            Multimap dataProp2values = EntitySearcher.getDataPropertyValues((OWLIndividual)indiv, (OWLOntology)OntologyProcessing.this.onto);
            for (OWLDataPropertyExpression dataprop : dataProp2values.keySet()) {
                if (dataprop.isAnonymous() || Parameters.accepted_data_assertion_URIs_for_individuals.contains(dataprop.asOWLDataProperty().getIRI().toString()) || Parameters.accepted_data_assertion_URIs_for_individuals_deep2.contains(dataprop.asOWLDataProperty().getIRI().toString())) continue;
                label_name = Utilities.getEntityLabelFromURI(dataprop.asOWLDataProperty().getIRI().toString());
                for (OWLLiteral literal : dataProp2values.get((Object)dataprop)) {
                    this.lexiconValues4individual.add(label_name + "_" + NormalizeDate.normalize(literal.getLiteral().toString()));
                }
            }
            Multimap objProp2values = EntitySearcher.getObjectPropertyValues((OWLIndividual)indiv, (OWLOntology)OntologyProcessing.this.onto);
            for (OWLObjectPropertyExpression objprop : objProp2values.keySet()) {
                if (objprop.isAnonymous()) continue;
                label_name = Utilities.getEntityLabelFromURI(objprop.asOWLObjectProperty().getIRI().toString());
                for (OWLIndividual indiv_deep2 : objProp2values.get((Object)objprop)) {
                    if (indiv_deep2.isAnonymous() || !OntologyProcessing.this.inidividual2identifier.containsKey(indiv_deep2.asOWLNamedIndividual())) continue;
                    int ident = (Integer)OntologyProcessing.this.inidividual2identifier.get(indiv_deep2.asOWLNamedIndividual());
                    if (OntologyProcessing.this.index.hasIndividualAlternativeLabels(ident)) {
                        this.lexiconValues4individual.add(label_name + "_" + OntologyProcessing.this.index.getLabel4IndividualIndex(ident));
                        continue;
                    }
                    dataProp2values = EntitySearcher.getDataPropertyValues((OWLIndividual)indiv_deep2, (OWLOntology)OntologyProcessing.this.onto);
                    for (OWLDataPropertyExpression dataprop : dataProp2values.keySet()) {
                        if (dataprop.isAnonymous()) continue;
                        label_name = Utilities.getEntityLabelFromURI(dataprop.asOWLDataProperty().getIRI().toString());
                        for (OWLLiteral literal : dataProp2values.get((Object)dataprop)) {
                            this.lexiconValues4individual.add(label_name + "_" + NormalizeDate.normalize(literal.getLiteral().toString()));
                        }
                    }
                    Multimap objProp2values_deep2 = EntitySearcher.getObjectPropertyValues((OWLIndividual)indiv_deep2, (OWLOntology)OntologyProcessing.this.onto);
                    for (OWLObjectPropertyExpression objectprop2 : objProp2values_deep2.keySet()) {
                        if (objectprop2.isAnonymous()) continue;
                        label_name = Utilities.getEntityLabelFromURI(objectprop2.asOWLObjectProperty().getIRI().toString());
                        for (OWLIndividual indiv_deep3 : objProp2values_deep2.get((Object)objectprop2)) {
                            if (indiv_deep3.isAnonymous()) continue;
                            int ident2 = (Integer)OntologyProcessing.this.inidividual2identifier.get(indiv_deep3.asOWLNamedIndividual());
                            if (!OntologyProcessing.this.index.hasIndividualAlternativeLabels(ident2)) continue;
                            this.lexiconValues4individual.add(label_name + "_" + OntologyProcessing.this.index.getLabel4IndividualIndex(ident2));
                        }
                    }
                }
            }
            return this.lexiconValues4individual;
        }

        public String processLabel(String value) {
            String processedLabel = "";
            String reg_ex_split = "[&\\,;(/\\[]|(\\s)is(\\s)|(\\s)are(\\s)|(\\s)was(\\s)|(\\s)were(\\s)|(\\s)est(\\s)|(\\s)fut(\\s)|(\\s)un(\\s)|(\\s)a(\\s)|(\\s)an(\\s)";
            processedLabel = value.replaceAll(" obe ", "");
            processedLabel = processedLabel.replaceAll(" obe", "");
            processedLabel = processedLabel.replaceAll("obe ", "");
            processedLabel = processedLabel.replaceAll(" frs ", "");
            processedLabel = processedLabel.replaceAll(" frs", "");
            processedLabel = processedLabel.replaceAll("frs ", "");
            int manegeable_lenght = 65;
            if ((processedLabel = processedLabel.replaceAll(String.valueOf('\u00a0'), " ")).split(reg_ex_split).length == 0) {
                return "";
            }
            if (processedLabel.length() <= manegeable_lenght && !processedLabel.contains("<p>") && !processedLabel.contains("</p>")) {
                processedLabel = processedLabel.split(reg_ex_split)[0];
                processedLabel = processedLabel.split(reg_ex_split)[0];
                processedLabel = processedLabel.trim();
                return processedLabel;
            }
            if (processedLabel.startsWith("<p>")) {
                processedLabel = processedLabel.split("<p>")[1];
                processedLabel = processedLabel.split(reg_ex_split)[0];
                processedLabel = processedLabel.split(reg_ex_split)[0];
                if ((processedLabel = processedLabel.trim()).length() <= manegeable_lenght && this.isGoodLabel(processedLabel)) {
                    return processedLabel;
                }
                LogOutput.print("Filtered: " + processedLabel);
                return "";
            }
            processedLabel = processedLabel.split(reg_ex_split)[0];
            processedLabel = processedLabel.split(reg_ex_split)[0];
            if ((processedLabel = processedLabel.trim()).length() <= manegeable_lenght ? this.isGoodLabel(processedLabel) : this.isGoodLabel(processedLabel = processedLabel.substring(0, manegeable_lenght))) {
                return processedLabel;
            }
            LogOutput.print("Filtered: " + processedLabel);
            return "";
        }

        private boolean isGoodLabel(String label) {
            String consonant_regex = "[b-df-hj-np-tv-xz]";
            String more3_consonants_regex = consonant_regex + consonant_regex + consonant_regex + consonant_regex + "+";
            String more5_consonants_regex = consonant_regex + consonant_regex + consonant_regex + consonant_regex + consonant_regex + consonant_regex + "+";
            String vowel_regex = "[aeiou]";
            String more3_vowels_regex = vowel_regex + vowel_regex + vowel_regex + vowel_regex + "+";
            String same_character_3_times = ".*(.)\\1\\1.*";
            String space_character_3_times = ".*(\\s)\\1\\1.*";
            if (label.length() < 3) {
                return false;
            }
            if (label.contains("!") || label.contains("?")) {
                return false;
            }
            if (label.matches(space_character_3_times)) {
                return false;
            }
            String[] words = label.split(" ");
            boolean has_min_size_word = false;
            for (String word : words) {
                word = word.toLowerCase();
                if (NormalizeNumbers.getRomanNumbers10().contains(word) || word.length() > 1 && NormalizeNumbers.getRomanNumbers10().contains(word.substring(0, word.length() - 1)) || word.equals("st") || word.equals("dr")) continue;
                if (word.length() < 2) {
                    if (word.equals("a")) continue;
                    return false;
                }
                has_min_size_word = true;
                if (word.matches(same_character_3_times)) {
                    return false;
                }
                if (!word.startsWith("mc") && word.matches(more3_consonants_regex + ".*")) {
                    return false;
                }
                if (word.matches(".*" + more5_consonants_regex + ".*")) {
                    return false;
                }
                if (word.matches(".*" + more3_vowels_regex + ".*")) {
                    return false;
                }
                if (!word.matches(consonant_regex + "+") && !word.matches(vowel_regex + "+")) continue;
                return false;
            }
            return has_min_size_word;
        }
    }

    private class ExtractCategoriesForIndividual {
        ExtractCategoriesForIndividual() {
        }

        protected void extract(OWLNamedIndividual indiv, int ident) {
            String category_value;
            for (OWLAnnotationAssertionAxiom entityAnnAx : EntitySearcher.getAnnotationAssertionAxioms((OWLEntity)indiv, (OWLOntology)OntologyProcessing.this.onto)) {
                String uri_ann = entityAnnAx.getAnnotation().getProperty().getIRI().toString();
                if (!Parameters.accepted_property_URIs_for_instance_categories.contains(uri_ann)) continue;
                category_value = this.asDirectValue(entityAnnAx);
                if (!category_value.equals("")) {
                    OntologyProcessing.this.index.addCategory4Individual(ident, category_value);
                    continue;
                }
                category_value = this.asNamedIndividual(entityAnnAx);
                if (category_value.equals("")) continue;
                OntologyProcessing.this.index.addCategory4Individual(ident, category_value);
            }
            for (String uri_for_categories : Parameters.accepted_property_URIs_for_instance_categories) {
                try {
                    for (OWLLiteral assertion_value : Searcher.values((Collection)OntologyProcessing.this.onto.getDataPropertyAssertionAxioms((OWLIndividual)indiv), (OWLDataPropertyExpression)OntologyProcessing.this.index.getFactory().getOWLDataProperty(IRI.create((String)uri_for_categories)))) {
                        category_value = assertion_value.getLiteral().toLowerCase();
                        if (category_value == null || category_value.equals("null") || category_value.equals("")) continue;
                        OntologyProcessing.this.index.addCategory4Individual(ident, category_value);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    for (OWLIndividual assertion_value_indiv : Searcher.values((Collection)OntologyProcessing.this.onto.getObjectPropertyAssertionAxioms((OWLIndividual)indiv), (OWLObjectPropertyExpression)OntologyProcessing.this.index.getFactory().getOWLObjectProperty(IRI.create((String)uri_for_categories)))) {
                        if (!assertion_value_indiv.isNamed() || (category_value = assertion_value_indiv.asOWLNamedIndividual().getIRI().toString()) == null || category_value.equals("null") || category_value.equals("")) continue;
                        OntologyProcessing.this.index.addCategory4Individual(ident, category_value);
                    }
                }
                catch (Exception exception) {
                }
            }
        }

        private String asDirectValue(OWLAnnotationAssertionAxiom entityAnnAx) {
            try {
                String label = ((OWLLiteral)entityAnnAx.getAnnotation().getValue()).getLiteral().toLowerCase();
                if (label == null || label.equals("null") || label.equals("")) {
                    return "";
                }
                return label;
            }
            catch (Exception e) {
                return "";
            }
        }

        private String asNamedIndividual(OWLAnnotationAssertionAxiom entityAnnAx) {
            try {
                String namedIndivIRI = ((IRI)entityAnnAx.getAnnotation().getValue()).toString();
                if (namedIndivIRI == null || namedIndivIRI.equals("null") || namedIndivIRI.equals("")) {
                    return "";
                }
                return namedIndivIRI;
            }
            catch (Exception e) {
                return "";
            }
        }
    }
}

