/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.division;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import uk.ac.ox.krr.logmap2.division.MatchingTask;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;

public class QualityMeasures {
    int number_tasks;
    int min_size_modules_ontology1;
    int max_size_modules_ontology1;
    double average_size_modules_ontology1;
    int min_size_modules_ontology2;
    int max_size_modules_ontology2;
    double average_size_modules_ontology2;
    long min_size_task;
    long max_size_task;
    String min_size_task_str;
    String max_size_task_str;
    double avg_size_task;
    double min_ratio_modules;
    double max_ratio_modules;
    double average_ratio_modules;
    int aggregation_modules_ontology1;
    int aggregation_modules_ontology2;
    long aggregation_task_sizes;
    double ratio_task_size;
    long size_ontology1;
    long size_ontology2;
    double min_coverage_task;
    double max_coverage_task;
    double average_coverage_task;
    double global_coverage_1;
    double global_coverage_2;
    int positive_redundancy;
    int negative_redundancy;
    double computation_time = 0.0;
    List<MatchingTask> tasks;

    public QualityMeasures() {
    }

    public QualityMeasures(List<MatchingTask> tasks, Set<MappingObjectStr> alignment_1, Set<MappingObjectStr> alignment_2, double time, long size_ontology1, long size_ontology2) {
        this(tasks, alignment_1, alignment_2, size_ontology1, size_ontology2);
        this.computation_time = time;
    }

    public void clear() {
        this.tasks.clear();
    }

    public QualityMeasures(List<MatchingTask> tasks, Set<MappingObjectStr> alignment_1, Set<MappingObjectStr> alignment_2, long size_ontology1, long size_ontology2) {
        this.tasks = tasks;
        this.computeMetricsModuleTasks(tasks);
        this.computeSizeTasks(tasks, size_ontology1, size_ontology2);
        this.global_coverage_1 = this.computeCoverageTasks(tasks, alignment_1);
        this.global_coverage_2 = this.computeCoverageTasks(tasks, alignment_2);
    }

    public void computeMetricsModuleTasks(List<MatchingTask> tasks) {
        this.number_tasks = tasks.size();
        this.aggregation_modules_ontology1 = 0;
        this.aggregation_modules_ontology2 = 0;
        this.min_size_modules_ontology1 = tasks.get(0).getSignatureSourceOntology().size();
        this.max_size_modules_ontology1 = tasks.get(0).getSignatureSourceOntology().size();
        this.min_size_modules_ontology2 = tasks.get(0).getSignatureTargetOntology().size();
        this.max_size_modules_ontology2 = tasks.get(0).getSignatureTargetOntology().size();
        this.average_size_modules_ontology1 = 0.0;
        this.average_size_modules_ontology2 = 0.0;
        this.min_ratio_modules = (double)tasks.get(0).getSignatureSourceOntology().size() / (double)tasks.get(0).getSignatureTargetOntology().size();
        this.max_ratio_modules = (double)tasks.get(0).getSignatureSourceOntology().size() / (double)tasks.get(0).getSignatureTargetOntology().size();
        this.average_ratio_modules = 0.0;
        for (int i = 0; i < tasks.size(); ++i) {
            this.aggregation_modules_ontology1 += tasks.get(i).getSignatureSourceOntology().size();
            this.aggregation_modules_ontology2 += tasks.get(i).getSignatureTargetOntology().size();
            int aux = tasks.get(i).getSignatureSourceOntology().size();
            if (aux < this.min_size_modules_ontology1) {
                this.min_size_modules_ontology1 = aux;
            } else if (aux > this.max_size_modules_ontology1) {
                this.max_size_modules_ontology1 = aux;
            }
            aux = tasks.get(i).getSignatureTargetOntology().size();
            if (aux < this.min_size_modules_ontology2) {
                this.min_size_modules_ontology2 = aux;
            } else if (aux > this.max_size_modules_ontology2) {
                this.max_size_modules_ontology2 = aux;
            }
            this.average_size_modules_ontology1 += (double)tasks.get(i).getSignatureSourceOntology().size();
            this.average_size_modules_ontology2 += (double)tasks.get(i).getSignatureTargetOntology().size();
            double ratio = (double)tasks.get(i).getSignatureSourceOntology().size() / (double)tasks.get(i).getSignatureTargetOntology().size();
            if (ratio < this.min_ratio_modules) {
                this.min_ratio_modules = ratio;
            } else if (ratio > this.max_ratio_modules) {
                this.max_ratio_modules = ratio;
            }
            this.average_ratio_modules += ratio;
        }
        this.average_size_modules_ontology1 /= (double)tasks.size();
        this.average_size_modules_ontology2 /= (double)tasks.size();
        this.average_ratio_modules /= (double)tasks.size();
    }

    public void computeSizeTasks(List<MatchingTask> tasks, long size_ontology1, long size_ontology2) {
        this.avg_size_task = 0.0;
        this.aggregation_task_sizes = 0L;
        long original_task_size = size_ontology1 * size_ontology2;
        long size_task = (long)tasks.get(0).getSignatureSourceOntology().size() * (long)tasks.get(0).getSignatureTargetOntology().size();
        String size_task_str = (long)tasks.get(0).getSignatureSourceOntology().size() + " x " + (long)tasks.get(0).getSignatureTargetOntology().size();
        this.min_size_task = size_task;
        this.min_size_task_str = size_task_str;
        this.max_size_task = size_task;
        this.max_size_task_str = size_task_str;
        for (int i = 0; i < tasks.size(); ++i) {
            size_task = (long)tasks.get(i).getSignatureSourceOntology().size() * (long)tasks.get(i).getSignatureTargetOntology().size();
            size_task_str = (long)tasks.get(i).getSignatureSourceOntology().size() + " x " + (long)tasks.get(i).getSignatureTargetOntology().size();
            if (size_task < this.min_size_task) {
                this.min_size_task = size_task;
                this.min_size_task_str = size_task_str;
            } else if (size_task > this.max_size_task) {
                this.max_size_task = size_task;
                this.max_size_task_str = size_task_str;
            }
            this.aggregation_task_sizes += size_task;
        }
        this.avg_size_task = (double)this.aggregation_task_sizes / (double)tasks.size();
        this.ratio_task_size = (double)this.aggregation_task_sizes / (double)original_task_size;
    }

    public double getLocalCoverage(MatchingTask task, Set<MappingObjectStr> alignment) {
        int positive_hits = 0;
        for (MappingObjectStr mapping : alignment) {
            if (!this.isMappingAvailableInTask(task, mapping)) continue;
            ++positive_hits;
        }
        return (double)positive_hits / (double)alignment.size();
    }

    public double computeCoverageTasks(List<MatchingTask> tasks, Set<MappingObjectStr> alignment) {
        int positive_hits = 0;
        this.negative_redundancy = 0;
        ArrayList<Integer> positive_hits_list = new ArrayList<Integer>();
        ArrayList<Integer> positive_hits_task = new ArrayList<Integer>();
        for (int i = 0; i < tasks.size(); ++i) {
            positive_hits_task.add(0);
        }
        for (MappingObjectStr mapping : alignment) {
            positive_hits = 0;
            for (int i = 0; i < tasks.size(); ++i) {
                MatchingTask task = tasks.get(i);
                if (this.isMappingAvailableInTask(task, mapping)) {
                    positive_hits_task.set(i, (Integer)positive_hits_task.get(i) + 1);
                    ++positive_hits;
                    continue;
                }
                if (!this.isPartialMappingAvailableInTask(task, mapping)) continue;
                ++this.negative_redundancy;
            }
            positive_hits_list.add(positive_hits);
        }
        this.min_coverage_task = ((Integer)positive_hits_task.get(0)).intValue();
        this.max_coverage_task = ((Integer)positive_hits_task.get(0)).intValue();
        this.average_coverage_task = 0.0;
        for (int i = 0; i < positive_hits_task.size(); ++i) {
            if ((double)((Integer)positive_hits_task.get(i)).intValue() > this.max_coverage_task) {
                this.max_coverage_task = ((Integer)positive_hits_task.get(i)).intValue();
            } else if ((double)((Integer)positive_hits_task.get(i)).intValue() < this.min_coverage_task) {
                this.min_coverage_task = ((Integer)positive_hits_task.get(i)).intValue();
            }
            this.average_coverage_task += (double)((Integer)positive_hits_task.get(i)).intValue();
        }
        this.average_coverage_task /= (double)tasks.size();
        this.average_coverage_task /= (double)alignment.size();
        this.max_coverage_task /= (double)alignment.size();
        this.min_coverage_task /= (double)alignment.size();
        positive_hits = 0;
        Iterator iterator = positive_hits_list.iterator();
        while (iterator.hasNext()) {
            int hits = (Integer)iterator.next();
            if (hits > 0) {
                ++positive_hits;
            }
            if (hits <= 1) continue;
            ++this.positive_redundancy;
        }
        return (double)positive_hits / (double)alignment.size();
    }

    public boolean isMappingAvailableInTask(MatchingTask task, MappingObjectStr mapping) {
        return task.getSignatureSourceOntology().contains(mapping.getIRIStrEnt1()) && task.getSignatureTargetOntology().contains(mapping.getIRIStrEnt2());
    }

    public boolean isPartialMappingAvailableInTask(MatchingTask task, MappingObjectStr mapping) {
        return task.getSignatureSourceOntology().contains(mapping.getIRIStrEnt1()) || task.getSignatureTargetOntology().contains(mapping.getIRIStrEnt2());
    }

    public static String toStringHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append("number_tasks").append("\t").append("min_modules_O1").append("\t").append("max_modules_O1").append("\t").append("avg_modules_O1").append("\t").append("min_modules_O2").append("\t").append("max_modules_O2").append("\t").append("avg_modules_O2").append("\t").append("min_task").append("\t").append("max_task").append("\t").append("ratio_tasks_size").append("\t").append("coverage1").append("\t").append("coverage2").append("\t").append("time");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.number_tasks).append("\t").append(this.min_size_modules_ontology1).append("\t").append(this.max_size_modules_ontology1).append("\t").append(this.average_size_modules_ontology1).append("\t").append(this.min_size_modules_ontology2).append("\t").append(this.max_size_modules_ontology2).append("\t").append(this.average_size_modules_ontology2).append("\t").append(this.min_size_task_str).append("\t").append(this.max_size_task_str).append("\t").append(this.ratio_task_size).append("\t").append(this.global_coverage_1).append("\t").append(this.global_coverage_2).append("\t").append(this.computation_time);
        return sb.toString();
    }
}

