/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2;

import java.net.URL;
import java.util.Calendar;
import uk.ac.ox.krr.logmap2.LogMap2Core;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.io.OAEIAlignmentOutput;
import uk.ac.ox.krr.logmap2.oaei.oracle.OracleManager;

public class LogMap2_OAEI {
    private long init_tot;
    private long fin;
    private double total_time = 0.0;
    LogMap2Core logmap2;
    OAEIAlignmentOutput alignment_output;

    public void align(URL source, URL target) throws Exception {
        this.init_tot = Calendar.getInstance().getTimeInMillis();
        OracleManager.allowOracle(Parameters.allow_interactivity);
        this.logmap2 = new LogMap2Core(source.toURI().toString(), target.toURI().toString());
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.total_time = (double)((float)((double)this.fin - (double)this.init_tot)) / 1000.0;
        if (OracleManager.isActive()) {
            System.out.println("\tNumber of questions to oracle: " + OracleManager.getNumberOfQuestions());
        }
    }

    private boolean ignoreMapping(String uri_entity) {
        for (String uri : Parameters.filter_entities) {
            if (!uri_entity.contains(uri)) continue;
            return true;
        }
        return false;
    }

    public URL returnAlignmentFile() throws Exception {
        this.alignment_output = new OAEIAlignmentOutput("alignment", this.logmap2.getIRIOntology1(), this.logmap2.getIRIOntology2());
        if (Parameters.output_class_mappings) {
            for (int ide1 : this.logmap2.getClassMappings().keySet()) {
                if (this.ignoreMapping(this.logmap2.getIRI4ConceptIdentifier(ide1))) continue;
                for (int ide2 : this.logmap2.getClassMappings().get(ide1)) {
                    int dir_mapping = this.logmap2.getDirClassMapping(ide1, ide2);
                    if (this.ignoreMapping(this.logmap2.getIRI4ConceptIdentifier(ide2)) || this.logmap2.getIRI4ConceptIdentifier(ide1).equals(this.logmap2.getIRI4ConceptIdentifier(ide2)) || dir_mapping == -3) continue;
                    if (dir_mapping != -1) {
                        if (Parameters.output_equivalences_only) {
                            dir_mapping = -2;
                        }
                        this.alignment_output.addClassMapping2Output(this.logmap2.getIRI4ConceptIdentifier(ide1), this.logmap2.getIRI4ConceptIdentifier(ide2), dir_mapping, this.logmap2.getConfidence4ConceptMapping(ide1, ide2));
                        continue;
                    }
                    if (Parameters.output_equivalences_only) {
                        dir_mapping = -2;
                    }
                    this.alignment_output.addClassMapping2Output(this.logmap2.getIRI4ConceptIdentifier(ide2), this.logmap2.getIRI4ConceptIdentifier(ide1), dir_mapping, this.logmap2.getConfidence4ConceptMapping(ide1, ide2));
                }
            }
        }
        if (Parameters.output_prop_mappings) {
            for (int ide1 : this.logmap2.getDataPropMappings().keySet()) {
                if (this.ignoreMapping(this.logmap2.getIRI4DataPropIdentifier(ide1)) || this.ignoreMapping(this.logmap2.getIRI4DataPropIdentifier(this.logmap2.getDataPropMappings().get(ide1))) || this.logmap2.getIRI4DataPropIdentifier(ide1).equals(this.logmap2.getIRI4DataPropIdentifier(this.logmap2.getDataPropMappings().get(ide1)))) continue;
                this.alignment_output.addDataPropMapping2Output(this.logmap2.getIRI4DataPropIdentifier(ide1), this.logmap2.getIRI4DataPropIdentifier(this.logmap2.getDataPropMappings().get(ide1)), -2, this.logmap2.getConfidence4DataPropConceptMapping(ide1, this.logmap2.getDataPropMappings().get(ide1)));
            }
            for (int ide1 : this.logmap2.getObjectPropMappings().keySet()) {
                if (this.ignoreMapping(this.logmap2.getIRI4ObjectPropIdentifier(ide1)) || this.ignoreMapping(this.logmap2.getIRI4ObjectPropIdentifier(this.logmap2.getObjectPropMappings().get(ide1))) || this.logmap2.getIRI4ObjectPropIdentifier(ide1).equals(this.logmap2.getIRI4ObjectPropIdentifier(this.logmap2.getObjectPropMappings().get(ide1)))) continue;
                this.alignment_output.addObjPropMapping2Output(this.logmap2.getIRI4ObjectPropIdentifier(ide1), this.logmap2.getIRI4ObjectPropIdentifier(this.logmap2.getObjectPropMappings().get(ide1)), -2, this.logmap2.getConfidence4ObjectPropConceptMapping(ide1, this.logmap2.getObjectPropMappings().get(ide1)));
            }
        }
        if (Parameters.perform_instance_matching && Parameters.output_instance_mappings) {
            if (Parameters.output_instance_mapping_files) {
                for (int ide1 : this.logmap2.getInstanceMappings4OutputType().keySet()) {
                    for (int ide2 : this.logmap2.getInstanceMappings4OutputType().get(ide1).keySet()) {
                        int type;
                        if (this.logmap2.getIRI4InstanceIdentifier(ide1).equals(this.logmap2.getIRI4InstanceIdentifier(ide2)) || (type = this.logmap2.getInstanceMappings4OutputType().get(ide1).get(ide2).intValue()) > 1) continue;
                        this.alignment_output.addInstanceMapping2Output(this.logmap2.getIRI4InstanceIdentifier(ide1), this.logmap2.getIRI4InstanceIdentifier(ide2), this.logmap2.getConfidence4InstanceMapping(ide1, ide2));
                    }
                }
            } else {
                for (int ide1 : this.logmap2.getInstanceMappings().keySet()) {
                    for (int ide2 : this.logmap2.getInstanceMappings().get(ide1)) {
                        if (this.logmap2.getIRI4InstanceIdentifier(ide1).equals(this.logmap2.getIRI4InstanceIdentifier(ide2))) continue;
                        this.alignment_output.addInstanceMapping2Output(this.logmap2.getIRI4InstanceIdentifier(ide1), this.logmap2.getIRI4InstanceIdentifier(ide2), this.logmap2.getConfidence4InstanceMapping(ide1, ide2));
                    }
                }
            }
        }
        this.alignment_output.saveOutputFile();
        this.logmap2.clearIndexStructures();
        return this.alignment_output.returnAlignmentFile();
    }
}

