/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.ox.krr.logmap2.LogMap2Core;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.io.FlatAlignmentFormat;
import uk.ac.ox.krr.logmap2.io.OutPutFilesManagerStatic;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.oaei.reader.MappingsReaderManager;
import uk.ac.ox.krr.logmap2.utilities.StandardMeasures;

public class LogMap2_Matcher {
    LogMap2Core logmap2;
    Set<MappingObjectStr> logmap2_mappings = new HashSet<MappingObjectStr>();
    Set<MappingObjectStr> logmap2_discarded_mappings = new HashSet<MappingObjectStr>();
    Set<MappingObjectStr> logmap2_hard_discarded_mappings = new HashSet<MappingObjectStr>();
    Set<MappingObjectStr> logmap2_conflictive_mappings = new HashSet<MappingObjectStr>();
    Set<MappingObjectStr> logmap2_anchors = new HashSet<MappingObjectStr>();
    Set<String> representative_labels = new HashSet<String>();

    public LogMap2_Matcher(String iri_onto1, String iri_onto2, String output_path, boolean eval_impact) {
        Parameters.readParameters();
        try {
            this.logmap2 = new LogMap2Core(iri_onto1, iri_onto2, output_path, eval_impact);
            this.createObjectMappings();
            this.saveMappings(output_path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LogMap2_Matcher(String iri_onto1, String iri_onto2, String reference, String output_path, boolean eval_impact) {
        this(iri_onto1, iri_onto2, output_path, eval_impact);
        try {
            MappingsReaderManager reader = new MappingsReaderManager(reference, "RDF");
            StandardMeasures.computeStandardMeasures(this.getLogmap2_Mappings(), reader.getMappingObjects());
            System.out.println("Precision\tRecall\tF-score");
            System.out.format("%.3f\t%.3f\t%.3f\n", StandardMeasures.getPrecision(), StandardMeasures.getRecall(), StandardMeasures.getFscore());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveMappings(String output_path) throws Exception {
        this.saveLogMapMappings(this.getLogmap2_anchors(), output_path, "logmap_anchors");
        this.saveMappingsFlatFormat(this.getLogmap2_DiscardedMappings(), output_path, "logmap_discarded_mappings.txt");
        this.saveMappingsFlatFormat(this.getLogmap2_HardDiscardedMappings(), output_path, "logmap_hard_discarded_mappings.txt");
        this.saveMappingsFlatFormat(this.getLogmap2_ConflictiveMappings(), output_path, "logmap_logically_conflicting_mappings.txt");
        this.saveMappingsFlatFormat(this.getOverEstimationOfMappings(), output_path, "logmap_overestimation.txt");
    }

    private void saveLogMapMappings(Set<MappingObjectStr> mappings, String output_path, String name) throws Exception {
        OutPutFilesManagerStatic.createOutFiles(output_path + name, 4, "http://logmap-tests/oaei/source.owl", "http://logmap-tests/oaei/target.owl");
        for (MappingObjectStr mapping : mappings) {
            if (mapping.isClassMapping()) {
                OutPutFilesManagerStatic.addClassMapping2Files(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
                continue;
            }
            if (mapping.isObjectPropertyMapping()) {
                OutPutFilesManagerStatic.addObjPropMapping2Files(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
                continue;
            }
            if (mapping.isDataPropertyMapping()) {
                OutPutFilesManagerStatic.addDataPropMapping2Files(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
                continue;
            }
            if (!mapping.isInstanceMapping()) continue;
            OutPutFilesManagerStatic.addInstanceMapping2Files(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getConfidence());
        }
        OutPutFilesManagerStatic.closeAndSaveFiles();
    }

    private void saveMappingsFlatFormat(Set<MappingObjectStr> mappings, String output_path, String name) throws Exception {
        FlatAlignmentFormat flat_format = new FlatAlignmentFormat(output_path + name);
        for (MappingObjectStr mapping : mappings) {
            if (mapping.isClassMapping()) {
                flat_format.addClassMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
                continue;
            }
            if (mapping.isObjectPropertyMapping()) {
                flat_format.addObjPropMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
                continue;
            }
            if (mapping.isDataPropertyMapping()) {
                flat_format.addDataPropMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getMappingDirection(), mapping.getConfidence());
                continue;
            }
            if (!mapping.isInstanceMapping()) continue;
            flat_format.addInstanceMapping2Output(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), mapping.getConfidence());
        }
        flat_format.saveOutputFile();
    }

    public LogMap2_Matcher(String iri_onto1, String iri_onto2) {
        Parameters.readParameters();
        try {
            this.logmap2 = new LogMap2Core(iri_onto1, iri_onto2);
            this.createObjectMappings();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LogMap2_Matcher(OWLOntology onto1, OWLOntology onto2) {
        Parameters.readParameters();
        try {
            this.logmap2 = new LogMap2Core(onto1, onto2);
            this.createObjectMappings();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LogMap2_Matcher(OWLOntology onto1, OWLOntology onto2, String path_parameters) {
        Parameters.readParameters(path_parameters);
        try {
            this.logmap2 = new LogMap2Core(onto1, onto2);
            this.createObjectMappings();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LogMap2_Matcher(String onto_uri1, String onto_uri2, String path_parameters) {
        Parameters.readParameters(path_parameters);
        try {
            this.logmap2 = new LogMap2Core(onto_uri1, onto_uri2);
            this.createObjectMappings();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LogMap2_Matcher(OWLOntology onto1, OWLOntology onto2, boolean only_anchors) {
        Parameters.readParameters();
        try {
            this.logmap2 = new LogMap2Core(onto1, onto2, only_anchors);
            this.createObjectMappings();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LogMap2_Matcher(OWLOntology onto1, OWLOntology onto2, Set<MappingObjectStr> input_mappings) {
        Parameters.readParameters();
        try {
            this.logmap2 = new LogMap2Core(onto1, onto2, input_mappings);
            this.createObjectMappings();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LogMap2_Matcher(OWLOntology onto1, OWLOntology onto2, Set<MappingObjectStr> input_mappings, boolean are_input_mappings_validated) {
        Parameters.readParameters();
        try {
            this.logmap2 = new LogMap2Core(onto1, onto2, input_mappings, are_input_mappings_validated);
            this.createObjectMappings();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set<MappingObjectStr> getLogmap2_Mappings() {
        return this.logmap2_mappings;
    }

    public Set<MappingObjectStr> getLogmap2_DiscardedMappings() {
        return this.logmap2_discarded_mappings;
    }

    public Set<MappingObjectStr> getLogmap2_HardDiscardedMappings() {
        return this.logmap2_hard_discarded_mappings;
    }

    public Set<MappingObjectStr> getLogmap2_ConflictiveMappings() {
        return this.logmap2_conflictive_mappings;
    }

    public Set<MappingObjectStr> getLogmap2_anchors() {
        return this.logmap2_anchors;
    }

    public Set<String> getRepresentativeLabelsForMappings() {
        return this.representative_labels;
    }

    public String getIRIOntology1() {
        return this.logmap2.getIRIOntology1();
    }

    public String getIRIOntology2() {
        return this.logmap2.getIRIOntology2();
    }

    public OWLOntology getOWLOntology4Mappings() throws Exception {
        return this.logmap2.getOWLOntology4Mappings();
    }

    private void createObjectMappings() {
        try {
            MappingObjectStr mapping;
            int dir_mapping;
            if (Parameters.output_class_mappings) {
                for (int ide1 : this.logmap2.getClassMappings().keySet()) {
                    for (int ide2 : this.logmap2.getClassMappings().get(ide1)) {
                        if (this.logmap2.getIRI4ConceptIdentifier(ide1).equals(this.logmap2.getIRI4ConceptIdentifier(ide2)) || (dir_mapping = this.logmap2.getDirClassMapping(ide1, ide2)) == -3) continue;
                        if (this.representative_labels.size() % 2 == 0) {
                            this.representative_labels.add(this.logmap2.getLabel4ConceptIdentifier(ide2));
                        } else {
                            this.representative_labels.add(this.logmap2.getLabel4ConceptIdentifier(ide1));
                        }
                        if (dir_mapping != -1) {
                            if (Parameters.output_equivalences_only) {
                                dir_mapping = -2;
                            }
                            mapping = new MappingObjectStr(this.logmap2.getIRI4ConceptIdentifier(ide1), this.logmap2.getIRI4ConceptIdentifier(ide2), this.logmap2.getConfidence4ConceptMapping(ide1, ide2), dir_mapping, 0);
                        } else {
                            if (Parameters.output_equivalences_only) {
                                dir_mapping = -2;
                            }
                            mapping = new MappingObjectStr(this.logmap2.getIRI4ConceptIdentifier(ide2), this.logmap2.getIRI4ConceptIdentifier(ide1), this.logmap2.getConfidence4ConceptMapping(ide1, ide2), dir_mapping, 0);
                        }
                        mapping.setLexicalConfidenceMapping(this.logmap2.getLexicalScore4ConceptMapping(ide1, ide2));
                        mapping.setScopeConfidenceMapping(this.logmap2.getStrutcuralScore4ConceptMapping(ide1, ide2));
                        this.logmap2_mappings.add(mapping);
                    }
                }
            }
            if (Parameters.output_prop_mappings) {
                for (int ide1 : this.logmap2.getDataPropMappings().keySet()) {
                    if (this.logmap2.getIRI4DataPropIdentifier(ide1).equals(this.logmap2.getIRI4DataPropIdentifier(this.logmap2.getDataPropMappings().get(ide1)))) continue;
                    double conf = this.logmap2.getConfidence4DataPropConceptMapping(ide1, this.logmap2.getDataPropMappings().get(ide1));
                    mapping = new MappingObjectStr(this.logmap2.getIRI4DataPropIdentifier(ide1), this.logmap2.getIRI4DataPropIdentifier(this.logmap2.getDataPropMappings().get(ide1)), conf, -2, 1);
                    mapping.setLexicalConfidenceMapping(conf);
                    mapping.setScopeConfidenceMapping(conf);
                    this.logmap2_mappings.add(mapping);
                }
                for (int ide1 : this.logmap2.getObjectPropMappings().keySet()) {
                    if (this.logmap2.getIRI4ObjectPropIdentifier(ide1).equals(this.logmap2.getIRI4ObjectPropIdentifier(this.logmap2.getObjectPropMappings().get(ide1)))) continue;
                    double conf = this.logmap2.getConfidence4ObjectPropConceptMapping(ide1, this.logmap2.getObjectPropMappings().get(ide1));
                    mapping = new MappingObjectStr(this.logmap2.getIRI4ObjectPropIdentifier(ide1), this.logmap2.getIRI4ObjectPropIdentifier(this.logmap2.getObjectPropMappings().get(ide1)), conf, -2, 2);
                    mapping.setLexicalConfidenceMapping(conf);
                    mapping.setScopeConfidenceMapping(conf);
                    this.logmap2_mappings.add(mapping);
                }
            }
            if (Parameters.perform_instance_matching && Parameters.output_instance_mappings) {
                for (int ide1 : this.logmap2.getInstanceMappings().keySet()) {
                    for (int ide2 : this.logmap2.getInstanceMappings().get(ide1)) {
                        if (this.logmap2.getIRI4InstanceIdentifier(ide1).equals(this.logmap2.getIRI4InstanceIdentifier(ide2))) continue;
                        mapping = new MappingObjectStr(this.logmap2.getIRI4InstanceIdentifier(ide1), this.logmap2.getIRI4InstanceIdentifier(ide2), this.logmap2.getConfidence4InstanceMapping(ide1, ide2), -2, 3);
                        mapping.setLexicalConfidenceMapping(this.logmap2.getLexicalScore4InstanceMapping(ide1, ide2));
                        mapping.setScopeConfidenceMapping(this.logmap2.getStructuralScore4InstanceMapping(ide1, ide2));
                        this.logmap2_mappings.add(mapping);
                    }
                }
            }
            for (int ide1 : this.logmap2.getDiscardedClassMappings().keySet()) {
                for (int ide2 : this.logmap2.getDiscardedClassMappings().get(ide1)) {
                    mapping = new MappingObjectStr(this.logmap2.getIRI4ConceptIdentifier(ide1), this.logmap2.getIRI4ConceptIdentifier(ide2), this.logmap2.getConfidence4ConceptMapping(ide1, ide2), -2, 0);
                    mapping.setLexicalConfidenceMapping(this.logmap2.getLexicalScore4ConceptMapping(ide1, ide2));
                    mapping.setScopeConfidenceMapping(this.logmap2.getStrutcuralScore4ConceptMapping(ide1, ide2));
                    if (this.logmap2_mappings.contains(mapping)) continue;
                    this.logmap2_discarded_mappings.add(mapping);
                }
            }
            for (int ide1 : this.logmap2.getHardDiscardedClassMappings().keySet()) {
                for (int ide2 : this.logmap2.getHardDiscardedClassMappings().get(ide1)) {
                    mapping = new MappingObjectStr(this.logmap2.getIRI4ConceptIdentifier(ide1), this.logmap2.getIRI4ConceptIdentifier(ide2), this.logmap2.getConfidence4ConceptMapping(ide1, ide2), -2, 0);
                    mapping.setLexicalConfidenceMapping(this.logmap2.getLexicalScore4ConceptMapping(ide1, ide2));
                    mapping.setScopeConfidenceMapping(this.logmap2.getStrutcuralScore4ConceptMapping(ide1, ide2));
                    if (this.logmap2_mappings.contains(mapping)) continue;
                    this.logmap2_hard_discarded_mappings.add(mapping);
                }
            }
            for (int ide1 : this.logmap2.getConflictiveAnchors().keySet()) {
                for (int ide2 : this.logmap2.getConflictiveAnchors().get(ide1)) {
                    mapping = ide1 < ide2 ? new MappingObjectStr(this.logmap2.getIRI4ConceptIdentifier(ide1), this.logmap2.getIRI4ConceptIdentifier(ide2), this.logmap2.getConfidence4ConceptMapping(ide1, ide2), 0, 0) : new MappingObjectStr(this.logmap2.getIRI4ConceptIdentifier(ide2), this.logmap2.getIRI4ConceptIdentifier(ide1), this.logmap2.getConfidence4ConceptMapping(ide1, ide2), -1, 0);
                    mapping.setLexicalConfidenceMapping(this.logmap2.getLexicalScore4ConceptMapping(ide1, ide2));
                    mapping.setScopeConfidenceMapping(this.logmap2.getStrutcuralScore4ConceptMapping(ide1, ide2));
                    this.logmap2_conflictive_mappings.add(mapping);
                }
            }
            for (int ide1 : this.logmap2.getAnchors().keySet()) {
                for (int ide2 : this.logmap2.getAnchors().get(ide1)) {
                    if (this.logmap2.getIRI4ConceptIdentifier(ide1).equals(this.logmap2.getIRI4ConceptIdentifier(ide2)) || (dir_mapping = this.logmap2.getDirClassMapping(ide1, ide2)) == -3) continue;
                    mapping = dir_mapping != -1 ? new MappingObjectStr(this.logmap2.getIRI4ConceptIdentifier(ide1), this.logmap2.getIRI4ConceptIdentifier(ide2), this.logmap2.getConfidence4ConceptMapping(ide1, ide2), dir_mapping, 0) : new MappingObjectStr(this.logmap2.getIRI4ConceptIdentifier(ide2), this.logmap2.getIRI4ConceptIdentifier(ide1), this.logmap2.getConfidence4ConceptMapping(ide1, ide2), dir_mapping, 0);
                    mapping.setLexicalConfidenceMapping(this.logmap2.getLexicalScore4ConceptMapping(ide1, ide2));
                    mapping.setScopeConfidenceMapping(this.logmap2.getStrutcuralScore4ConceptMapping(ide1, ide2));
                    this.logmap2_anchors.add(mapping);
                }
            }
            this.logmap2.clearIndexStructures();
        }
        catch (Exception e) {
            System.err.println("Error creating object mappings");
        }
    }

    public Set<MappingObjectStr> getOverEstimationOfMappings() {
        MappingObjectStr m_new;
        HashSet<MappingObjectStr> overEstimationMappings = new HashSet<MappingObjectStr>();
        for (MappingObjectStr m : this.getLogmap2_anchors()) {
            if (overEstimationMappings.contains(m)) continue;
            m_new = new MappingObjectStr(m);
            m_new.setConfidenceMapping(1.0);
            overEstimationMappings.add(m_new);
        }
        for (MappingObjectStr m : this.getLogmap2_Mappings()) {
            if (overEstimationMappings.contains(m)) continue;
            m_new = new MappingObjectStr(m);
            m_new.setConfidenceMapping(0.8);
            overEstimationMappings.add(m_new);
        }
        for (MappingObjectStr m : this.getLogmap2_DiscardedMappings()) {
            if (overEstimationMappings.contains(m)) continue;
            m_new = new MappingObjectStr(m);
            m_new.setConfidenceMapping(0.6);
            overEstimationMappings.add(m_new);
        }
        for (MappingObjectStr m : this.getLogmap2_HardDiscardedMappings()) {
            if (overEstimationMappings.contains(m)) continue;
            m_new = new MappingObjectStr(m);
            m_new.setConfidenceMapping(0.4);
            overEstimationMappings.add(m_new);
        }
        for (MappingObjectStr m : this.getLogmap2_ConflictiveMappings()) {
            if (overEstimationMappings.contains(m)) continue;
            m_new = new MappingObjectStr(m);
            m_new.setConfidenceMapping(0.2);
            overEstimationMappings.add(m_new);
        }
        return overEstimationMappings;
    }

    private static String getHelpMessage() {
        return "LogMap 2 requires four parameters:\n\t1. IRI ontology 1. e.g.: http://myonto1.owl  or  file:/C://myonto1.owl  or  file:/usr/local/myonto1.owl\n\t2. IRI ontology 2. e.g.: http://myonto2.owl  or  file:/C://myonto2.owl  or  file:/usr/local/myonto2.owl\n\t3. Full output path for mapping files and overlapping modules/fragments. e.g. /usr/local/output_path/ or C://output_path/\n\t4. Classify the input ontologies together with the mappings. e.g. true or false";
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].toLowerCase().contains("help")) {
            System.out.println("HELP:\n" + LogMap2_Matcher.getHelpMessage());
            return;
        }
        if (args.length != 4) {
            System.out.println(LogMap2_Matcher.getHelpMessage());
            return;
        }
        String onto1 = args[0];
        String onto2 = args[1];
        String outputpath = args[2];
        boolean eval_impact = Boolean.valueOf(args[3]);
        new LogMap2_Matcher(onto1, onto2, outputpath, eval_impact);
    }
}

