/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.syntactic_locality;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLEntityCollector;
import uk.ac.manchester.syntactic_locality.SyntacticLocalityChecker;

public class ModuleExtractor {
    private OWLEntityCollector axiomSignatureCollector;
    private Set<OWLAxiom> ontologyAxioms;
    private OWLOntologyManager ontologyManager;
    private OWLOntology module;
    private SyntacticLocalityChecker localityChecker;
    private boolean considerAnnotations = false;
    private boolean considerImportsClosure = true;
    private boolean ignoreAssertions = false;
    private OWLDataFactory dataFactory;
    private Set<OWLAxiom> moduleAxioms;
    private Set<OWLEntity> moduleSignature = new HashSet<OWLEntity>();
    private List<OWLEntity> newMembers = new ArrayList<OWLEntity>();

    public ModuleExtractor(OWLOntology ontology, boolean dualConcepts, boolean dualRoles, boolean considerImportsClosure, boolean considerEntityAnnotations, boolean ignoreAssertions) {
        this.ontologyManager = OWLManager.createOWLOntologyManager();
        this.dataFactory = this.ontologyManager.getOWLDataFactory();
        this.ontologyAxioms = new HashSet<OWLAxiom>();
        this.moduleAxioms = new HashSet<OWLAxiom>();
        this.considerAnnotations = considerEntityAnnotations;
        this.considerImportsClosure = considerImportsClosure;
        this.ignoreAssertions = ignoreAssertions;
        this.indexOntology(ontology);
        this.setLocalityChecker(dualConcepts, dualRoles, considerEntityAnnotations, ignoreAssertions);
    }

    public ModuleExtractor(Set<OWLAxiom> ontoAxioms, boolean dualConcepts, boolean dualRoles, boolean considerImportsClosure, boolean considerEntityAnnotations, boolean ignoreAssertions) {
        this.ontologyManager = OWLManager.createOWLOntologyManager();
        this.dataFactory = this.ontologyManager.getOWLDataFactory();
        this.ontologyAxioms = ontoAxioms;
        this.moduleAxioms = new HashSet<OWLAxiom>();
        this.considerAnnotations = considerEntityAnnotations;
        this.considerImportsClosure = considerImportsClosure;
        this.ignoreAssertions = ignoreAssertions;
        this.setLocalityChecker(dualConcepts, dualRoles, considerEntityAnnotations, ignoreAssertions);
    }

    public ModuleExtractor(Set<OWLAxiom> ontoAxioms, OWLOntologyManager ontoManager, boolean dualConcepts, boolean dualRoles, boolean considerImportsClosure, boolean considerEntityAnnotations, boolean ignoreAssertions) {
        this.ontologyManager = ontoManager;
        this.dataFactory = this.ontologyManager.getOWLDataFactory();
        this.ontologyAxioms = ontoAxioms;
        this.moduleAxioms = new HashSet<OWLAxiom>();
        this.considerAnnotations = considerEntityAnnotations;
        this.considerImportsClosure = considerImportsClosure;
        this.ignoreAssertions = ignoreAssertions;
        this.setLocalityChecker(dualConcepts, dualRoles, considerEntityAnnotations, ignoreAssertions, this.ontologyManager.getOWLDataFactory());
    }

    public ModuleExtractor(OWLOntology ontology, boolean dualConcepts, boolean dualRoles) {
        this.ontologyManager = OWLManager.createOWLOntologyManager();
        this.ontologyAxioms = new HashSet<OWLAxiom>();
        this.moduleAxioms = new HashSet<OWLAxiom>();
        this.dataFactory = this.ontologyManager.getOWLDataFactory();
        this.indexOntology(ontology);
        this.setLocalityChecker(dualConcepts, dualRoles, false, true);
    }

    private void indexOntology(OWLOntology ontology) {
        if (this.considerImportsClosure) {
            try {
                this.indexImportedOntologies(this.ontologyManager.getImportsClosure(ontology));
            }
            catch (Exception e) {
                for (OWLAxiom ax : ontology.getAxioms()) {
                    if (!this.considerAnnotations && ax instanceof OWLAnnotationAxiom) continue;
                    this.ontologyAxioms.add(ax);
                }
            }
        } else {
            for (OWLAxiom ax : ontology.getAxioms()) {
                if (!this.considerAnnotations && ax instanceof OWLAnnotationAxiom) continue;
                this.ontologyAxioms.add(ax);
            }
        }
        System.out.println("Ontology Axioms: " + this.ontologyAxioms.size());
    }

    private void indexImportedOntologies(Set<OWLOntology> ontologies) {
        for (OWLOntology ontology : ontologies) {
            for (OWLAxiom ax : ontology.getAxioms()) {
                if (!this.considerAnnotations && ax instanceof OWLAnnotationAxiom) continue;
                this.ontologyAxioms.add(ax);
            }
        }
    }

    private void setLocalityChecker(boolean dualConcepts, boolean dualRoles, boolean considerEntityAnnotations, boolean ignoreAssertions, OWLDataFactory dataFactory) {
        this.localityChecker = new SyntacticLocalityChecker(dualConcepts, dualRoles, considerEntityAnnotations, ignoreAssertions, dataFactory);
    }

    private void setLocalityChecker(boolean dualConcepts, boolean dualRoles, boolean considerEntityAnnotations, boolean ignoreAssertions) {
        this.localityChecker = new SyntacticLocalityChecker(dualConcepts, dualRoles, considerEntityAnnotations, ignoreAssertions);
    }

    private Set<OWLEntity> getAxiomSignature(OWLAxiom ax) {
        return ax.getSignature();
    }

    public OWLOntology getLocalityModuleForSignatureGroup(Set<OWLEntity> signature) {
        return this.getLocalityModuleForSignatureGroup(signature, "http://krono.ac.uji.es/Links/ontologies/module" + new UID() + ".owl");
    }

    public OWLOntology getLocalityModuleForSignatureGroup(Set<OWLEntity> signature, String moduleURIStr) {
        return this.getLocalityModuleForSignatureGroup(signature, moduleURIStr, true);
    }

    public OWLOntology getLocalityModuleForSignatureGroup(Set<OWLEntity> signature, String moduleURIStr, boolean reInitManager) {
        long init = Calendar.getInstance().getTimeInMillis();
        this.moduleAxioms.clear();
        IRI moduleIRI = IRI.create((String)moduleURIStr.replace("\\", "//"));
        this.extractModuleAxiomsForGroupSignature(signature);
        long fin = Calendar.getInstance().getTimeInMillis();
        return this.getModuleFromAxioms(this.moduleAxioms, moduleIRI, reInitManager);
    }

    public OWLOntologyManager getOntoModuleManager() {
        return this.ontologyManager;
    }

    public OWLOntology getModuleFromAxioms(Set<OWLAxiom> moduleAxioms, IRI moduleIri) {
        return this.getModuleFromAxioms(moduleAxioms, moduleIri, true);
    }

    public OWLOntology getModuleFromAxioms(Set<OWLAxiom> moduleAxioms, IRI moduleIri, boolean reInitManager) {
        if (reInitManager) {
            this.ontologyManager = OWLManager.createOWLOntologyManager();
        }
        long init = Calendar.getInstance().getTimeInMillis();
        try {
            this.module = this.ontologyManager.createOntology(moduleIri);
            ArrayList<AddAxiom> ontoChanges = new ArrayList<AddAxiom>();
            for (OWLAxiom axiom : moduleAxioms) {
                ontoChanges.add(new AddAxiom(this.module, axiom));
            }
            this.ontologyManager.applyChanges(ontoChanges);
        }
        catch (Exception e) {
            System.out.println("Error creating module ontology from axioms.");
        }
        long fin = Calendar.getInstance().getTimeInMillis();
        return this.module;
    }

    public Set<OWLAxiom> extractModuleAxiomsForGroupSignature(Set<OWLEntity> signature) {
        this.moduleSignature = signature;
        this.moduleAxioms.clear();
        int previousSize = 0;
        for (OWLEntity ent : this.moduleSignature) {
            this.moduleAxioms.add((OWLAxiom)this.dataFactory.getOWLDeclarationAxiom(ent));
        }
        while (this.moduleSignature.size() != previousSize) {
            previousSize = this.moduleSignature.size();
            for (OWLAxiom ax : this.ontologyAxioms) {
                if (this.moduleAxioms.contains(ax) || this.localityChecker.isLocalAxiom(ax, this.moduleSignature)) continue;
                this.moduleAxioms.add(ax);
                for (OWLEntity newEnt : this.getAxiomSignature(ax)) {
                    if (this.moduleSignature.contains(newEnt) || newEnt.equals(this.Thing())) continue;
                    this.newMembers.add(newEnt);
                }
            }
            this.moduleSignature.addAll(this.newMembers);
            this.newMembers.clear();
        }
        return this.moduleAxioms;
    }

    public Set<OWLEntity> extractModuleEntitiesForGroupSignature(Set<OWLEntity> signature) {
        this.moduleSignature = signature;
        int previousSize = 0;
        while (this.moduleSignature.size() != previousSize) {
            previousSize = this.moduleSignature.size();
            for (OWLAxiom ax : this.ontologyAxioms) {
                if (this.localityChecker.isLocalAxiom(ax, this.moduleSignature)) continue;
                for (OWLEntity newEnt : this.getAxiomSignature(ax)) {
                    if (this.moduleSignature.contains(newEnt) || newEnt.equals(this.Thing())) continue;
                    this.newMembers.add(newEnt);
                }
            }
            this.moduleSignature.addAll(this.newMembers);
            this.newMembers.clear();
        }
        return this.moduleSignature;
    }

    public Set<OWLEntity> extractModuleEntitiesForEntity(OWLEntity entity) {
        this.moduleSignature.clear();
        this.moduleSignature.add(entity);
        int previousSize = 0;
        while (this.moduleSignature.size() != previousSize) {
            previousSize = this.moduleSignature.size();
            for (OWLAxiom ax : this.ontologyAxioms) {
                if (this.localityChecker.isLocalAxiom(ax, this.moduleSignature)) continue;
                for (OWLEntity newEnt : this.getAxiomSignature(ax)) {
                    if (this.moduleSignature.contains(newEnt) || newEnt.equals(this.Thing())) continue;
                    this.newMembers.add(newEnt);
                }
            }
            this.moduleSignature.addAll(this.newMembers);
            this.newMembers.clear();
        }
        return this.moduleSignature;
    }

    public Set<OWLAxiom> extractModuleAxiomsForEntity(OWLEntity entity) {
        this.moduleSignature.clear();
        this.moduleAxioms.clear();
        this.moduleSignature.add(entity);
        int previousSize = 0;
        for (OWLEntity ent : this.moduleSignature) {
            this.moduleAxioms.add((OWLAxiom)this.dataFactory.getOWLDeclarationAxiom(ent));
        }
        while (this.moduleSignature.size() != previousSize) {
            previousSize = this.moduleSignature.size();
            for (OWLAxiom ax : this.ontologyAxioms) {
                if (this.moduleAxioms.contains(ax) || this.localityChecker.isLocalAxiom(ax, this.moduleSignature)) continue;
                this.moduleAxioms.add(ax);
                for (OWLEntity newEnt : this.getAxiomSignature(ax)) {
                    if (this.moduleSignature.contains(newEnt) || newEnt.equals(this.Thing())) continue;
                    this.newMembers.add(newEnt);
                }
            }
            this.moduleSignature.addAll(this.newMembers);
            this.newMembers.clear();
        }
        return this.moduleAxioms;
    }

    public void saveExtractedModule(String physicalModuleURI) {
        try {
            this.ontologyManager.saveOntology(this.module, (OWLDocumentFormat)new RDFXMLDocumentFormat(), IRI.create((String)physicalModuleURI));
        }
        catch (Exception e) {
            System.err.println("Error saving module\n" + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public void clearStrutures() {
        this.ontologyAxioms.clear();
        this.moduleAxioms.clear();
        this.newMembers.clear();
    }

    private OWLClass Thing() {
        return this.ontologyManager.getOWLDataFactory().getOWLThing();
    }
}

