/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.AbstractAxiomLoader;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.owlapi.OwlOntologyChangeProcessorVisitor;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class OwlChangesLoader
extends AbstractAxiomLoader
implements AxiomLoader {
    private static final Logger LOGGER_ = Logger.getLogger(OwlChangesLoader.class);
    private final ProgressMonitor progressMonitor;
    private final LinkedList<OWLOntologyChange> pendingChanges_;

    OwlChangesLoader(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        this.pendingChanges_ = new LinkedList();
    }

    public synchronized void load(ElkAxiomProcessor axiomInserter, ElkAxiomProcessor axiomDeleter) throws ElkLoadingException {
        if (!this.pendingChanges_.isEmpty()) {
            OWLOntologyChange change;
            String status = "Loading of Changes";
            this.progressMonitor.start(status);
            int changesCount = this.pendingChanges_.size();
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)(status + ": " + changesCount));
            }
            int currentAxiom = 0;
            while (!this.isInterrupted() && (change = this.pendingChanges_.poll()) != null) {
                if (!change.isAxiomChange()) {
                    ElkLoadingException exception = new ElkLoadingException("Cannot apply non-axiom change!");
                    LOGGER_.error((Object)exception);
                    throw exception;
                }
                ElkLoadingException error = (ElkLoadingException)change.accept((OWLOntologyChangeVisitorEx)new OwlOntologyChangeProcessorVisitor(axiomInserter, axiomDeleter));
                if (error != null) {
                    LOGGER_.error((Object)error);
                    throw error;
                }
                this.progressMonitor.report(++currentAxiom, changesCount);
            }
            this.progressMonitor.finish();
        }
    }

    public synchronized boolean isLoadingFinished() {
        return this.pendingChanges_.isEmpty();
    }

    synchronized void registerChange(OWLOntologyChange change) {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)("Registering change: " + change));
        }
        this.pendingChanges_.add(change);
    }

    Set<OWLAxiom> getPendingAxiomAdditions() {
        HashSet<OWLAxiom> added = new HashSet<OWLAxiom>();
        for (OWLOntologyChange change : this.pendingChanges_) {
            if (!(change instanceof AddAxiom)) continue;
            added.add(change.getAxiom());
        }
        return added;
    }

    Set<OWLAxiom> getPendingAxiomRemovals() {
        HashSet<OWLAxiom> removed = new HashSet<OWLAxiom>();
        for (OWLOntologyChange change : this.pendingChanges_) {
            if (!(change instanceof RemoveAxiom)) continue;
            removed.add(change.getAxiom());
        }
        return removed;
    }

    List<OWLOntologyChange> getPendingChanges() {
        return this.pendingChanges_;
    }
}

