/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.ComposedAxiomLoader;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.predefined.PredefinedElkClass;
import org.semanticweb.elk.reasoner.ElkInconsistentOntologyException;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.DifferentialIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectCache;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStateFactory;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.reasoner.stages.ClassTaxonomyState;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.stages.InstanceTaxonomyState;
import org.semanticweb.elk.reasoner.stages.ReasonerStage;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.stages.ReasonerStageManager;
import org.semanticweb.elk.reasoner.taxonomy.ConcurrentClassTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.ConcurrentInstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.OrphanInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.OrphanNode;
import org.semanticweb.elk.reasoner.taxonomy.OrphanTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.SingletoneInstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.SingletoneTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.util.collections.ArrayHashMap;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.concurrent.computation.ComputationExecutor;
import org.semanticweb.elk.util.concurrent.computation.SimpleInterrupter;

public abstract class AbstractReasonerState
extends SimpleInterrupter {
    private static final Logger LOGGER_ = Logger.getLogger(AbstractReasonerState.class);
    final SaturationState saturationState;
    final SaturationStatistics ruleAndConclusionStats;
    final IndexedObjectCache objectCache_;
    final DifferentialIndex ontologyIndex;
    boolean inconsistentOntology = false;
    final ClassTaxonomyState classTaxonomyState = new ClassTaxonomyState();
    final ReasonerStageManager stageManager;
    final InstanceTaxonomyState instanceTaxonomyState = new InstanceTaxonomyState();
    private AxiomLoader axiomLoader_;
    private boolean allowIncrementalMode_ = true;
    private boolean allowIncrementalTaxonomy_ = true;

    protected AbstractReasonerState() {
        this.objectCache_ = new IndexedObjectCache();
        this.ontologyIndex = new DifferentialIndex(this.objectCache_);
        this.saturationState = SaturationStateFactory.createSaturationState(this.ontologyIndex);
        this.ruleAndConclusionStats = new SaturationStatistics();
        this.stageManager = new ReasonerStageManager(this);
    }

    protected AbstractReasonerState(AxiomLoader axiomLoader) {
        this();
        this.registerAxiomLoader(axiomLoader);
    }

    protected void complete(ReasonerStage stage) throws ElkException {
        try {
            this.getStageExecutor().complete(stage);
        }
        catch (ElkInterruptedException e) {
            this.setInterrupt(false);
            throw e;
        }
    }

    public synchronized void setAllowIncrementalMode(boolean allow) {
        if (this.allowIncrementalMode_ == allow) {
            return;
        }
        this.allowIncrementalMode_ = allow;
        if (!allow) {
            this.setNonIncrementalMode();
        }
        this.setAllowIncrementalTaxonomy(allow);
        if (LOGGER_.isInfoEnabled()) {
            LOGGER_.info((Object)("Incremental mode is " + (allow ? "allowed" : "disallowed")));
        }
    }

    public synchronized boolean isAllowIncrementalMode() {
        return this.allowIncrementalMode_;
    }

    public synchronized boolean isIncrementalMode() {
        return this.ontologyIndex.isIncrementalMode();
    }

    void setNonIncrementalMode() {
        this.ontologyIndex.setIncrementalMode(false);
        this.setAllowIncrementalTaxonomy(false);
    }

    boolean trySetIncrementalMode() {
        if (!this.allowIncrementalMode_) {
            return false;
        }
        this.ontologyIndex.setIncrementalMode(true);
        return true;
    }

    public synchronized void resetAxiomLoading() {
        LOGGER_.trace((Object)"Reset axiom loading");
        this.stageManager.axiomLoadingStage.invalidate();
        this.stageManager.incrementalCompletionStage.invalidate();
    }

    public synchronized void resetPropertySaturation() {
        LOGGER_.trace((Object)"Reset property saturation");
        this.stageManager.propertyInitializationStage.invalidate();
    }

    public synchronized void registerAxiomLoader(AxiomLoader newAxiomLoader) {
        LOGGER_.trace((Object)"Registering new axiom loader");
        this.resetAxiomLoading();
        this.axiomLoader_ = this.axiomLoader_ == null || this.axiomLoader_.isLoadingFinished() ? newAxiomLoader : new ComposedAxiomLoader(this.axiomLoader_, newAxiomLoader);
    }

    public AxiomLoader getAxiomLoader() {
        return this.axiomLoader_;
    }

    public void forceLoading() throws ElkException {
        this.loadAxioms();
    }

    protected abstract int getNumberOfWorkers();

    protected abstract ReasonerStageExecutor getStageExecutor();

    protected abstract ComputationExecutor getProcessExecutor();

    protected abstract ProgressMonitor getProgressMonitor();

    protected ModifiableOntologyIndex getModifiableOntologyIndex() {
        return this.ontologyIndex;
    }

    public void interrupt() {
        LOGGER_.info((Object)"Interrupt requested");
        this.setInterrupt(true);
    }

    public synchronized boolean isInconsistent() throws ElkException {
        this.ruleAndConclusionStats.reset();
        this.loadAxioms();
        if (this.isIncrementalMode() && !this.saturationState.getContexts().isEmpty()) {
            this.complete(this.stageManager.incrementalConsistencyCheckingStage);
        } else {
            this.setNonIncrementalMode();
            this.complete(this.stageManager.consistencyCheckingStage);
            this.stageManager.incrementalConsistencyCheckingStage.setCompleted();
        }
        return this.inconsistentOntology;
    }

    void loadAxioms() throws ElkException {
        if (this.classTaxonomyState.getTaxonomy() != null) {
            this.trySetIncrementalMode();
        }
        this.complete(this.stageManager.axiomLoadingStage);
    }

    public synchronized Taxonomy<ElkClass> getTaxonomy() throws ElkInconsistentOntologyException, ElkException {
        this.ruleAndConclusionStats.reset();
        if (this.isInconsistent()) {
            throw new ElkInconsistentOntologyException();
        }
        if (this.isIncrementalMode() && this.classTaxonomyState.getTaxonomy() != null) {
            this.complete(this.stageManager.incrementalClassTaxonomyComputationStage);
        } else {
            this.setNonIncrementalMode();
            this.complete(this.stageManager.classTaxonomyComputationStage);
            this.stageManager.incrementalClassTaxonomyComputationStage.setCompleted();
        }
        return this.classTaxonomyState.getTaxonomy();
    }

    public synchronized Taxonomy<ElkClass> getTaxonomyQuietly() throws ElkException {
        Taxonomy<ElkClass> result;
        try {
            result = this.getTaxonomy();
        }
        catch (ElkInconsistentOntologyException e) {
            LOGGER_.info((Object)"Ontology is inconsistent");
            OrphanNode<PredefinedElkClass> node = new OrphanNode<PredefinedElkClass>(this.getAllClasses(), PredefinedElkClass.OWL_NOTHING);
            result = new SingletoneTaxonomy<ElkClass, OrphanNode<PredefinedElkClass>>(node);
        }
        return result;
    }

    public synchronized InstanceTaxonomy<ElkClass, ElkNamedIndividual> getInstanceTaxonomy() throws ElkException {
        this.ruleAndConclusionStats.reset();
        if (this.isInconsistent()) {
            throw new ElkInconsistentOntologyException();
        }
        if (this.isIncrementalMode() && this.instanceTaxonomyState.getTaxonomy() != null) {
            this.complete(this.stageManager.incrementalInstanceTaxonomyComputationStage);
        } else {
            this.setNonIncrementalMode();
            this.complete(this.stageManager.instanceTaxonomyComputationStage);
            this.stageManager.incrementalInstanceTaxonomyComputationStage.setCompleted();
        }
        return this.instanceTaxonomyState.getTaxonomy();
    }

    public synchronized InstanceTaxonomy<ElkClass, ElkNamedIndividual> getInstanceTaxonomyQuietly() throws ElkException {
        InstanceTaxonomy<ElkClass, ElkNamedIndividual> result;
        try {
            result = this.getInstanceTaxonomy();
        }
        catch (ElkInconsistentOntologyException e) {
            LOGGER_.info((Object)"Ontology is inconsistent");
            OrphanTypeNode<PredefinedElkClass, ElkObject> node = new OrphanTypeNode<PredefinedElkClass, ElkObject>(this.getAllClasses(), PredefinedElkClass.OWL_NOTHING, 1);
            Set<ElkNamedIndividual> allNamedIndividuals = this.getAllNamedIndividuals();
            Iterator<ElkNamedIndividual> namedIndividualIterator = allNamedIndividuals.iterator();
            if (namedIndividualIterator.hasNext()) {
                node.addInstanceNode(new OrphanInstanceNode<PredefinedElkClass, ElkObject>(allNamedIndividuals, (ElkObject)namedIndividualIterator.next(), node));
            }
            result = new SingletoneInstanceTaxonomy<ElkClass, ElkNamedIndividual, OrphanTypeNode<PredefinedElkClass, ElkNamedIndividual>>(node);
        }
        return result;
    }

    public synchronized Set<ElkClass> getAllClasses() {
        ArrayHashSet result = new ArrayHashSet(this.ontologyIndex.getIndexedClasses().size());
        for (IndexedClass ic : this.ontologyIndex.getIndexedClasses()) {
            result.add(ic.getElkClass());
        }
        return result;
    }

    public synchronized Set<ElkNamedIndividual> getAllNamedIndividuals() {
        ArrayHashSet allNamedIndividuals = new ArrayHashSet(this.ontologyIndex.getIndexedClasses().size());
        for (IndexedIndividual ii : this.ontologyIndex.getIndexedIndividuals()) {
            allNamedIndividuals.add(ii.getElkNamedIndividual());
        }
        return allNamedIndividuals;
    }

    public synchronized Map<IndexedClassExpression, Context> getContextMap() {
        ArrayHashMap result = new ArrayHashMap(1024);
        for (IndexedClassExpression ice : this.ontologyIndex.getIndexedClassExpressions()) {
            Context context = ice.getContext();
            if (context == null) continue;
            result.put(ice, context);
        }
        return result;
    }

    public synchronized Map<IndexedPropertyChain, SaturatedPropertyChain> getPropertySaturationMap() {
        ArrayHashMap result = new ArrayHashMap(256);
        for (IndexedPropertyChain ipc : this.ontologyIndex.getIndexedPropertyChains()) {
            SaturatedPropertyChain saturation = ipc.getSaturated();
            if (saturation == null) continue;
            result.put(ipc, saturation);
        }
        return result;
    }

    public synchronized boolean doneConsistencyCheck() {
        return this.stageManager.consistencyCheckingStage.isCompleted;
    }

    public synchronized boolean doneTaxonomy() {
        return this.stageManager.classTaxonomyComputationStage.isCompleted || this.stageManager.incrementalClassTaxonomyComputationStage.isCompleted;
    }

    public synchronized boolean doneInstanceTaxonomy() {
        return this.stageManager.instanceTaxonomyComputationStage.isCompleted;
    }

    public void setInterrupt(boolean flag) {
        super.setInterrupt(flag);
        ReasonerStageExecutor stageExecutor = this.getStageExecutor();
        if (stageExecutor != null) {
            stageExecutor.setInterrupt(flag);
        }
    }

    protected OntologyIndex getOntologyIndex() throws ElkException {
        this.loadAxioms();
        return this.ontologyIndex;
    }

    protected boolean setAllowIncrementalTaxonomy(boolean flag) {
        if (!flag) {
            this.allowIncrementalTaxonomy_ = false;
        } else if (this.allowIncrementalMode_) {
            this.allowIncrementalTaxonomy_ = true;
        } else {
            return false;
        }
        return true;
    }

    protected boolean useIncrementalTaxonomy() {
        return this.allowIncrementalTaxonomy_;
    }

    public synchronized void initClassTaxonomy() {
        this.classTaxonomyState.getWriter().setTaxonomy(new ConcurrentClassTaxonomy());
    }

    public synchronized void initInstanceTaxonomy() {
        this.instanceTaxonomyState.initTaxonomy(new ConcurrentInstanceTaxonomy(this.classTaxonomyState.getTaxonomy()));
    }

    public synchronized Collection<IndexedClassExpression> getIndexedClassExpressions() {
        return this.ontologyIndex.getIndexedClassExpressions();
    }
}

