/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.rules;

import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.ContextCreationListener;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationUtils;
import org.semanticweb.elk.reasoner.saturation.conclusions.Conclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.RuleDeapplicationFactory;

public class ContextCleaningFactory
extends RuleDeapplicationFactory {
    public ContextCleaningFactory(SaturationState saturationState) {
        super(saturationState, false);
    }

    @Override
    public RuleDeapplicationFactory.DeapplicationEngine getDefaultEngine(ContextCreationListener listener, ContextModificationListener modificationListener) {
        return new CleaningEngine();
    }

    private static class SaturationCheckingWriter
    implements BasicSaturationStateWriter {
        private final BasicSaturationStateWriter writer_;

        SaturationCheckingWriter(BasicSaturationStateWriter writer) {
            this.writer_ = writer;
        }

        @Override
        public void produce(Context context, Conclusion conclusion) {
            Context sourceContext = conclusion.getSourceContext(context);
            if (sourceContext == null || !sourceContext.isSaturated()) {
                this.writer_.produce(context, conclusion);
            }
        }

        @Override
        public IndexedClassExpression getOwlThing() {
            return this.writer_.getOwlThing();
        }

        @Override
        public IndexedClassExpression getOwlNothing() {
            return this.writer_.getOwlNothing();
        }

        @Override
        public Context pollForActiveContext() {
            return this.writer_.pollForActiveContext();
        }

        @Override
        public boolean markAsNotSaturated(Context context) {
            return this.writer_.markAsNotSaturated(context);
        }

        @Override
        public void clearNotSaturatedContexts() {
            this.writer_.clearNotSaturatedContexts();
        }

        @Override
        public void resetContexts() {
            this.writer_.resetContexts();
        }
    }

    public class CleaningEngine
    extends RuleDeapplicationFactory.DeapplicationEngine {
        protected CleaningEngine() {
            super(ContextCleaningFactory.this, ContextModificationListener.DUMMY);
        }

        @Override
        protected BasicSaturationStateWriter getSaturationStateWriter() {
            ConclusionVisitor<?> visitor = SaturationUtils.addStatsToConclusionVisitor(this.localStatistics.getConclusionStatistics());
            BasicSaturationStateWriter writer = ContextCleaningFactory.this.saturationState.getWriter(ContextModificationListener.DUMMY, visitor);
            return new SaturationCheckingWriter(writer);
        }
    }
}

