/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.OntologyIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.ContextCreationListener;
import org.semanticweb.elk.reasoner.saturation.ContextImpl;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.ExtendedSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationUtils;
import org.semanticweb.elk.reasoner.saturation.conclusions.Conclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.BasicCompositionRuleApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;

class SaturationStateImpl
implements SaturationState {
    private static final Logger LOGGER_ = Logger.getLogger(SaturationStateImpl.class);
    private final OntologyIndex ontologyIndex_;
    private final IndexedClassExpression owlThing_;
    private final IndexedClassExpression owlNothing_;
    private ContextImpl firstContext;
    private final Queue<Context> activeContexts_ = new ConcurrentLinkedQueue<Context>();
    private final Queue<IndexedClassExpression> notSaturatedContexts_ = new ConcurrentLinkedQueue<IndexedClassExpression>();
    private static final RuleApplicationVisitor DEFAULT_INIT_RULE_APP_VISITOR = new BasicCompositionRuleApplicationVisitor();

    @Override
    public Collection<Context> getContexts() {
        return new AbstractCollection<Context>(){

            @Override
            public Iterator<Context> iterator() {
                return new Iterator<Context>(){
                    ContextImpl next;
                    {
                        this.next = ((SaturationStateImpl)SaturationStateImpl.this).firstContext.next;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public Context next() {
                        if (this.next == null) {
                            throw new NoSuchElementException("No next context");
                        }
                        ContextImpl result = this.next;
                        this.next = this.next.next;
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removal not supported");
                    }
                };
            }

            @Override
            public boolean isEmpty() {
                return ((SaturationStateImpl)SaturationStateImpl.this).firstContext.next == null;
            }

            @Override
            public int size() {
                return 0;
            }
        };
    }

    private void resetFirstContext() {
        this.firstContext = new ContextImpl(null);
    }

    @Override
    public Collection<IndexedClassExpression> getNotSaturatedContexts() {
        return this.notSaturatedContexts_;
    }

    public SaturationStateImpl(OntologyIndex index) {
        this.ontologyIndex_ = index;
        this.owlThing_ = index.getIndexedOwlThing();
        this.owlNothing_ = index.getIndexedOwlNothing();
        this.resetFirstContext();
    }

    @Override
    public OntologyIndex getOntologyIndex() {
        return this.ontologyIndex_;
    }

    @Override
    public Context getContext(IndexedClassExpression ice) {
        return ice.getContext();
    }

    private ExtendedSaturationStateWriter getDefaultWriter(ConclusionVisitor<?> conclusionVisitor) {
        return new ContextCreatingWriter(ContextCreationListener.DUMMY, ContextModificationListener.DUMMY, DEFAULT_INIT_RULE_APP_VISITOR, conclusionVisitor, true);
    }

    @Override
    public BasicSaturationStateWriter getWriter(ConclusionVisitor<?> conclusionVisitor) {
        return this.getDefaultWriter(conclusionVisitor);
    }

    @Override
    public ExtendedSaturationStateWriter getExtendedWriter(ConclusionVisitor<?> conclusionVisitor) {
        return this.getDefaultWriter(conclusionVisitor);
    }

    @Override
    public ExtendedSaturationStateWriter getExtendedWriter(ContextCreationListener contextCreationListener, ContextModificationListener contextModificationListener, RuleApplicationVisitor ruleAppVisitor, ConclusionVisitor<?> conclusionVisitor, boolean trackNewContextsAsUnsaturated) {
        return new ContextCreatingWriter(contextCreationListener, contextModificationListener, ruleAppVisitor, conclusionVisitor, trackNewContextsAsUnsaturated);
    }

    @Override
    public BasicSaturationStateWriter getWriter(ContextModificationListener contextModificationListener, ConclusionVisitor<?> conclusionVisitor) {
        return new BasicWriter(contextModificationListener, conclusionVisitor);
    }

    class ContextCreatingWriter
    extends BasicWriter
    implements ExtendedSaturationStateWriter {
        private final RuleApplicationVisitor initRuleAppVisitor_;
        private final boolean trackNewContextsAsUnsaturated_;
        private final ContextCreationListener contextCreationListener_;

        private ContextCreatingWriter(ContextCreationListener contextCreationListener, ContextModificationListener contextModificationListener, RuleApplicationVisitor ruleAppVisitor, ConclusionVisitor<?> conclusionVisitor, boolean trackNewContextsAsUnsaturated) {
            super(contextModificationListener, conclusionVisitor);
            this.contextCreationListener_ = contextCreationListener;
            this.initRuleAppVisitor_ = ruleAppVisitor;
            this.trackNewContextsAsUnsaturated_ = trackNewContextsAsUnsaturated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Context getCreateContext(IndexedClassExpression root) {
            Context context = root.getContext();
            if (context != null) {
                return context;
            }
            ContextImpl newContext = new ContextImpl(root);
            if (!root.setContext(newContext)) {
                return root.getContext();
            }
            this.initContext(newContext);
            this.contextCreationListener_.notifyContextCreation(newContext);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)(newContext.getRoot() + ": context created"));
            }
            if (this.trackNewContextsAsUnsaturated_) {
                this.markAsNotSaturatedInternal(newContext);
            }
            ContextImpl contextImpl = SaturationStateImpl.this.firstContext;
            synchronized (contextImpl) {
                ContextImpl oldHead = ((SaturationStateImpl)SaturationStateImpl.this).firstContext.next;
                ((SaturationStateImpl)SaturationStateImpl.this).firstContext.next = newContext;
                newContext.previous = SaturationStateImpl.this.firstContext;
                if (oldHead != null) {
                    newContext.next = oldHead;
                    oldHead.previous = newContext;
                }
            }
            return newContext;
        }

        @Override
        public void initContext(Context context) {
            SaturationUtils.initContext(context, this, SaturationStateImpl.this.ontologyIndex_, this.initRuleAppVisitor_);
        }

        @Override
        public void removeContext(Context context) {
        }
    }

    class BasicWriter
    implements BasicSaturationStateWriter {
        private final ConclusionVisitor<?> producedConclusionVisitor_;
        private final ContextModificationListener contextModificationListener_;

        private BasicWriter(ContextModificationListener contextSaturationListener, ConclusionVisitor<?> conclusionVisitor) {
            this.contextModificationListener_ = contextSaturationListener;
            this.producedConclusionVisitor_ = conclusionVisitor;
        }

        @Override
        public IndexedClassExpression getOwlThing() {
            return SaturationStateImpl.this.owlThing_;
        }

        @Override
        public IndexedClassExpression getOwlNothing() {
            return SaturationStateImpl.this.owlNothing_;
        }

        @Override
        public Context pollForActiveContext() {
            return (Context)SaturationStateImpl.this.activeContexts_.poll();
        }

        @Override
        public void produce(Context context, Conclusion conclusion) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)(context + ": produced conclusion " + conclusion));
            }
            conclusion.accept(this.producedConclusionVisitor_, context);
            if (context.addToDo(conclusion)) {
                SaturationStateImpl.this.activeContexts_.add(context);
            }
        }

        protected void markAsNotSaturatedInternal(Context context) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)(context + ": marked as non-saturated"));
            }
            SaturationStateImpl.this.notSaturatedContexts_.add(context.getRoot());
            this.contextModificationListener_.notifyContextModification(context);
        }

        @Override
        public boolean markAsNotSaturated(Context context) {
            if (context.setSaturated(false)) {
                this.markAsNotSaturatedInternal(context);
                return true;
            }
            return false;
        }

        @Override
        public void clearNotSaturatedContexts() {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)"Clear non-saturated contexts");
            }
            SaturationStateImpl.this.notSaturatedContexts_.clear();
        }

        @Override
        public void resetContexts() {
            SaturationStateImpl.this.resetFirstContext();
        }
    }
}

