/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionVisitor;
import org.semanticweb.elk.owl.visitors.ElkIndividualVisitor;
import org.semanticweb.elk.owl.visitors.ElkSubObjectPropertyExpressionVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.AbstractElkAxiomIndexerVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkAxiomIndexingVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexObjectConverter;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexObjectConverterFactory;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedAxiom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedDataHasValue;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedDisjointnessAxiom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectCache;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectComplementOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectIntersectionOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectUnionOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedSubClassOfAxiom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedAxiomFilter;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassExpressionFilter;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainFilter;

public class MainAxiomIndexerVisitor
extends AbstractElkAxiomIndexerVisitor
implements ElkAxiomIndexingVisitor {
    private final ModifiableOntologyIndex index_;
    private final IndexedObjectCache objectCache_;
    private final int multiplicity_;
    private final IndexObjectConverter neutralIndexer;
    private final IndexObjectConverter positiveIndexer;
    private final IndexObjectConverter negativeIndexer;
    private final IndexedAxiomFilter axiomUpdateFilter;
    private final IndexedClass owlNothing_;

    public MainAxiomIndexerVisitor(ModifiableOntologyIndex index, boolean insert) {
        this.index_ = index;
        this.objectCache_ = index.getIndexedObjectCache();
        this.owlNothing_ = index.getIndexedOwlNothing();
        this.multiplicity_ = insert ? 1 : -1;
        final PropertyOccurrenceUpdateFilter propertyOccurrenceUpdateFilter = new PropertyOccurrenceUpdateFilter(this.multiplicity_);
        this.neutralIndexer = new IndexObjectConverter(new ClassOccurrenceUpdateFilter(this.multiplicity_, 0, 0), propertyOccurrenceUpdateFilter);
        IndexObjectConverterFactory negativeIndexerFactory = new IndexObjectConverterFactory(){

            @Override
            public IndexObjectConverter create(IndexObjectConverter complementary) {
                return new IndexObjectConverter((IndexedClassExpressionFilter)new ClassOccurrenceUpdateFilter(MainAxiomIndexerVisitor.this.multiplicity_, 0, MainAxiomIndexerVisitor.this.multiplicity_), propertyOccurrenceUpdateFilter, complementary);
            }
        };
        this.positiveIndexer = new IndexObjectConverter((IndexedClassExpressionFilter)new ClassOccurrenceUpdateFilter(this.multiplicity_, this.multiplicity_, 0), (IndexedPropertyChainFilter)propertyOccurrenceUpdateFilter, negativeIndexerFactory);
        this.negativeIndexer = this.positiveIndexer.getComplementaryConverter();
        this.axiomUpdateFilter = new AxiomOccurrenceUpdateFilter(this.multiplicity_);
    }

    @Override
    public int getMultiplicity() {
        return this.multiplicity_;
    }

    @Override
    public void indexSubClassOfAxiom(ElkClassExpression subElkClass, ElkClassExpression superElkClass) {
        IndexedClassExpression subIndexedClass = (IndexedClassExpression)subElkClass.accept((ElkClassExpressionVisitor)this.negativeIndexer);
        IndexedClassExpression superIndexedClass = (IndexedClassExpression)superElkClass.accept((ElkClassExpressionVisitor)this.positiveIndexer);
        this.axiomUpdateFilter.visit(new IndexedSubClassOfAxiom(subIndexedClass, superIndexedClass));
    }

    @Override
    public void indexClassAssertion(ElkIndividual individual, ElkClassExpression type) {
        IndexedClassExpression indexedIndividual = (IndexedClassExpression)individual.accept((ElkIndividualVisitor)this.negativeIndexer);
        IndexedClassExpression indexedType = (IndexedClassExpression)type.accept((ElkClassExpressionVisitor)this.positiveIndexer);
        this.axiomUpdateFilter.visit(new IndexedSubClassOfAxiom(indexedIndividual, indexedType));
    }

    @Override
    public void indexSubObjectPropertyOfAxiom(ElkSubObjectPropertyExpression subElkProperty, ElkObjectPropertyExpression superElkProperty) {
        IndexedPropertyChain subIndexedProperty = (IndexedPropertyChain)subElkProperty.accept((ElkSubObjectPropertyExpressionVisitor)this.negativeIndexer);
        IndexedObjectProperty superIndexedProperty = (IndexedObjectProperty)superElkProperty.accept((ElkSubObjectPropertyExpressionVisitor)this.positiveIndexer);
        if (this.multiplicity_ == 1) {
            subIndexedProperty.addToldSuperObjectProperty(superIndexedProperty);
            superIndexedProperty.addToldSubPropertyChain(subIndexedProperty);
        } else {
            subIndexedProperty.removeToldSuperObjectProperty(superIndexedProperty);
            superIndexedProperty.removeToldSubObjectProperty(subIndexedProperty);
        }
    }

    @Override
    public void indexDisjointClassExpressions(List<? extends ElkClassExpression> disjointClasses) {
        if (this.owlNothing_ == null) {
            throw new NullPointerException("owlNothing not provided!");
        }
        if (this.index_ == null) {
            throw new NullPointerException("indexUpdater not provided!");
        }
        this.owlNothing_.updateAndCheckOccurrenceNumbers(this.index_, this.multiplicity_, this.multiplicity_, 0);
        ArrayList<IndexedClassExpression> indexed = new ArrayList<IndexedClassExpression>(disjointClasses.size());
        for (ElkClassExpression elkClassExpression : disjointClasses) {
            indexed.add((IndexedClassExpression)elkClassExpression.accept((ElkClassExpressionVisitor)this.negativeIndexer));
        }
        this.axiomUpdateFilter.visit(new IndexedDisjointnessAxiom(indexed));
    }

    @Override
    public void indexReflexiveObjectProperty(ElkObjectPropertyExpression reflexiveProperty) {
        IndexedObjectProperty indexedReflexiveProperty = (IndexedObjectProperty)reflexiveProperty.accept((ElkSubObjectPropertyExpressionVisitor)this.positiveIndexer);
        if (indexedReflexiveProperty.reflexiveAxiomOccurrenceNo == 0 && this.multiplicity_ > 0) {
            this.index_.addReflexiveProperty(indexedReflexiveProperty);
        }
        indexedReflexiveProperty.reflexiveAxiomOccurrenceNo += this.multiplicity_;
        if (indexedReflexiveProperty.reflexiveAxiomOccurrenceNo == 0 && this.multiplicity_ < 0) {
            this.index_.removeReflexiveProperty(indexedReflexiveProperty);
        }
    }

    @Override
    public IndexedClass indexClassDeclaration(ElkClass ec) {
        return (IndexedClass)ec.accept((ElkClassExpressionVisitor)this.neutralIndexer);
    }

    @Override
    public IndexedObjectProperty indexObjectPropertyDeclaration(ElkObjectProperty ep) {
        return (IndexedObjectProperty)ep.accept((ElkSubObjectPropertyExpressionVisitor)this.neutralIndexer);
    }

    @Override
    public IndexedIndividual indexNamedIndividualDeclaration(ElkNamedIndividual eni) {
        return (IndexedIndividual)eni.accept((ElkIndividualVisitor)this.neutralIndexer);
    }

    private class AxiomOccurrenceUpdateFilter
    implements IndexedAxiomFilter {
        protected final int increment;

        AxiomOccurrenceUpdateFilter(int increment) {
            this.increment = increment;
        }

        public <T extends IndexedAxiom> T update(T axiom) {
            if (!axiom.occurs() && this.increment > 0) {
                MainAxiomIndexerVisitor.this.index_.add(axiom);
            }
            axiom.updateOccurrenceNumbers(MainAxiomIndexerVisitor.this.index_, this.increment);
            if (!axiom.occurs() && this.increment < 0) {
                MainAxiomIndexerVisitor.this.index_.remove(axiom);
            }
            return axiom;
        }

        @Override
        public IndexedSubClassOfAxiom visit(IndexedSubClassOfAxiom axiom) {
            return this.update(MainAxiomIndexerVisitor.this.objectCache_.visit(axiom));
        }

        @Override
        public IndexedDisjointnessAxiom visit(IndexedDisjointnessAxiom axiom) {
            return this.update(MainAxiomIndexerVisitor.this.objectCache_.visit(axiom));
        }
    }

    private class PropertyOccurrenceUpdateFilter
    implements IndexedPropertyChainFilter {
        protected final int increment;

        PropertyOccurrenceUpdateFilter(int increment) {
            this.increment = increment;
        }

        public <T extends IndexedPropertyChain> T update(T ipc) {
            if (!ipc.occurs() && this.increment > 0) {
                MainAxiomIndexerVisitor.this.index_.add(ipc);
            }
            ipc.updateAndCheckOccurrenceNumbers(this.increment);
            if (!ipc.occurs() && this.increment < 0) {
                MainAxiomIndexerVisitor.this.index_.remove(ipc);
            }
            return ipc;
        }

        @Override
        public IndexedObjectProperty visit(IndexedObjectProperty element) {
            return this.update(MainAxiomIndexerVisitor.this.objectCache_.visit(element));
        }

        @Override
        public IndexedBinaryPropertyChain visit(IndexedBinaryPropertyChain element) {
            return this.update(MainAxiomIndexerVisitor.this.objectCache_.visit(element));
        }
    }

    private class ClassOccurrenceUpdateFilter
    implements IndexedClassExpressionFilter {
        protected final int increment;
        protected final int positiveIncrement;
        protected final int negativeIncrement;

        ClassOccurrenceUpdateFilter(int increment, int positiveIncrement, int negativeIncrement) {
            this.increment = increment;
            this.positiveIncrement = positiveIncrement;
            this.negativeIncrement = negativeIncrement;
        }

        public <T extends IndexedClassExpression> T update(T ice) {
            if (!ice.occurs() && this.increment > 0) {
                MainAxiomIndexerVisitor.this.index_.add(ice);
            }
            ice.updateAndCheckOccurrenceNumbers(MainAxiomIndexerVisitor.this.index_, this.increment, this.positiveIncrement, this.negativeIncrement);
            if (!ice.occurs() && this.increment < 0) {
                MainAxiomIndexerVisitor.this.index_.remove(ice);
            }
            return ice;
        }

        @Override
        public IndexedClass visit(IndexedClass element) {
            return this.update(MainAxiomIndexerVisitor.this.objectCache_.visit(element));
        }

        @Override
        public IndexedIndividual visit(IndexedIndividual element) {
            return this.update(MainAxiomIndexerVisitor.this.objectCache_.visit(element));
        }

        @Override
        public IndexedObjectComplementOf visit(IndexedObjectComplementOf element) {
            return this.update(MainAxiomIndexerVisitor.this.objectCache_.visit(element));
        }

        @Override
        public IndexedObjectIntersectionOf visit(IndexedObjectIntersectionOf element) {
            return this.update(MainAxiomIndexerVisitor.this.objectCache_.visit(element));
        }

        @Override
        public IndexedObjectSomeValuesFrom visit(IndexedObjectSomeValuesFrom element) {
            return this.update(MainAxiomIndexerVisitor.this.objectCache_.visit(element));
        }

        @Override
        public IndexedObjectUnionOf visit(IndexedObjectUnionOf element) {
            return this.update(MainAxiomIndexerVisitor.this.objectCache_.visit(element));
        }

        @Override
        public IndexedDataHasValue visit(IndexedDataHasValue element) {
            return this.update(MainAxiomIndexerVisitor.this.objectCache_.visit(element));
        }
    }
}

