/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDataHasValue;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObjectComplementOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectHasValue;
import org.semanticweb.elk.owl.interfaces.ElkObjectIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyChain;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkObjectUnionOf;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionVisitor;
import org.semanticweb.elk.owl.visitors.ElkIndividualVisitor;
import org.semanticweb.elk.owl.visitors.ElkSubObjectPropertyExpressionVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.AbstractIndexObjectConverter;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexObjectConverterFactory;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedDataHasValue;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectComplementOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectIntersectionOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectSomeValuesFrom;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectUnionOf;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassExpressionFilter;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedPropertyChainFilter;
import org.semanticweb.elk.util.logging.ElkMessage;

public class IndexObjectConverter
extends AbstractIndexObjectConverter {
    private static final Logger LOGGER_ = Logger.getLogger(IndexObjectConverter.class);
    private final IndexedClassExpressionFilter indexedClassFilter_;
    private final IndexedPropertyChainFilter indexedPropertyFilter_;
    private final IndexObjectConverter complementaryConverter_;

    public IndexObjectConverter(IndexedClassExpressionFilter indexedClassFilter, IndexedPropertyChainFilter indexedPropertyFilter, IndexObjectConverter complementaryConverter) {
        this.indexedClassFilter_ = indexedClassFilter;
        this.indexedPropertyFilter_ = indexedPropertyFilter;
        this.complementaryConverter_ = complementaryConverter;
    }

    public IndexObjectConverter(IndexedClassExpressionFilter indexedClassFilter, IndexedPropertyChainFilter indexedPropertyFilter) {
        this.indexedClassFilter_ = indexedClassFilter;
        this.indexedPropertyFilter_ = indexedPropertyFilter;
        this.complementaryConverter_ = this;
    }

    public IndexObjectConverter(IndexedClassExpressionFilter indexedClassFilter, IndexedPropertyChainFilter indexedPropertyFilter, IndexObjectConverterFactory complementaryConverterFactory) {
        this.indexedClassFilter_ = indexedClassFilter;
        this.indexedPropertyFilter_ = indexedPropertyFilter;
        this.complementaryConverter_ = complementaryConverterFactory.create(this);
    }

    public IndexObjectConverter getComplementaryConverter() {
        return this.complementaryConverter_;
    }

    @Override
    public IndexedClass visit(ElkClass elkClass) {
        return (IndexedClass)this.indexedClassFilter_.visit(new IndexedClass(elkClass));
    }

    @Override
    public IndexedClassExpression visit(ElkObjectHasValue elkObjectHasValue) {
        IndexedObjectProperty iop = (IndexedObjectProperty)((ElkObjectPropertyExpression)elkObjectHasValue.getProperty()).accept((ElkSubObjectPropertyExpressionVisitor)this);
        return (IndexedClassExpression)this.indexedClassFilter_.visit(new IndexedObjectSomeValuesFrom(iop, (IndexedClassExpression)((ElkIndividual)elkObjectHasValue.getFiller()).accept((ElkIndividualVisitor)this)));
    }

    @Override
    public IndexedClassExpression visit(ElkObjectComplementOf elkObjectComplementOf) {
        IndexedClassExpression negated = (IndexedClassExpression)elkObjectComplementOf.getClassExpression().accept((ElkClassExpressionVisitor)this.complementaryConverter_);
        return (IndexedClassExpression)this.indexedClassFilter_.visit(new IndexedObjectComplementOf(negated));
    }

    @Override
    public IndexedClassExpression visit(ElkObjectIntersectionOf elkObjectIntersectionOf) {
        IndexedClassExpression result = null;
        for (ElkClassExpression c : elkObjectIntersectionOf.getClassExpressions()) {
            IndexedClassExpression ice = (IndexedClassExpression)c.accept((ElkClassExpressionVisitor)this);
            if (result == null) {
                result = ice;
                continue;
            }
            result = (IndexedClassExpression)this.indexedClassFilter_.visit(new IndexedObjectIntersectionOf(result, ice));
        }
        return result;
    }

    @Override
    public IndexedClassExpression visit(ElkObjectSomeValuesFrom elkObjectSomeValuesFrom) {
        IndexedObjectProperty iop = (IndexedObjectProperty)((ElkObjectPropertyExpression)elkObjectSomeValuesFrom.getProperty()).accept((ElkSubObjectPropertyExpressionVisitor)this);
        return (IndexedClassExpression)this.indexedClassFilter_.visit(new IndexedObjectSomeValuesFrom(iop, (IndexedClassExpression)((ElkClassExpression)elkObjectSomeValuesFrom.getFiller()).accept((ElkClassExpressionVisitor)this)));
    }

    @Override
    public IndexedClassExpression visit(ElkObjectUnionOf elkObjectUnionOf) {
        ArrayList<IndexedClassExpression> conjuncts = new ArrayList<IndexedClassExpression>(elkObjectUnionOf.getClassExpressions().size());
        for (ElkClassExpression conjunct : elkObjectUnionOf.getClassExpressions()) {
            conjuncts.add((IndexedClassExpression)conjunct.accept((ElkClassExpressionVisitor)this));
        }
        return (IndexedClassExpression)this.indexedClassFilter_.visit(new IndexedObjectUnionOf(conjuncts));
    }

    @Override
    public IndexedClassExpression visit(ElkDataHasValue elkDataHasValue) {
        if (LOGGER_.isEnabledFor((Priority)Level.WARN)) {
            LOGGER_.warn((Object)ElkMessage.serialize((String)"reasoner.indexing.dataHasValue", (String)"ELK supports DataHasValue only partially. Reasoning might be incomplete!"));
        }
        return (IndexedClassExpression)this.indexedClassFilter_.visit(new IndexedDataHasValue(elkDataHasValue));
    }

    @Override
    public IndexedPropertyChain visit(ElkObjectProperty elkObjectProperty) {
        return (IndexedPropertyChain)this.indexedPropertyFilter_.visit(new IndexedObjectProperty(elkObjectProperty));
    }

    @Override
    public IndexedPropertyChain visit(ElkObjectPropertyChain elkObjectPropertyChain) {
        IndexedPropertyChain result = null;
        ListIterator iterator = elkObjectPropertyChain.getObjectPropertyExpressions().listIterator(elkObjectPropertyChain.getObjectPropertyExpressions().size());
        while (iterator.hasPrevious()) {
            IndexedObjectProperty iop = (IndexedObjectProperty)((ElkObjectPropertyExpression)iterator.previous()).accept((ElkSubObjectPropertyExpressionVisitor)this);
            if (result == null) {
                result = iop;
                continue;
            }
            result = (IndexedPropertyChain)this.indexedPropertyFilter_.visit(new IndexedBinaryPropertyChain(iop, result));
        }
        return result;
    }

    @Override
    public IndexedIndividual visit(ElkNamedIndividual elkNamedIndividual) {
        return (IndexedIndividual)this.indexedClassFilter_.visit(new IndexedIndividual(elkNamedIndividual));
    }
}

