


class CustomGetterObjectKlass:
    """
    Base class that wraps any payload and exposes dict keys as attributes.
    """

    def __init__(self, payload: dict):
        self._payload = payload or {}

    def __getattr__(self, item):
        """Allow accessing payload keys as attributes."""
        if item in self._payload:
            return self._payload[item]
        raise AttributeError(item)

    def __bool__(self):
        return bool(self._payload)
