"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackApp = exports.SlackAppManifestDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const secretsmanager = require("aws-cdk-lib/aws-secretsmanager");
const constructs_1 = require("constructs");
const manifest_1 = require("./manifest");
const provider_1 = require("./provider");
/**
 * A Slack app manifest definition
 */
class SlackAppManifestDefinition {
    /**
     * Create a Slack app manifest from a JSON app manifest encoded as a string
     */
    static fromString(manifest) {
        return new StringManifest(manifest);
    }
    /**
     * Creates a Slack app manifest from a file containg a JSON app manifest
     */
    static fromFile(file) {
        return new FileManifest(file);
    }
    /**
     * Creates a Slack app manifest by specifying properties
     */
    static fromManifest(props) {
        return new manifest_1.SlackAppManifest(props);
    }
}
exports.SlackAppManifestDefinition = SlackAppManifestDefinition;
_a = JSII_RTTI_SYMBOL_1;
SlackAppManifestDefinition[_a] = { fqn: "cloudstructs.SlackAppManifestDefinition", version: "0.4.25" };
class StringManifest extends SlackAppManifestDefinition {
    constructor(manifest) {
        super();
        this.manifest = manifest;
    }
    render(_construct) {
        return this.manifest;
    }
}
class FileManifest extends SlackAppManifestDefinition {
    constructor(file) {
        super();
        this.file = file;
    }
    render(_construct) {
        return fs.readFileSync(this.file, 'utf8');
    }
}
/**
 * A Slack application deployed with a manifest
 *
 * @see https://api.slack.com/reference/manifests
 */
class SlackApp extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _c;
        super(scope, id);
        const provider = provider_1.SlackAppProvider.getOrCreate(this);
        props.configurationTokenSecret.grantRead(provider.handler);
        props.configurationTokenSecret.grantWrite(provider.handler);
        this.credentials = (_c = props.credentialsSecret) !== null && _c !== void 0 ? _c : new secretsmanager.Secret(this, 'Credentials', {
            description: `Credentials for Slack App ${this.node.id}`,
        });
        this.credentials.grantWrite(provider.handler);
        const resource = new aws_cdk_lib_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::SlackApp',
            properties: {
                manifest: props.manifest.render(this),
                configurationTokenSecretArn: props.configurationTokenSecret.secretArn,
                credentialsSecretArn: this.credentials.secretArn,
            },
        });
        this.appId = resource.getAttString('appId');
        this.clientId = this.credentials.secretValueFromJson('clientId').toString();
        this.clientSecret = this.credentials.secretValueFromJson('clientSecret').toString();
        this.verificationToken = this.credentials.secretValueFromJson('verificationToken').toString();
        this.signingSecret = this.credentials.secretValueFromJson('signingSecret').toString();
    }
}
exports.SlackApp = SlackApp;
_b = JSII_RTTI_SYMBOL_1;
SlackApp[_b] = { fqn: "cloudstructs.SlackApp", version: "0.4.25" };
//# sourceMappingURL=data:application/json;base64,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