var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/url-shortener/shortener.lambda.ts
var shortener_lambda_exports = {};
__export(shortener_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(shortener_lambda_exports);
var import_aws_sdk = require("aws-sdk");
function base62Encode(int) {
  const characterSet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
  if (int === 0)
    return "0";
  let s = "";
  while (int > 0) {
    s = characterSet[int % 62] + s;
    int = Math.floor(int / 62);
  }
  return s;
}
function getEnv(name) {
  const value = process.env[name];
  if (!value) {
    throw new Error(`The environment variable ${name} is not defined`);
  }
  return value;
}
var documentClient = new import_aws_sdk.DynamoDB.DocumentClient({ apiVersion: "2012-08-10" });
var s3 = new import_aws_sdk.S3({ apiVersion: "2006-03-01" });
async function handler(event) {
  var _a;
  try {
    console.log("Event: %j", event);
    const body = JSON.parse(event.body ?? "{}");
    if (!body.url) {
      return {
        statusCode: 400,
        body: ""
      };
    }
    const update = await documentClient.update({
      TableName: getEnv("TABLE_NAME"),
      Key: { key: "counter" },
      UpdateExpression: "ADD #value :incr",
      ExpressionAttributeNames: { "#value": "value" },
      ExpressionAttributeValues: { ":incr": 1 },
      ReturnValues: "UPDATED_NEW"
    }).promise();
    const value = (_a = update.Attributes) == null ? void 0 : _a.value;
    if (!value) {
      throw new Error("Cannot get next counter value");
    }
    const key = base62Encode(value);
    console.log("Key: %j", key);
    const putObject = await s3.putObject({
      Bucket: getEnv("BUCKET_NAME"),
      Key: key,
      WebsiteRedirectLocation: body.url,
      ACL: "public-read"
    }).promise();
    console.log("Put object: %j", putObject);
    return {
      statusCode: 201,
      body: JSON.stringify({
        url: body.url,
        shortUrl: `https://${getEnv("DOMAIN_NAME")}/${key}`
      })
    };
  } catch (err) {
    console.log(err);
    return {
      statusCode: 500,
      body: ""
    };
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
