# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ShiftTradeMatchViolation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ShiftTradeMatchViolation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'params': 'dict(str, str)'
        }

        self.attribute_map = {
            'type': 'type',
            'params': 'params'
        }

        self._type = None
        self._params = None

    @property
    def type(self):
        """
        Gets the type of this ShiftTradeMatchViolation.
        The type of constraint violation

        :return: The type of this ShiftTradeMatchViolation.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ShiftTradeMatchViolation.
        The type of constraint violation

        :param type: The type of this ShiftTradeMatchViolation.
        :type: str
        """
        allowed_values = ["AgentCapabilityMismatch", "CannotTradeWithYourself", "DirectTradeForOtherUser", "InitiatingAgentScheduleDoesNotExist", "InitiatingShiftDisallowedActivityCategory", "InitiatingShiftDoesNotExist", "InitiatingShiftOverlapsExisting", "InitiatingShiftStartTooClose", "InitiatingShiftTimesChanged", "InitiatingWeeklyMaxPaidTime", "InitiatingWeeklyMinPaidTime", "InvalidState", "OneSidedTradeCreation", "ReceivingAgentScheduleDoesNotExist", "ReceivingShiftDisallowedActivityCategory", "ReceivingShiftDoesNotExist", "ReceivingShiftForOneSidedTrade", "ReceivingShiftMissingForTwoSidedTrade", "ReceivingShiftOutsideAcceptableIntervals", "ReceivingShiftOverlapsExisting", "ReceivingShiftStartTooClose", "ReceivingShiftTimesChanged", "ReceivingWeeklyMaxPaidTime", "ReceivingWeeklyMinPaidTime", "ShiftTradingNotEnabled", "UnequalPaidTime", "WeekScheduleDifferent", "WeekScheduleDoesNotExist", "WeekScheduleUnpublished"]
        if type.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for type -> " + type
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def params(self):
        """
        Gets the params of this ShiftTradeMatchViolation.
        Clarifying user params for constructing helpful error messages

        :return: The params of this ShiftTradeMatchViolation.
        :rtype: dict(str, str)
        """
        return self._params

    @params.setter
    def params(self, params):
        """
        Sets the params of this ShiftTradeMatchViolation.
        Clarifying user params for constructing helpful error messages

        :param params: The params of this ShiftTradeMatchViolation.
        :type: dict(str, str)
        """
        
        self._params = params

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

