# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:30 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.snap_prov_key import tSnapProvKey
from bs_loco.db.tables.snap_prov import tSnapProv

class dSnapProvLockOne:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tSnapProvKey()
        self.orec     = tSnapProv()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        valuedate: datetime.date,
                        corrtype_id: str,
                        corrprov_id: str) -> "dSnapProvLockOne":
        """
        Execute the query by setting all the inputs.

        :param valuedate: datetime.date
        :param corrtype_id: str
        :param corrprov_id: str
        :return: Self for convenience.
        """
        self.irec.valuedate = valuedate
        self.irec.corrtype_id = corrtype_id
        self.irec.corrprov_id = corrprov_id

        return await self.exec()

    async def exec(self, irec: tSnapProvKey = None) -> "dSnapProvLockOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("SnapProvLockOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  valuedate,
  corrtype_id,
  corrprov_id,
  msg_sent,
  msg_failed,
  msg_retry,
  avg_msgTime,
  tot_msgTime
from
  loco.SnapProv
where
  valuedate = :valuedate and
  corrtype_id = :corrtype_id and
  corrprov_id = :corrprov_id for update nowait""")

        self._dbstmnt.bind_in("valuedate", self.irec.valuedate, datetime.date)
        self._dbstmnt.bind_in("corrtype_id", self.irec.corrtype_id, str, 16)
        self._dbstmnt.bind_in("corrprov_id", self.irec.corrprov_id, str, 16)

        self._dbstmnt.bind_out("valuedate", datetime.date)
        self._dbstmnt.bind_out("corrtype_id", str, 16)
        self._dbstmnt.bind_out("corrprov_id", str, 16)
        self._dbstmnt.bind_out("msg_sent", int, 4)
        self._dbstmnt.bind_out("msg_failed", int, 4)
        self._dbstmnt.bind_out("msg_retry", int, 4)
        self._dbstmnt.bind_out("avg_msgTime", float)
        self._dbstmnt.bind_out("tot_msgTime", float)

        await self._dbcon.lock(self._dbstmnt)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.valuedate = self._dbstmnt.result[0]
        self.orec.corrtype_id = self._dbstmnt.result[1]
        self.orec.corrprov_id = self._dbstmnt.result[2]
        self.orec.msg_sent = self._dbstmnt.result[3]
        self.orec.msg_failed = self._dbstmnt.result[4]
        self.orec.msg_retry = self._dbstmnt.result[5]
        self.orec.avg_msg_time = self._dbstmnt.result[6]
        self.orec.tot_msg_time = self._dbstmnt.result[7]

        return True

    async def fetch_all(self, outList: tSnapProv.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

