# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:30 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.msg import tMsg

class dMsgInsert:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tMsg()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        id: int,
                        msgreq_id: int,
                        corrtype_id: str,
                        notype_id: str,
                        priority: int,
                        status: str,
                        retry_cnt: int,
                        fail_cnt: int,
                        time_sent: datetime.datetime,
                        time_taken: float,
                        corrprov_id: str,
                        msglog: dict,
                        payload: dict,
                        modified_by: str,
                        tm_stamp: datetime.datetime) -> "dMsgInsert":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :param msgreq_id: int
        :param corrtype_id: str
        :param notype_id: str
        :param priority: int
        :param status: str
        :param retry_cnt: int
        :param fail_cnt: int
        :param time_sent: datetime.datetime
        :param time_taken: float
        :param corrprov_id: str
        :param msglog: dict
        :param payload: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.msgreq_id = msgreq_id
        self.irec.corrtype_id = corrtype_id
        self.irec.notype_id = notype_id
        self.irec.priority = priority
        self.irec.status = status
        self.irec.retry_cnt = retry_cnt
        self.irec.fail_cnt = fail_cnt
        self.irec.time_sent = time_sent
        self.irec.time_taken = time_taken
        self.irec.corrprov_id = corrprov_id
        self.irec.msglog = msglog
        self.irec.payload = payload
        self.irec.modified_by = modified_by
        self.irec.tm_stamp = tm_stamp

        return await self.exec()

    async def exec(self, irec: tMsg = None) -> "dMsgInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("MsgInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into loco.Msg (
  msgreq_id,
  corrtype_id,
  notype_id,
  priority,
  status,
  retry_cnt,
  fail_cnt,
  time_sent,
  time_taken,
  corrprov_id,
  msglog,
  payload,
  modified_by,
  tm_stamp
) values (
  :msgreq_id,
  :corrtype_id,
  :notype_id,
  :priority,
  :status,
  :retry_cnt,
  :fail_cnt,
  :time_sent,
  :time_taken,
  :corrprov_id,
  :msglog,
  :payload,
  :modified_by,
  :tm_stamp
)""")

        self.irec.tm_stamp = await self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("msgreq_id", self.irec.msgreq_id, int, 8)
        self._dbstmnt.bind_in("corrtype_id", self.irec.corrtype_id, str, 16)
        self._dbstmnt.bind_in("notype_id", self.irec.notype_id, str, 128)
        self._dbstmnt.bind_in("priority", self.irec.priority, int, 4)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("retry_cnt", self.irec.retry_cnt, int, 4)
        self._dbstmnt.bind_in("fail_cnt", self.irec.fail_cnt, int, 4)
        self._dbstmnt.bind_in("time_sent", self.irec.time_sent, datetime.datetime)
        self._dbstmnt.bind_in("time_taken", self.irec.time_taken, float)
        self._dbstmnt.bind_in("corrprov_id", self.irec.corrprov_id, str, 16)
        self._dbstmnt.bind_in("msglog", self.irec.msglog, dict)
        self._dbstmnt.bind_in("payload", self.irec.payload, dict)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        self.irec.id = await self._dbcon.post_get_sequence(self._dbstmnt, "loco.Msg", "id", 8)

        if irec:
            irec._copy_from(self.irec)

        return self

