# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:30 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.imsg_for_processing import iMsgForProcessing
from bs_loco.db.tables.omsg_for_processing import oMsgForProcessing

class dMsgForProcessing:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = iMsgForProcessing()
        self.orec     = oMsgForProcessing()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        criteria: str,
                        date_curr: datetime.datetime,
                        limit: int) -> "dMsgForProcessing":
        """
        Execute the query by setting all the inputs.

        :param criteria: str
        :param date_curr: datetime.datetime
        :param limit: int
        :return: Self for convenience.
        """
        self.irec.criteria = criteria
        self.irec.date_curr = date_curr
        self.irec.limit = limit

        return await self.exec()

    async def exec(self, irec: iMsgForProcessing = None) -> "dMsgForProcessing":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("MsgForProcessing", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  m.id,
  m.corrtype_id,
  m.status,
  m.priority
from
  loco.msg m
    join
  loco.msgreq r
    on m.msgreq_id = r.id
where
  m.status in ('P', 'R')      and
  r.time_to_send <= :dateCurr and
  r.status in ('B', 'P')
  [criteria]
order by
  m.priority,
  m.id
limit :limit""")

        self._dbstmnt.dynamic("[criteria]", self.irec.criteria)

        self._dbstmnt.bind_in("dateCurr", self.irec.date_curr, datetime.datetime)
        self._dbstmnt.bind_in("limit", self.irec.limit, int, 4)

        self._dbstmnt.bind_out("id", int, 8)
        self._dbstmnt.bind_out("corrtype_id", str, 16)
        self._dbstmnt.bind_out("status", str, 1)
        self._dbstmnt.bind_out("priority", int, 4)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.id = self._dbstmnt.result[0]
        self.orec.corrtype_id = self._dbstmnt.result[1]
        self.orec.status = self._dbstmnt.result[2]
        self.orec.priority = self._dbstmnt.result[3]

        return True

    async def fetch_all(self, outList: oMsgForProcessing.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

