# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Wed May 11 09:28:30 2022
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.snap_prov_key import tSnapProvKey

class dSnapProvDeleteOne:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tSnapProvKey()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  valuedate: datetime.date,
                  corrtype_id: str,
                  corrprov_id: str) -> "dSnapProvDeleteOne":
        """
        Execute the query by setting all the inputs.

        :param valuedate: datetime.date
        :param corrtype_id: str
        :param corrprov_id: str
        :return: Self for convenience.
        """
        self.irec.valuedate = valuedate
        self.irec.corrtype_id = corrtype_id
        self.irec.corrprov_id = corrprov_id

        return self.exec()

    def exec(self, irec: tSnapProvKey = None) -> "dSnapProvDeleteOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("SnapProvDeleteOne", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""delete from
  loco.SnapProv
where
  valuedate = :valuedate and
  corrtype_id = :corrtype_id and
  corrprov_id = :corrprov_id""")

        self._dbstmnt.bind_in("valuedate", self.irec.valuedate, datetime.date)
        self._dbstmnt.bind_in("corrtype_id", self.irec.corrtype_id, str, 16)
        self._dbstmnt.bind_in("corrprov_id", self.irec.corrprov_id, str, 16)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

