# mypy-boto3-sso-oidc

[![PyPI - mypy-boto3-sso-oidc](https://img.shields.io/pypi/v/mypy-boto3-sso-oidc.svg?color=blue)](https://pypi.org/project/mypy-boto3-sso-oidc)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-sso-oidc.svg?color=blue)](https://pypi.org/project/mypy-boto3-sso-oidc)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.SSOOIDC 1.14.25](https://boto3.amazonaws.com/v1/documentation/api/1.14.25/reference/services/sso-oidc.html#SSOOIDC) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `SSOOIDC` service.

```bash
python -m pip install boto3-stubs[sso-oidc]
```

## How to use

### Client annotations

`SSOOIDCClient` provides annotations for `boto3.client("sso-oidc")`.

```python
import boto3

from mypy_boto3_sso_oidc import SSOOIDCClient
from mypy_boto3_sso_oidc.type_defs import CreateTokenResponseTypeDef, ...

client: SSOOIDCClient = boto3.client("sso-oidc")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SSOOIDCClient = session.client("sso-oidc")
```








### Typed dictionations

`mypy_boto3_sso_oidc.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> CreateTokenResponseTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_sso_oidc` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("sso-oidc")

session_client = boto3.Session().client("sso-oidc")
```
