/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.HasIndex;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.DependencyFactory;
import edu.stanford.nlp.trees.UnnamedDependency;
import edu.stanford.nlp.util.XMLUtils;

public class UnnamedConcreteDependency
extends UnnamedDependency {
    private static final long serialVersionUID = -8836949694741145222L;
    private final int headIndex;
    private final int depIndex;

    public UnnamedConcreteDependency(String regent, int regentIndex, String dependent, int dependentIndex) {
        super(regent, dependent);
        this.headIndex = regentIndex;
        this.depIndex = dependentIndex;
    }

    public UnnamedConcreteDependency(Label regent, int regentIndex, Label dependent, int dependentIndex) {
        super(regent, dependent);
        this.headIndex = regentIndex;
        this.depIndex = dependentIndex;
    }

    public UnnamedConcreteDependency(Label regent, Label dependent) {
        super(regent, dependent);
        if (!(this.governor() instanceof HasIndex)) {
            throw new IllegalArgumentException("Label argument lacks IndexAnnotation.");
        }
        this.headIndex = ((HasIndex)((Object)this.governor())).index();
        if (!(this.dependent() instanceof HasIndex)) {
            throw new IllegalArgumentException("Label argument lacks IndexAnnotation.");
        }
        this.depIndex = ((HasIndex)((Object)this.dependent())).index();
    }

    public int getGovernorIndex() {
        return this.headIndex;
    }

    public int getDependentIndex() {
        return this.depIndex;
    }

    @Override
    public int hashCode() {
        return this.headIndex * (this.depIndex << 16);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnnamedConcreteDependency)) {
            return false;
        }
        UnnamedConcreteDependency d = (UnnamedConcreteDependency)o;
        return this.headIndex == d.headIndex && this.depIndex == d.depIndex;
    }

    @Override
    public String toString() {
        String headWord = this.getText(this.governor());
        String depWord = this.getText(this.dependent());
        return String.format("%s [%d] --> %s [%d]", headWord, this.headIndex, depWord, this.depIndex);
    }

    @Override
    public String toString(String format) {
        switch (format) {
            case "xml": {
                String govIdxStr = " idx=\"" + this.headIndex + "\"";
                String depIdxStr = " idx=\"" + this.depIndex + "\"";
                return "  <dep>\n    <governor" + govIdxStr + ">" + XMLUtils.escapeXML(this.governor().value()) + "</governor>\n    <dependent" + depIdxStr + ">" + XMLUtils.escapeXML(this.dependent().value()) + "</dependent>\n  </dep>";
            }
            case "predicate": {
                return "dep(" + this.governor() + "," + this.dependent() + ")";
            }
        }
        return this.toString();
    }

    @Override
    public DependencyFactory dependencyFactory() {
        return DependencyFactoryHolder.df;
    }

    public static DependencyFactory factory() {
        return DependencyFactoryHolder.df;
    }

    private static class UnnamedConcreteDependencyFactory
    implements DependencyFactory {
        private UnnamedConcreteDependencyFactory() {
        }

        @Override
        public Dependency<Label, Label, Object> newDependency(Label regent, Label dependent) {
            return this.newDependency(regent, dependent, null);
        }

        @Override
        public Dependency<Label, Label, Object> newDependency(Label regent, Label dependent, Object name) {
            return new UnnamedConcreteDependency(regent, dependent);
        }
    }

    private static class DependencyFactoryHolder {
        private static final DependencyFactory df = new UnnamedConcreteDependencyFactory();

        private DependencyFactoryHolder() {
        }
    }
}

