/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import java.io.Serializable;

public class MultiTokenTag
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Tag tag;
    public int index;

    public MultiTokenTag(Tag tag, int index) {
        this.tag = tag;
        this.index = index;
    }

    public boolean isStart() {
        return this.index == 0;
    }

    public boolean isEnd() {
        return this.index == this.tag.length - 1;
    }

    public String toString() {
        return this.tag.name + "/" + this.tag.tag + "(" + this.index + "/" + this.tag.length + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTokenTag that = (MultiTokenTag)o;
        if (this.index != that.index) {
            return false;
        }
        return this.tag.equals(that.tag);
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = 31 * result + this.index;
        return result;
    }

    public static class Tag
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String name;
        public String tag;
        public int length;

        public Tag(String name, String tag, int length) {
            this.name = name;
            this.tag = tag;
            this.length = length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tag tag1 = (Tag)o;
            if (this.length != tag1.length) {
                return false;
            }
            if (!this.name.equals(tag1.name)) {
                return false;
            }
            return this.tag.equals(tag1.tag);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.tag.hashCode();
            result = 31 * result + this.length;
            return result;
        }
    }
}

