import unittest
from paperstorage import PaperStorage

class TestRestoration(unittest.TestCase):

	def setUp(self):
		self.testDataStr = "Als Gregor Samsa eines Morgens aus unruhigen Träumen erwachte, fand er sich in seinem Bett zu einem ungeheueren Ungeziefer verwandelt. Er lag auf seinem panzerartig harten Rücken und sah, wenn er den Kopf ein wenig hob, seinen gewölbten, braunen, von bogenförmigen Versteifungen geteilten Bauch, auf dessen Höhe sich die Bettdecke, zum gänzlichen Niedergleiten bereit, kaum noch erhalten konnte. Seine vielen, im Vergleich zu seinem sonstigen Umfang kläglich dünnen Beine flimmerten ihm hilflos vor den Augen. " * 10
		self.testDocument = PaperStorage()
		
	def testRestore(self):
		self.assertEqual(self.testDocument.restoreFromQRString('hcpb01,AAy=InvalidInvalidInvalid'), False) # invalid qr meta string
		self.assertEqual(self.testDocument.restoreFromQRString('InvalidInvalidInvalid'), False) # completly invalid string

		self.assertEqual(self.testDocument.restoreFromFolder('paperstorage/tests/sample_images'), False)
		self.assertEqual(self.testDocument.getMissingDataBlocks(), [2])
		self.assertEqual(self.testDocument.restoreFromQRString('AAI=NhE=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'),
			True)
		self.assertEqual(self.testDocument.isDataReady(), True)

		self.assertEqual(self.testDocument.getData(), bytes(self.testDataStr.encode('utf-8')))

