#!/usr/bin/env python
"""Some physical constants.

"""
from __future__ import division
#: Electron mass (eV)
ELECTRON_MASS = 0.51099892e6
#: Electron charge (C)
ELECTRON_CHARGE = -1.60217653e-19
#: Electron anomalous magnetic moment
ELECTRON_ANOM_MAG_MOM = (2.0023193043622 -2)/2 # from http://en.wikipedia.org/wiki/G-factor
#: Electron lifetime
ELECTRON_MEAN_LIFE = 0 #does not decay

#: Proton mass (eV)
PROTON_MASS = 938.27203e6
#: Proton charge (C)
PROTON_CHARGE = 1.602176487e-19
#: Proton anomalous magnetic moment
PROTON_ANOM_MAG_MOM = (5.585694701 -2)/2 # from http://en.wikipedia.org/wiki/G-factor
#: Proton lifetime
PROTON_MEAN_LIFE = 0

#: Muon mass (eV)
MUON_MASS = 105.65837e6
#: Muon charge (C)
MUON_CHARGE = -1.60217653e-19
#: Muon anomalous magnetic moment
MUON_ANOM_MAG_MOM = (2.0023318396 -2)/2 # from http://en.wikipedia.org/wiki/G-factor
#: Muon lifetime
MUON_MEAN_LIFE = 2.197029e-6

#: Pion mass (eV) 
PION_MASS = 139.57018e6 #PDG2015
#: Pion charge (C)
PION_CHARGE = 1.60217653e-19
#: Pion lifetime
PION_MEAN_LIFE = 2.6033e-8 #PDG2015

#: Speed of light (m/s)
SPEED_OF_LIGHT = 299792458

#: Atomic mass unit (eV)
ATOMIC_MASS_UNIT = 931.494028e6

