/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.PythonException;
import net.razorvine.pyro.Config;
import net.razorvine.pyro.IOUtil;
import net.razorvine.pyro.Message;
import net.razorvine.pyro.PyroException;
import net.razorvine.pyro.PyroURI;
import net.razorvine.pyro.serializer.PyroSerializer;

public class PyroProxy
implements Serializable {
    private static final long serialVersionUID = -5564313476693913031L;
    public String hostname;
    public int port;
    public String objectid;
    public byte[] pyroHmacKey = null;
    public UUID correlation_id = null;
    public Object pyroHandshake = "hello";
    private transient int sequenceNr = 0;
    private transient Socket sock;
    private transient OutputStream sock_out;
    private transient InputStream sock_in;
    public Set<String> pyroMethods = new HashSet<String>();
    public Set<String> pyroAttrs = new HashSet<String>();
    public Set<String> pyroOneway = new HashSet<String>();
    private static final HashSet<String> stopIterationExceptions = new HashSet();

    public PyroProxy() {
    }

    public PyroProxy(PyroURI uri) throws UnknownHostException, IOException {
        this(uri.host, uri.port, uri.objectid);
    }

    public PyroProxy(String hostname, int port, String objectid) throws UnknownHostException, IOException {
        this.hostname = hostname;
        this.port = port;
        this.objectid = objectid;
    }

    protected void connect() throws UnknownHostException, IOException {
        if (this.sock == null) {
            this.sock = new Socket(this.hostname, this.port);
            this.sock.setKeepAlive(true);
            this.sock.setTcpNoDelay(true);
            this.sock_out = this.sock.getOutputStream();
            this.sock_in = this.sock.getInputStream();
            this.sequenceNr = 0;
            this._handshake();
            if (Config.METADATA && this.pyroMethods.isEmpty() && this.pyroAttrs.isEmpty()) {
                this.getMetadata(this.objectid);
            }
        }
    }

    protected void getMetadata(String objectId) throws PickleException, PyroException, IOException {
        HashMap result;
        if (objectId == null) {
            objectId = this.objectid;
        }
        if (this.sock == null) {
            this.connect();
            if (!this.pyroMethods.isEmpty() || !this.pyroAttrs.isEmpty()) {
                return;
            }
        }
        if ((result = (HashMap)this.internal_call("get_metadata", Config.DAEMON_NAME, 0, false, objectId)) == null) {
            return;
        }
        this._processMetadata(result);
    }

    private void _processMetadata(HashMap<String, Object> result) {
        int i;
        Object methods = result.get("methods");
        Object attrs = result.get("attrs");
        Object oneways = result.get("oneways");
        if (methods instanceof Object[]) {
            Object[] methods_array = (Object[])methods;
            this.pyroMethods = new HashSet<String>();
            for (i = 0; i < methods_array.length; ++i) {
                this.pyroMethods.add((String)methods_array[i]);
            }
        } else if (methods != null) {
            this.pyroMethods = this.getSetOfStrings(methods);
        }
        if (attrs instanceof Object[]) {
            Object[] attrs_array = (Object[])attrs;
            this.pyroAttrs = new HashSet<String>();
            for (i = 0; i < attrs_array.length; ++i) {
                this.pyroAttrs.add((String)attrs_array[i]);
            }
        } else if (attrs != null) {
            this.pyroAttrs = this.getSetOfStrings(attrs);
        }
        if (oneways instanceof Object[]) {
            Object[] oneways_array = (Object[])oneways;
            this.pyroOneway = new HashSet<String>();
            for (i = 0; i < oneways_array.length; ++i) {
                this.pyroOneway.add((String)oneways_array[i]);
            }
        } else if (oneways != null) {
            this.pyroOneway = this.getSetOfStrings(oneways);
        }
        if (this.pyroMethods.isEmpty() && this.pyroAttrs.isEmpty()) {
            throw new PyroException("remote object doesn't expose any methods or attributes");
        }
    }

    protected HashSet<String> getSetOfStrings(Object strings) {
        try {
            return (HashSet)strings;
        }
        catch (ClassCastException ex) {
            Collection list = (Collection)strings;
            return new HashSet<String>(list);
        }
    }

    public Object call(String method, Object ... arguments) throws PickleException, PyroException, IOException {
        return this.internal_call(method, null, 0, true, arguments);
    }

    public void call_oneway(String method, Object ... arguments) throws PickleException, PyroException, IOException {
        this.internal_call(method, null, 4, true, arguments);
    }

    public Object getattr(String attr) throws PickleException, PyroException, IOException {
        return this.internal_call("__getattr__", null, 0, false, attr);
    }

    public void setattr(String attr, Object value) throws PickleException, PyroException, IOException {
        this.internal_call("__setattr__", null, 0, false, attr, value);
    }

    public SortedMap<String, byte[]> annotations() {
        TreeMap<String, byte[]> ann = new TreeMap<String, byte[]>();
        if (this.correlation_id != null) {
            long hi = this.correlation_id.getMostSignificantBits();
            long lo = this.correlation_id.getLeastSignificantBits();
            ann.put("CORR", ByteBuffer.allocate(16).putLong(hi).putLong(lo).array());
        }
        return ann;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object internal_call(String method, String actual_objectId, int flags, boolean checkMethodName, Object ... parameters) throws PickleException, PyroException, IOException {
        Message resultmsg;
        if (actual_objectId == null) {
            actual_objectId = this.objectid;
        }
        PyroProxy pyroProxy = this;
        synchronized (pyroProxy) {
            this.connect();
            this.sequenceNr = this.sequenceNr + 1 & 0xFFFF;
        }
        if (this.pyroAttrs.contains(method)) {
            throw new PyroException("cannot call an attribute");
        }
        if (this.pyroOneway.contains(method)) {
            flags |= 4;
        }
        if (checkMethodName && Config.METADATA && !this.pyroMethods.contains(method)) {
            throw new PyroException(String.format("remote object '%s' has no exposed attribute or method '%s'", actual_objectId, method));
        }
        if (parameters == null) {
            parameters = new Object[]{};
        }
        PyroSerializer ser = PyroSerializer.getFor(Config.SERIALIZER);
        byte[] pickle = ser.serializeCall(actual_objectId, method, parameters, Collections.emptyMap());
        Message msg = new Message(4, pickle, ser.getSerializerId(), flags, this.sequenceNr, this.annotations(), this.pyroHmacKey);
        Socket socket = this.sock;
        synchronized (socket) {
            IOUtil.send(this.sock_out, msg.to_bytes());
            if (Config.MSG_TRACE_DIR != null) {
                Message.TraceMessageSend(this.sequenceNr, msg.get_header_bytes(), msg.get_annotations_bytes(), msg.data);
            }
            pickle = null;
            if ((flags & 4) != 0) {
                return null;
            }
            resultmsg = Message.recv(this.sock_in, new int[]{5}, this.pyroHmacKey);
        }
        if (resultmsg.seq != this.sequenceNr) {
            throw new PyroException("result msg out of sync");
        }
        this.responseAnnotations(resultmsg.annotations, resultmsg.type);
        if ((resultmsg.flags & 2) != 0) {
            this._decompressMessageData(resultmsg);
        }
        if ((resultmsg.flags & 0x20) != 0) {
            byte[] streamId = (byte[])resultmsg.annotations.get("STRM");
            if (streamId == null) {
                throw new PyroException("result of call is an iterator, but the server is not configured to allow streaming");
            }
            return new StreamResultIterable(new String(streamId), this);
        }
        if ((resultmsg.flags & 1) != 0) {
            PyroException px;
            Throwable rx = (Throwable)ser.deserializeData(resultmsg.data);
            if (rx instanceof PyroException) {
                throw (PyroException)rx;
            }
            if (rx instanceof PythonException) {
                PythonException rxp = (PythonException)rx;
                px = new PyroException(rxp.getMessage(), rxp);
                px.pythonExceptionType = rxp.pythonExceptionType;
            } else {
                px = new PyroException(null, rx);
            }
            try {
                String remotetb;
                Field remotetbField = rx.getClass().getDeclaredField("_pyroTraceback");
                px._pyroTraceback = remotetb = (String)remotetbField.get(rx);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw px;
        }
        return ser.deserializeData(resultmsg.data);
    }

    private void _decompressMessageData(Message msg) {
        if ((msg.flags & 2) == 0) {
            throw new IllegalArgumentException("message data is not compressed");
        }
        Inflater decompresser = new Inflater();
        decompresser.setInput(msg.data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(msg.data.length);
        byte[] buffer = new byte[8192];
        try {
            while (!decompresser.finished()) {
                int size = decompresser.inflate(buffer);
                bos.write(buffer, 0, size);
            }
            msg.data = bos.toByteArray();
            msg.flags &= 0xFFFFFFFD;
            decompresser.end();
        }
        catch (DataFormatException e) {
            throw new PyroException("invalid compressed data: ", e);
        }
    }

    public void close() {
        if (this.sock != null) {
            try {
                this.sock_in.close();
                this.sock_out.close();
                this.sock.close();
                this.sock = null;
                this.sock_in = null;
                this.sock_out = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void _handshake() throws IOException {
        PyroSerializer ser = PyroSerializer.getFor(Config.SERIALIZER);
        HashMap<String, Object> handshakedata = new HashMap<String, Object>();
        handshakedata.put("handshake", this.pyroHandshake);
        if (Config.METADATA) {
            handshakedata.put("object", this.objectid);
        }
        byte[] data = ser.serializeData(handshakedata);
        int flags = Config.METADATA ? 16 : 0;
        Message msg = new Message(1, data, ser.getSerializerId(), flags, this.sequenceNr, this.annotations(), this.pyroHmacKey);
        IOUtil.send(this.sock_out, msg.to_bytes());
        if (Config.MSG_TRACE_DIR != null) {
            Message.TraceMessageSend(this.sequenceNr, msg.get_header_bytes(), msg.get_annotations_bytes(), msg.data);
        }
        msg = Message.recv(this.sock_in, new int[]{2, 3}, this.pyroHmacKey);
        this.responseAnnotations(msg.annotations, msg.type);
        Object handshake_response = "?";
        if (msg.data != null) {
            if ((msg.flags & 2) != 0) {
                this._decompressMessageData(msg);
            }
            try {
                ser = PyroSerializer.getFor(msg.serializer_id);
                handshake_response = ser.deserializeData(msg.data);
            }
            catch (Exception x) {
                msg.type = 3;
                handshake_response = "<not available because unsupported serialization format>";
            }
        }
        if (msg.type == 2) {
            if ((msg.flags & 0x10) != 0) {
                HashMap response_dict = (HashMap)handshake_response;
                HashMap metadata = (HashMap)response_dict.get("meta");
                this._processMetadata(metadata);
                handshake_response = response_dict.get("handshake");
                try {
                    this.validateHandshake(handshake_response);
                }
                catch (IOException x) {
                    this.close();
                    throw x;
                }
            }
        } else {
            if (msg.type == 3) {
                this.close();
                throw new PyroException("connection rejected, reason: " + handshake_response);
            }
            this.close();
            throw new PyroException("connect: invalid msg type " + msg.type + " received");
        }
    }

    public void validateHandshake(Object response) throws IOException {
    }

    public void responseAnnotations(SortedMap<String, byte[]> annotations, int msgtype) {
    }

    public void __setstate__(Object[] args) throws IOException {
        if (args.length != 8 && args.length != 9) {
            throw new PyroException("invalid pickled proxy, using wrong pyro version?");
        }
        PyroURI uri = (PyroURI)args[0];
        this.hostname = uri.host;
        this.port = uri.port;
        this.objectid = uri.objectid;
        this.sock = null;
        this.sock_in = null;
        this.sock_out = null;
        this.correlation_id = null;
        this.pyroOneway = args[1] instanceof Set ? (Set<Object>)args[1] : new HashSet<String>((Collection)args[1]);
        this.pyroMethods = args[2] instanceof Set ? (Set<Object>)args[2] : new HashSet<String>((Collection)args[2]);
        this.pyroAttrs = args[3] instanceof Set ? (Set<Object>)args[3] : new HashSet<String>((Collection)args[3]);
        this.pyroHmacKey = (byte[])args[5];
        this.pyroHandshake = args[6];
    }

    static {
        stopIterationExceptions.add("builtins.StopIteration");
        stopIterationExceptions.add("builtins.StopAsyncIteration");
        stopIterationExceptions.add("__builtin__.StopIteration");
        stopIterationExceptions.add("__builtin__.StopAsyncIteration");
        stopIterationExceptions.add("exceptions.StopIteration");
        stopIterationExceptions.add("builtins.GeneratorExit");
        stopIterationExceptions.add("__builtin__.GeneratorExit");
        stopIterationExceptions.add("exceptions.GeneratorExit");
    }

    public class StreamResultIterable
    implements Iterable<Object> {
        private String streamId;
        private PyroProxy proxy;

        public StreamResultIterable(String streamId, PyroProxy proxy) {
            this.streamId = streamId;
            this.proxy = proxy;
        }

        @Override
        public Iterator<Object> iterator() {
            return new StreamResultIterator(this.streamId, this.proxy);
        }

        public class StreamResultIterator<T>
        implements Iterator<Object> {
            private String streamId;
            private PyroProxy proxy;
            private Object nextValue;
            private Boolean getRemoteNext;
            private Boolean exhausted;

            public StreamResultIterator(String streamId, PyroProxy proxy) {
                this.streamId = streamId;
                this.proxy = proxy;
                this.getRemoteNext = true;
                this.exhausted = false;
            }

            @Override
            public boolean hasNext() {
                if (this.exhausted.booleanValue()) {
                    return false;
                }
                if (this.getRemoteNext.booleanValue()) {
                    this.nextValue = this.get_next();
                    this.getRemoteNext = false;
                }
                return this.nextValue != null;
            }

            @Override
            public Object next() {
                if (this.proxy == null) {
                    this.exhausted = true;
                    throw new NoSuchElementException("no proxy connected anymore");
                }
                if (this.hasNext()) {
                    this.getRemoteNext = true;
                    return this.nextValue;
                }
                this.exhausted = true;
                throw new NoSuchElementException("iterator exhausted");
            }

            protected Object get_next() {
                if (this.proxy.sock == null) {
                    throw new PyroException("the proxy for this stream result has been closed");
                }
                Object value = null;
                try {
                    value = this.proxy.internal_call("get_next_stream_item", Config.DAEMON_NAME, 0, false, new Object[]{this.streamId});
                }
                catch (PyroException x) {
                    this.exhausted = true;
                    if (stopIterationExceptions.contains(x.pythonExceptionType)) {
                        this.proxy = null;
                        return null;
                    }
                    this.close();
                    throw x;
                }
                catch (IOException x) {
                    this.close();
                    throw new PyroException("I/O error while getting next iter element", x);
                }
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("cannot remove things from pyro iter");
            }

            public void close() throws PyroException {
                if (this.proxy != null && this.proxy.sock != null) {
                    try {
                        this.proxy.internal_call("close_stream", Config.DAEMON_NAME, 4, false, new Object[]{this.streamId});
                    }
                    catch (IOException | PickleException exception) {
                        // empty catch block
                    }
                }
                this.proxy = null;
                this.nextValue = null;
            }
        }
    }
}

